<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Quality Grill - Sistema Premium</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;800&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
    
    <style>
        :root { --primary-red: #c00d0d; --bg-color: #f4f7f6; --border-radius: 12px; }
        body { background-color: var(--bg-color); font-family: 'Inter', sans-serif; padding-bottom: 120px; }
        
        /* Navbar */
        .navbar-premium { background: #fff; box-shadow: 0 4px 15px rgba(0,0,0,0.05); padding: 15px 0; margin-bottom: 30px; }
        .logo-img { height: 60px; width: auto; }
        
        /* Cards */
        .card-premium { background: #fff; border: none; border-radius: var(--border-radius); box-shadow: 0 5px 20px rgba(0,0,0,0.03); padding: 25px; margin-bottom: 20px; }
        
        /* Inputs */
        .form-label { font-size: 0.75rem; font-weight: 700; text-transform: uppercase; color: #999; margin-bottom: 5px; }
        .form-control-lg-custom { border: 2px solid #eee; border-radius: 8px; padding: 12px; font-weight: 500; }
        .form-control-lg-custom:focus { border-color: var(--primary-red); box-shadow: none; background: #fff; }
        
        /* Botões */
        .btn-add { background: var(--primary-red); color: white; border: none; border-radius: 8px; padding: 14px; width: 100%; font-weight: 700; text-transform: uppercase; }
        .btn-add:hover { background: #a00000; color: white; }
        
        .btn-menu { background: #fff; border: 1px solid #eee; border-radius: 50px; padding: 8px 20px; font-size: 0.9rem; font-weight: 600; color: #555; }
        .btn-menu:hover { background: #f9f9f9; color: var(--primary-red); border-color: var(--primary-red); }

        /* Footer */
        .footer-fixed { position: fixed; bottom: 0; left: 0; right: 0; background: rgba(255,255,255,0.95); padding: 15px 20px; border-top: 1px solid #eee; z-index: 1000; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 -5px 20px rgba(0,0,0,0.05); }
        .total-valor { font-size: 1.5rem; font-weight: 800; color: var(--primary-red); }
        
        /* Modal Leitor */
        #leitor-camera { width: 100%; border-radius: 10px; overflow: hidden; background: #000; }
        .area-importacao { width: 100%; height: 200px; padding: 15px; border: 2px dashed #ccc; border-radius: 8px; background: #fafafa; font-family: monospace; }

        @media (max-width: 768px) { .navbar-premium { flex-direction: column; gap: 15px; } .btn-menu { width: 100%; } .footer-fixed { flex-direction: column; gap: 10px; } .footer-actions { width: 100%; display: flex; gap: 10px; } .footer-actions .btn { flex: 1; } }
    </style>
</head>
<body>

<nav class="navbar-premium">
    <div class="container d-flex flex-column flex-md-row justify-content-between align-items-center">
        <img src="https://mgatv.com.br/quality/quality.png" alt="Logo" class="logo-img">
        <div class="d-flex flex-wrap justify-content-center gap-2 mt-3 mt-md-0">
            <button class="btn-menu" onclick="novoOrcamento()"><i class="fas fa-plus text-warning"></i> Novo</button>
            <button class="btn-menu" onclick="abrirModalLista()"><i class="far fa-folder-open text-primary"></i> Rascunhos</button>
            <button class="btn-menu" onclick="abrirModalPDFs()"><i class="far fa-file-pdf text-danger"></i> Histórico</button>
            <button class="btn-menu" onclick="abrirModalProdutos()"><i class="fas fa-box text-success"></i> Produtos</button>
        </div>
    </div>
</nav>

<div class="container">
    <form id="form-orcamento" action="gerar_pdf.php" method="POST" target="_blank">
        
        <div class="card-premium">
            <div class="row align-items-end g-3">
                <div class="col-md-9">
                    <label class="form-label">Cliente / Evento</label>
                    <input type="text" name="cliente_nome" id="cliente_nome" class="form-control form-control-lg-custom" placeholder="Ex: Churrasco do João" required>
                    <input type="hidden" name="data_orcamento" id="data_orcamento">
                </div>
                <div class="col-md-3">
                    <button type="button" class="btn btn-outline-secondary w-100 py-2 fw-bold" onclick="salvarNoServidor()"><i class="far fa-save"></i> Salvar</button>
                </div>
            </div>
        </div>

        <div class="card-premium position-relative overflow-hidden">
            <div style="position:absolute; top:0; left:0; width:5px; height:100%; background:var(--primary-red);"></div>
            <h5 class="fw-bold mb-4 text-secondary"><i class="fas fa-cart-plus me-2"></i>Adicionar Item</h5>
            
            <div class="row g-3">
                <div class="col-12 col-md-5">
                    <label class="form-label">Produto</label>
                    <div class="input-group">
                        <input type="text" id="novo_nome" class="form-control form-control-lg-custom" list="listaSugestoes" oninput="buscarPrecoAutomatico()" placeholder="Buscar...">
                        <button type="button" class="btn btn-dark" onclick="abrirLeitorBarcode()"><i class="fas fa-barcode"></i></button>
                    </div>
                    <datalist id="listaSugestoes"></datalist>
                </div>
                
                <div class="col-6 col-md-2">
                    <label class="form-label">Medida</label>
                    <div class="input-group">
                        <input type="text" id="novo_unidade" class="form-control form-control-lg-custom" placeholder="Un..." list="listaMedidas">
                        <button class="btn btn-light border fw-bold text-muted" type="button" onclick="document.getElementById('novo_unidade').value='kg'">kg</button>
                        <button class="btn btn-light border dropdown-toggle" type="button" data-bs-toggle="dropdown"></button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" onclick="setMedida('un')">Unidade</a></li>
                            <li><a class="dropdown-item" onclick="setMedida('lata')">Lata</a></li>
                             <li><a class="dropdown-item" onclick="setMedida('latao')">Latão</a></li>
                            <li><a class="dropdown-item" onclick="setMedida('fdo')">Fardo</a></li>
                            <li><a class="dropdown-item" onclick="setMedida('pct')">Pacote</a></li>
                            <li><a class="dropdown-item" onclick="setMedida('cx')">Caixa</a></li>
                            <li><a class="dropdown-item" onclick="setMedida('gf')">Garrafa</a></li>
                        </ul>
                    </div>
                    <datalist id="listaMedidas"><option value="un"><option value="kg"><option value="lata"><option value="pct"><option value="cx"></datalist>
                </div>

                <div class="col-6 col-md-2">
                    <label class="form-label text-center d-block">Qtd</label>
                    <input type="number" id="novo_qtd" class="form-control form-control-lg-custom text-center" value="1" step="0.01" oninput="atualizarPreviewTotal()">
                </div>

                <div class="col-6 col-md-3">
                    <label class="form-label text-end d-block">Valor (R$)</label>
                    <input type="text" id="novo_valor" class="form-control form-control-lg-custom text-end" placeholder="0,00" onkeyup="formatarMoeda(this); atualizarPreviewTotal()">
                </div>
            </div>

            <div class="row mt-4 align-items-center">
                <div class="col-6 col-md-3 offset-md-9 text-end">
                     <small class="text-muted fw-bold">TOTAL ITEM</small>
                     <input type="text" id="novo_total_preview" class="form-control border-0 bg-light text-end fw-bold text-danger fs-5" value="R$ 0,00" readonly>
                </div>
                <div class="col-12 mt-2">
                    <button type="button" class="btn-add" onclick="adicionarItem()">Adicionar à Lista</button>
                </div>
            </div>
        </div>

        <div class="mb-5">
            <div id="lista-vazia" class="text-center py-5 text-muted fw-bold">Nenhum item adicionado.</div>
            
            <div class="card-premium p-0 overflow-hidden" id="tabela-container" style="display:none;">
                <div class="table-responsive">
                    <table class="table table-hover mb-0 align-middle">
                        <thead class="bg-light text-secondary small"><tr><th class="ps-4">PRODUTO</th><th class="text-center">QTD</th><th class="text-end">UNIT.</th><th class="text-end pe-4">TOTAL</th><th width="50"></th></tr></thead>
                        <tbody id="corpo-tabela"></tbody>
                    </table>
                </div>
            </div>

            <div class="card-premium" id="box-totais" style="display:none;">
                <div class="row justify-content-end">
                    <div class="col-md-5">
                        <div class="d-flex justify-content-between mb-2"><span>Subtotal:</span><strong id="display-subtotal">R$ 0,00</strong></div>
                        <div class="d-flex justify-content-between mb-2 align-items-center"><span>Frete:</span> <input type="text" id="input_frete" class="form-control form-control-sm w-50 text-end" onkeyup="formatarMoeda(this)" onblur="calcularGeral()"></div>
                        <div class="d-flex justify-content-between align-items-center"><span>Desconto:</span> 
                            <div class="input-group input-group-sm w-50">
                                <select id="select_tipo_desconto" class="form-select" onchange="calcularGeral()"><option value="valor">R$</option><option value="porcento">%</option></select>
                                <input type="text" id="input_desconto" class="form-control text-end" onkeyup="formatarMoeda(this)" onblur="calcularGeral()">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="area-inputs-ocultos"></div>
            <input type="hidden" name="subtotal_post" id="subtotal_post" value="0">
            <input type="hidden" name="frete_post" id="frete_post" value="0">
            <input type="hidden" name="desconto_valor_post" id="desconto_valor_post" value="0">
            <input type="hidden" name="desconto_tipo_post" id="desconto_tipo_post" value="valor">
            <input type="hidden" name="total_final_post" id="total_final_post" value="0">
        </div>

        <div class="footer-fixed">
            <div>
                <small class="text-muted d-block fw-bold" style="font-size: 0.7rem;">TOTAL A PAGAR</small>
                <div class="total-valor" id="footer-total">R$ 0,00</div>
            </div>
            <div class="footer-actions d-flex gap-2">
                <button type="button" class="btn btn-success fw-bold" onclick="copiarZap()"><i class="fab fa-whatsapp"></i></button>
                <button type="submit" class="btn btn-dark fw-bold px-4"><i class="fas fa-file-pdf me-2"></i> PDF</button>
            </div>
        </div>
    </form>
</div>

<div class="modal fade" id="modalProdutos" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Produtos</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><textarea id="textoImportacao" class="area-importacao" placeholder="Nome; Preço; Unidade; Código"></textarea><div class="text-end mt-2"><button class="btn btn-dark" onclick="salvarCatalogo()">Salvar</button></div></div></div></div></div>
<div class="modal fade" id="modalLista" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Rascunhos</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><div class="list-group" id="lista-arquivos"></div></div></div></div></div>
<div class="modal fade" id="modalPDFs" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Histórico</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><div class="list-group" id="lista-pdfs"></div></div></div></div></div>
<div class="modal fade" id="modalLeitor" tabindex="-1"><div class="modal-dialog"><div class="modal-content bg-dark text-white"><div class="modal-header border-secondary"><h5 class="modal-title">Escanear</h5><button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" onclick="pararLeitor()"></button></div><div class="modal-body p-0"><div id="leitor-camera"></div></div></div></div></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    window.onload = function() { document.getElementById('data_orcamento').value = new Date().toLocaleDateString('pt-BR'); carregarProdutos(); };
    let itens = [], catalogoProdutos = [], html5QrcodeScanner = null;

    // --- FUNÇÃO CRUCIAL: LER DINHEIRO CORRETAMENTE ---
    function lerDinheiro(s) {
        if(!s) return 0;
        let str = s.toString();
        // Remove R$ e espaços
        str = str.replace('R$', '').trim();
        // Se tiver vírgula (ex: 4,49), remove pontos de milhar e troca vírgula por ponto
        if(str.includes(',')) {
            str = str.replace(/\./g, '').replace(',', '.');
        } 
        // Se só tiver ponto, assume que é ponto decimal
        return parseFloat(str) || 0;
    }

    function formatarMoeda(el) {
        let v = el.value.replace(/\D/g, "");
        if (v === "") { el.value = ""; return; }
        v = (v / 100).toFixed(2) + "";
        v = v.replace(".", ",");
        v = v.replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1.");
        el.value = "R$ " + v;
    }

    function atualizarPreviewTotal() {
        let qtd = parseFloat(document.getElementById('novo_qtd').value) || 0;
        let valor = lerDinheiro(document.getElementById('novo_valor').value);
        let total = qtd * valor;
        document.getElementById('novo_total_preview').value = "R$ " + total.toLocaleString('pt-BR', {minimumFractionDigits: 2});
    }

    // --- PRODUTOS & CÂMERA ---
    function carregarProdutos() { fetch('api.php?acao=listar_produtos').then(r=>r.json()).then(d=>{ catalogoProdutos=d; atualizarDatalist(); }); }
    function atualizarDatalist() {
        let dl = document.getElementById('listaSugestoes'); dl.innerHTML = '';
        catalogoProdutos.forEach(p => { let op = document.createElement('option'); op.value = p.nome; dl.appendChild(op); });
    }
    function buscarPrecoAutomatico() {
        let nome = document.getElementById('novo_nome').value;
        let prod = catalogoProdutos.find(p => p.nome.toLowerCase() === nome.trim().toLowerCase());
        if (prod) {
            let visual = (parseFloat(prod.preco)*100).toFixed(0);
            let campo = document.getElementById('novo_valor'); campo.value = visual; formatarMoeda(campo);
            if(prod.unidade) document.getElementById('novo_unidade').value = prod.unidade;
            atualizarPreviewTotal();
        }
    }
    
    // --- FUNÇÕES MODAIS E IMPORTAÇÃO ---
    function abrirModalProdutos() {
        let t = ""; catalogoProdutos.forEach(p => t += `${p.nome}; ${p.preco}; ${p.unidade}; ${p.codigo || ''}\n`);
        document.getElementById('textoImportacao').value = t;
        new bootstrap.Modal(document.getElementById('modalProdutos')).show();
    }
    
    function salvarCatalogo() {
        let txt = document.getElementById('textoImportacao').value;
        let linhas = txt.split('\n'), novos = [];
        linhas.forEach(l => {
            if(l.trim()!=="") {
                let p = l.split(';'); if(p.length<2) p = l.split('\t');
                if(p.length>=2) {
                    // Preço: Garante que lê ponto ou vírgula
                    let pr = lerDinheiro(p[1]);
                    let nome = p[0].trim();
                    if(nome && !isNaN(pr)) novos.push({nome:nome, preco:pr, unidade:(p[2]?p[2].trim():'un'), codigo:(p[3]?p[3].trim():'')});
                }
            }
        });
        fetch('api.php?acao=salvar_produtos', {method:'POST', body:JSON.stringify(novos)}).then(r=>r.json()).then(d=>{ alert(d.msg); carregarProdutos(); bootstrap.Modal.getInstance(document.getElementById('modalProdutos')).hide(); });
    }

    function abrirLeitorBarcode() {
        new bootstrap.Modal(document.getElementById('modalLeitor')).show();
        if(html5QrcodeScanner === null) html5QrcodeScanner = new Html5Qrcode("leitor-camera");
        html5QrcodeScanner.start({ facingMode: "environment" }, { fps: 10, qrbox: { width: 250, height: 250 } }, onScanSuccess).catch(e => { alert("Erro HTTPS"); });
    }
    function onScanSuccess(t) {
        let p = catalogoProdutos.find(x => x.codigo && x.codigo.trim() === t);
        if(p) { document.getElementById('novo_nome').value=p.nome; buscarPrecoAutomatico(); pararLeitor(); bootstrap.Modal.getInstance(document.getElementById('modalLeitor')).hide(); }
        else { alert("Não cadastrado: "+t); }
    }
    function pararLeitor() { if(html5QrcodeScanner) html5QrcodeScanner.stop().catch(e=>{}); }

    // --- CORE ---
    document.addEventListener("keydown", function(e) { if(e.key==="Enter" && (e.target.tagName==="INPUT" || e.target.tagName==="SELECT")) { e.preventDefault(); if(e.target.id==="novo_nome") document.getElementById('novo_qtd').focus(); else if(e.target.id==="novo_qtd") document.getElementById('novo_valor').focus(); else if(e.target.id==="novo_valor") adicionarItem(); } });
    function setMedida(v) { document.getElementById('novo_unidade').value = v; }
    
    function adicionarItem() {
        let nome = document.getElementById('novo_nome').value;
        let qtd = parseFloat(document.getElementById('novo_qtd').value);
        let valor = lerDinheiro(document.getElementById('novo_valor').value);
        let un = document.getElementById('novo_unidade').value.trim();
        
        if(!nome || isNaN(qtd) || valor === 0) return alert("Preencha corretamente.");
        
        itens.push({ nome, qtd, valor, un, total: qtd * valor });
        renderizarLista();
        
        document.getElementById('novo_nome').value=''; 
        document.getElementById('novo_valor').value=''; 
        document.getElementById('novo_qtd').value='1'; 
        document.getElementById('novo_total_preview').value='R$ 0,00'; 
        document.getElementById('novo_unidade').value=''; 
        document.getElementById('novo_nome').focus();
    }

    function renderizarLista() {
        let tb = document.getElementById('corpo-tabela'); let inp = document.getElementById('area-inputs-ocultos'); tb.innerHTML=''; inp.innerHTML='';
        let d = itens.length ? 'block' : 'none';
        document.getElementById('tabela-container').style.display=d; document.getElementById('box-totais').style.display=d; document.getElementById('lista-vazia').style.display=itens.length?'none':'block';
        
        let soma = 0;
        itens.forEach((i, idx) => {
            soma += i.total;
            tb.innerHTML += `<tr><td class="ps-4 fw-bold">${i.nome}</td><td class="text-center"><span class="badge bg-light text-dark border">${i.qtd} ${i.un}</span></td><td class="text-end text-muted">R$ ${i.valor.toLocaleString('pt-BR',{minimumFractionDigits:2})}</td><td class="text-end fw-bold pe-4">R$ ${i.total.toLocaleString('pt-BR',{minimumFractionDigits:2})}</td><td class="text-center"><button class="btn btn-sm text-danger" onclick="remover(${idx})"><i class="fas fa-trash"></i></button></td></tr>`;
            inp.innerHTML += `<input type="hidden" name="item_nome[]" value="${i.nome}"><input type="hidden" name="item_unidade[]" value="${i.un}"><input type="hidden" name="item_qtd[]" value="${i.qtd}"><input type="hidden" name="item_valor[]" value="${i.valor}"><input type="hidden" name="item_total[]" value="${i.total.toFixed(2)}">`;
        });
        document.getElementById('subtotal_post').value = soma;
        document.getElementById('display-subtotal').innerText = soma.toLocaleString('pt-BR',{style:'currency', currency:'BRL'});
        calcularGeral();
    }

    function calcularGeral() {
        let sub = parseFloat(document.getElementById('subtotal_post').value)||0;
        let frete = lerDinheiro(document.getElementById('input_frete').value);
        let descVal = lerDinheiro(document.getElementById('input_desconto').value);
        let descTipo = document.getElementById('select_tipo_desconto').value;
        let descReal = 0;
        
        if(descTipo === 'porcento') {
            // Se for porcentagem, precisamos do valor bruto (ex: 10) e não do valor em dinheiro
            let valBruto = document.getElementById('input_desconto').value.replace(/\D/g, "");
            let percent = parseFloat(valBruto) / 100;
            descReal = sub * (percent / 100);
        } else {
            descReal = descVal;
        }
        
        let final = (sub + frete) - descReal; if(final < 0) final = 0;
        document.getElementById('footer-total').innerText = final.toLocaleString('pt-BR',{style:'currency', currency:'BRL'});
        
        document.getElementById('frete_post').value = frete;
        document.getElementById('desconto_valor_post').value = descVal;
        document.getElementById('desconto_tipo_post').value = descTipo;
        document.getElementById('total_final_post').value = final.toFixed(2);
    }

    function remover(i) { if(confirm("Remover?")) { itens.splice(i,1); renderizarLista(); } }
    
    function novoOrcamento() { if(itens.length>0 && !confirm("Novo?")) return; itens=[]; document.getElementById('cliente_nome').value=''; document.getElementById('input_frete').value=''; document.getElementById('input_desconto').value=''; renderizarLista(); }
    
    function salvarNoServidor() {
        let cli = document.getElementById('cliente_nome').value; if(!cli || !itens.length) return alert("Preencha dados.");
        let p = { cliente:cli, itens:itens, frete:document.getElementById('input_frete').value, desconto_val:document.getElementById('input_desconto').value, desconto_tipo:document.getElementById('select_tipo_desconto').value, total_final:document.getElementById('total_final_post').value };
        fetch('api.php?acao=salvar', {method:'POST', body:JSON.stringify(p)}).then(r=>r.json()).then(d=>{alert(d.msg);});
    }
    
    function abrirModalLista() { fetch('api.php?acao=listar').then(r=>r.json()).then(d=>{ let h=d.length?'':'<p class="text-center text-muted">Vazio.</p>'; d.forEach(a=>h+=`<button class="list-group-item list-group-item-action" onclick="carregar('${a.arquivo}')"><div class="d-flex justify-content-between fw-bold"><span>${a.cliente}</span><span class="text-danger">R$ ${parseFloat(a.total).toLocaleString('pt-BR',{minimumFractionDigits:2})}</span></div><small class="text-muted">${a.data}</small></button>`); document.getElementById('lista-arquivos').innerHTML=h; new bootstrap.Modal(document.getElementById('modalLista')).show(); }); }
    function carregar(arq) { fetch(`api.php?acao=carregar&arquivo=${arq}`).then(r=>r.json()).then(d=>{ document.getElementById('cliente_nome').value=d.cliente; document.getElementById('input_frete').value=d.frete; document.getElementById('input_desconto').value=d.desconto_val; document.getElementById('select_tipo_desconto').value=d.desconto_tipo; itens=d.itens||[]; renderizarLista(); bootstrap.Modal.getInstance(document.getElementById('modalLista')).hide(); }); }
    function abrirModalPDFs() { fetch('api.php?acao=listar_pdfs').then(r=>r.json()).then(d=>{ let h=d.length?'':'<p class="text-center text-muted">Vazio.</p>'; d.forEach(p=>h+=`<div class="list-group-item d-flex justify-content-between align-items-center"><div><div class="fw-bold text-dark text-truncate" style="max-width: 250px;">${p.nome_arquivo}</div><small class="text-muted">${p.data}</small></div><a href="orcamentos_pdfs/${p.nome_arquivo}" target="_blank" class="btn btn-sm btn-outline-danger"><i class="fas fa-download"></i></a></div>`); document.getElementById('lista-pdfs').innerHTML=h; new bootstrap.Modal(document.getElementById('modalPDFs')).show(); }); }
    
    function copiarZap() {
        if(!itens.length) return alert("Vazio."); let t = `*ORÇAMENTO - Quality Grill*\nCliente: ${document.getElementById('cliente_nome').value}\n\n`;
        itens.forEach(i => { let u=i.un?i.un:''; t+=`▪ ${i.nome}\n   ${i.qtd}${u} x R$${i.valor.toLocaleString('pt-BR',{minimumFractionDigits:2})} = *R$${i.total.toLocaleString('pt-BR',{minimumFractionDigits:2})}*\n`; });
        let tot = document.getElementById('footer-total').innerText; t+=`-------------------\n*TOTAL: ${tot}*`; navigator.clipboard.writeText(t).then(()=>alert("Copiado!"));
    }
</script>
</body>
</html>