<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Mais Churrasco - Sistema Premium</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;800&display=swap" rel="stylesheet">
    <script src="https://unpkg.com/html5-qrcode" type="text/javascript"></script>
    
    <style>
        :root { --primary-red: #c00d0d; --primary-dark: #8a0909; --bg-color: #f4f7f6; --card-shadow: 0 10px 30px rgba(0,0,0,0.04); --border-radius: 16px; }
        body { background-color: var(--bg-color); font-family: 'Inter', sans-serif; color: #2c3e50; padding-bottom: 120px; }
        .navbar-premium { background: #fff; box-shadow: 0 4px 20px rgba(0,0,0,0.03); padding: 15px 0; margin-bottom: 30px; }
        .logo-img { height: 65px; width: auto; transition: transform 0.3s; }
        .logo-img:hover { transform: scale(1.05); }
        .card-premium { background: #fff; border: none; border-radius: var(--border-radius); box-shadow: var(--card-shadow); padding: 25px; margin-bottom: 25px; }
        .form-label { font-size: 0.75rem; font-weight: 700; text-transform: uppercase; letter-spacing: 0.5px; color: #95a5a6; margin-bottom: 8px; }
        .form-control-lg-custom { border: 2px solid #eaellf; background-color: #fcfcfc; border-radius: 10px; padding: 12px 15px; font-size: 1rem; font-weight: 500; }
        .form-control-lg-custom:focus { border-color: var(--primary-red); background-color: #fff; box-shadow: 0 0 0 4px rgba(192, 13, 13, 0.1); }
        .btn-add { background: linear-gradient(135deg, var(--primary-red), #e74c3c); color: white; border: none; border-radius: 12px; font-weight: 700; padding: 14px; width: 100%; text-transform: uppercase; letter-spacing: 1px; box-shadow: 0 5px 15px rgba(192, 13, 13, 0.3); transition: all 0.3s; }
        .btn-add:hover { transform: translateY(-2px); box-shadow: 0 8px 20px rgba(192, 13, 13, 0.4); color: white; }
        .total-display { background-color: #fff0f0; color: var(--primary-red); border: 1px solid #ffcccc; border-radius: 10px; font-weight: 800; }
        .footer-fixed { position: fixed; bottom: 0; left: 0; right: 0; background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); border-top: 1px solid #eee; padding: 15px 20px; z-index: 1000; box-shadow: 0 -5px 20px rgba(0,0,0,0.05); }
        .footer-total-label { font-size: 0.7rem; color: #7f8c8d; font-weight: 700; text-transform: uppercase; }
        .footer-total-value { font-size: 1.6rem; color: var(--primary-red); font-weight: 800; line-height: 1; }
        .btn-menu { border-radius: 50px; font-weight: 600; font-size: 0.85rem; padding: 8px 20px; border: 1px solid #eee; background: white; color: #555; transition: all 0.2s; }
        .btn-menu:hover { background: #f8f9fa; color: var(--primary-red); border-color: var(--primary-red); }
        .table-custom th { font-size: 0.75rem; text-transform: uppercase; color: #95a5a6; border-bottom: 2px solid #eee; }
        .table-custom td { vertical-align: middle; font-weight: 500; color: #2c3e50; padding: 15px 10px; }
        .area-importacao { width: 100%; height: 200px; padding: 15px; border: 2px dashed #ccc; border-radius: 12px; background: #fafafa; font-family: monospace; }
        
        /* Ajuste Leitor */
        #leitor-camera { width: 100%; border-radius: 10px; overflow: hidden; background: #000; }
        
        @media (max-width: 768px) { .navbar-premium { flex-direction: column; text-align: center; gap: 15px; } .btn-menu { width: 100%; margin-bottom: 5px; justify-content: center; } .menu-buttons { width: 100%; display: grid; grid-template-columns: 1fr 1fr; gap: 8px; } .footer-fixed { flex-direction: column; gap: 15px; } .footer-actions { width: 100%; display: flex; gap: 10px; } .footer-actions .btn { flex: 1; } .total-wrapper { width: 100%; display: flex; justify-content: space-between; align-items: center; border-bottom: 1px solid #eee; padding-bottom: 10px; margin-bottom: 5px; } }
    </style>
</head>
<body>

<nav class="navbar-premium">
    <div class="container d-flex flex-column flex-md-row justify-content-between align-items-center">
        <a class="navbar-brand m-0" href="#">
            <img src="https://mgatv.com.br/orca/logomais.webp" alt="Mais Churrasco" class="logo-img">
        </a>
        <div class="menu-buttons d-flex flex-wrap justify-content-center mt-3 mt-md-0 gap-2">
            <button class="btn-menu" onclick="novoOrcamento()"><i class="fas fa-plus-circle text-warning"></i> Novo</button>
            <button class="btn-menu" onclick="abrirModalLista()"><i class="far fa-folder-open text-primary"></i> Rascunhos</button>
            <button class="btn-menu" onclick="abrirModalPDFs()"><i class="far fa-file-pdf text-danger"></i> Histórico</button>
            <button class="btn-menu" onclick="abrirModalProdutos()"><i class="fas fa-boxes text-success"></i> Produtos</button>
        </div>
    </div>
</nav>

<div class="container">
    <form id="form-orcamento" action="gerar_pdf.php" method="POST" target="_blank">
        
        <div class="card-premium">
            <div class="row align-items-end g-3">
                <div class="col-md-9">
                    <label class="form-label"><i class="far fa-user me-1"></i> Cliente / Evento</label>
                    <input type="text" name="cliente_nome" id="cliente_nome" class="form-control form-control-lg-custom" placeholder="Ex: Aniversário do João" required>
                    <input type="hidden" name="data_orcamento" id="data_orcamento">
                </div>
                <div class="col-md-3">
                    <button type="button" class="btn btn-outline-secondary w-100 py-2 fw-bold" style="border-radius:10px; border: 2px solid #e0e0e0;" onclick="salvarNoServidor()">
                        <i class="far fa-save"></i> Salvar Rascunho
                    </button>
                </div>
            </div>
        </div>

        <div class="card-premium position-relative overflow-hidden">
            <div style="position:absolute; top:0; left:0; width:5px; height:100%; background:var(--primary-red);"></div>
            <h5 class="fw-bold mb-4" style="color: #2c3e50;"><i class="fas fa-cart-plus me-2 text-danger"></i>Adicionar Item</h5>
            
            <div class="row g-3">
                <div class="col-12 col-md-5">
                    <label class="form-label">Produto</label>
                    <div class="input-group">
                        <span class="input-group-text bg-white border-end-0 border-2" style="border-radius: 10px 0 0 10px;"><i class="fas fa-search text-muted"></i></span>
                        <input type="text" id="novo_nome" class="form-control form-control-lg-custom border-start-0" list="listaSugestoes" oninput="buscarPrecoAutomatico()" placeholder="Digite para buscar...">
                        
                        <button type="button" class="btn btn-dark" onclick="abrirLeitorBarcode()" title="Ler Código de Barras" style="border-radius: 0 10px 10px 0;">
                            <i class="fas fa-barcode"></i>
                        </button>
                    </div>
                    <datalist id="listaSugestoes"></datalist>
                </div>
                
                <div class="col-6 col-md-2">
                    <label class="form-label">Medida</label>
                    <div class="input-group">
                        <input type="text" id="novo_unidade" class="form-control form-control-lg-custom" placeholder="Un..." list="listaMedidas" style="background:#fff;">
                        <button class="btn btn-light border fw-bold text-muted" type="button" onclick="document.getElementById('novo_unidade').value='kg'" title="Atalho Quilo">kg</button>
                        <datalist id="listaMedidas">
                            <option value="un">Unidade</option><option value="kg">Quilo</option><option value="lata">Lata</option>
                            <option value="pct">Pacote</option><option value="emb">Embalagem</option><option value="cx">Caixa</option>
                            <option value="gf">Garrafa</option><option value="lt">Litro</option>
                        </datalist>
                    </div>
                </div>

                <div class="col-6 col-md-2">
                    <label class="form-label text-center d-block">Qtd/Peso</label>
                    <input type="number" id="novo_qtd" class="form-control form-control-lg-custom text-center" value="1" step="0.01" oninput="atualizarPreviewTotal()">
                </div>

                <div class="col-6 col-md-3">
                    <label class="form-label text-end d-block">Valor Unit. (R$)</label>
                    <input type="text" id="novo_valor" class="form-control form-control-lg-custom text-end" placeholder="0,00" onkeyup="formatarMoeda(this); atualizarPreviewTotal()">
                </div>
            </div>

            <div class="row mt-4 align-items-center">
                <div class="col-6 col-md-3 offset-md-9 mb-3 mb-md-0">
                     <label class="form-label text-end d-block">Total do Item</label>
                     <input type="text" id="novo_total_preview" class="form-control total-display text-end" value="R$ 0,00" readonly>
                </div>
                <div class="col-12">
                    <button type="button" class="btn-add" onclick="adicionarItem()">
                        <i class="fas fa-plus-circle me-2"></i> Adicionar à Lista
                    </button>
                </div>
            </div>
        </div>

        <div class="mb-5">
            <div id="lista-vazia" class="text-center py-5">
                <div style="background:#fff; width:100px; height:100px; border-radius:50%; display:inline-flex; align-items:center; justify-content:center; box-shadow:0 5px 15px rgba(0,0,0,0.05);"><i class="fas fa-shopping-basket fa-3x text-muted"></i></div>
                <p class="mt-3 text-muted fw-bold">Nenhum item adicionado ainda.</p>
            </div>
            
            <div class="card-premium p-0 overflow-hidden" id="tabela-container" style="display:none;">
                <div class="table-responsive">
                    <table class="table table-custom table-hover mb-0">
                        <thead class="bg-light"><tr><th class="ps-4">Produto</th><th class="text-center">Qtd</th><th class="text-end">Unit.</th><th class="text-end pe-4">Total</th><th width="50"></th></tr></thead>
                        <tbody id="corpo-tabela"></tbody>
                    </table>
                </div>
            </div>

            <div class="card-premium" id="box-totais" style="display:none;">
                <div class="row justify-content-end">
                    <div class="col-md-5">
                        <div class="d-flex justify-content-between mb-3 border-bottom pb-2"><span class="text-muted fw-bold">Subtotal</span><strong id="display-subtotal" class="fs-5">R$ 0,00</strong></div>
                        <div class="row g-2 mb-2 align-items-center"><div class="col-4 text-muted fw-bold"><i class="fas fa-truck me-1"></i> Frete</div><div class="col-8"><input type="text" id="input_frete" class="form-control form-control-sm text-end bg-light border-0" placeholder="R$ 0,00" onkeyup="formatarMoeda(this)" onblur="calcularGeral()"></div></div>
                        <div class="row g-2 align-items-center"><div class="col-4 text-muted fw-bold"><i class="fas fa-tag me-1"></i> Desconto</div><div class="col-8"><div class="input-group input-group-sm"><select id="select_tipo_desconto" class="form-select bg-light border-0" style="max-width: 60px;" onchange="calcularGeral()"><option value="valor">R$</option><option value="porcento">%</option></select><input type="text" id="input_desconto" class="form-control text-end bg-light border-0" placeholder="0,00" onkeyup="formatarMoeda(this)" onblur="calcularGeral()"></div></div></div>
                    </div>
                </div>
            </div>

            <div id="area-inputs-ocultos"></div>
            <input type="hidden" name="subtotal_post" id="subtotal_post" value="0">
            <input type="hidden" name="frete_post" id="frete_post" value="0">
            <input type="hidden" name="desconto_valor_post" id="desconto_valor_post" value="0">
            <input type="hidden" name="desconto_tipo_post" id="desconto_tipo_post" value="valor">
            <input type="hidden" name="total_final_post" id="total_final_post" value="0">
        </div>

        <div class="footer-fixed d-flex justify-content-between align-items-center">
            <div class="total-wrapper"><div class="footer-total-label">Valor Total</div><div class="footer-total-value" id="footer-total">R$ 0,00</div></div>
            <div class="footer-actions d-flex gap-2">
                <button type="button" class="btn btn-success fw-bold px-4" onclick="copiarZap()"><i class="fab fa-whatsapp me-2"></i> <span class="d-none d-md-inline">WhatsApp</span></button>
                <button type="submit" class="btn btn-dark fw-bold px-4"><i class="fas fa-file-pdf me-2"></i> <span class="d-none d-md-inline">Gerar PDF</span><span class="d-inline d-md-none">PDF</span></button>
            </div>
        </div>
    </form>
</div>

<div class="modal fade" id="modalLeitor" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content bg-dark text-white">
            <div class="modal-header border-secondary">
                <h5 class="modal-title"><i class="fas fa-qrcode me-2"></i> Escanear Produto</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" onclick="pararLeitor()"></button>
            </div>
            <div class="modal-body p-0">
                <div id="leitor-camera"></div>
                <div class="text-center p-3 text-muted small">Aponte a câmera para o código de barras ou QR Code</div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalProdutos" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content border-0 shadow"><div class="modal-header"><h5 class="modal-title fw-bold">Catálogo</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body p-4"><div class="alert alert-light border mb-3 small"><i class="fas fa-info-circle me-2"></i>Formato: <b>Nome; Preço; Unidade; CódigoBarras</b></div><textarea id="textoImportacao" class="area-importacao mb-3" placeholder="Coca Cola 2L; 10.00; gf; 7894900011517"></textarea><div class="text-end"><button class="btn btn-dark" onclick="salvarCatalogo()">Salvar Importação</button></div></div></div></div></div>
<div class="modal fade" id="modalLista" tabindex="-1"><div class="modal-dialog"><div class="modal-content border-0 shadow"><div class="modal-header"><h5 class="modal-title fw-bold">Rascunhos</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body p-0"><div class="list-group list-group-flush" id="lista-arquivos"></div></div></div></div></div>
<div class="modal fade" id="modalPDFs" tabindex="-1"><div class="modal-dialog"><div class="modal-content border-0 shadow"><div class="modal-header"><h5 class="modal-title fw-bold">Histórico</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body p-0"><div class="list-group list-group-flush" id="lista-pdfs"></div></div></div></div></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    window.onload = function() { 
        document.getElementById('data_orcamento').value = new Date().toLocaleDateString('pt-BR'); 
        carregarProdutos(); 
    };
    
    let itens = [], catalogoProdutos = [];
    let html5QrcodeScanner = null;

    // --- LEITOR DE CÓDIGO DE BARRAS ---
    function abrirLeitorBarcode() {
        const modalEl = document.getElementById('modalLeitor');
        const modal = new bootstrap.Modal(modalEl);
        modal.show();
        
        if(html5QrcodeScanner === null) {
            html5QrcodeScanner = new Html5Qrcode("leitor-camera");
        }
        
        const config = { fps: 10, qrbox: { width: 250, height: 250 } };
        
        html5QrcodeScanner.start({ facingMode: "environment" }, config, onScanSuccess)
        .catch(err => {
            console.error("Erro na câmera", err);
            alert("Não foi possível acessar a câmera. Verifique se você está usando HTTPS ou localhost, e se deu permissão ao navegador.");
            modal.hide();
        });
    }

    function onScanSuccess(decodedText, decodedResult) {
        let prod = catalogoProdutos.find(p => p.codigo && p.codigo.trim() === decodedText);
        
        if (prod) {
            document.getElementById('novo_nome').value = prod.nome;
            buscarPrecoAutomatico();
            
            pararLeitor();
            const modalEl = document.getElementById('modalLeitor');
            const modal = bootstrap.Modal.getInstance(modalEl);
            if(modal) modal.hide();
            
            setTimeout(() => {
                document.getElementById('novo_qtd').focus();
                document.getElementById('novo_qtd').select();
            }, 500);
        } else {
            alert("Produto não cadastrado com o código: " + decodedText);
        }
    }

    function pararLeitor() {
        if(html5QrcodeScanner) {
            html5QrcodeScanner.stop().then(() => console.log("Câmera parada.")).catch(err => console.error(err));
        }
    }

    // --- FUNÇÃO DE IMPORTAÇÃO CORRIGIDA E ROBUSTA ---
    function salvarCatalogo() {
        try {
            let texto = document.getElementById('textoImportacao').value;
            if(!texto.trim()) return alert("A caixa de texto está vazia!");

            let linhas = texto.split('\n');
            let novos = [];
            let erros = 0;

            linhas.forEach(l => {
                if(l.trim() !== "") {
                    // Tenta dividir por ponto e vírgula
                    let p = l.split(';');
                    
                    // Se não tiver ponto e vírgula, tenta por tabulação (caso venha do Excel direto)
                    if (p.length < 2) p = l.split('\t');

                    if(p.length >= 2) {
                        let nome = p[0].trim();
                        // Trata preço (troca virgula por ponto)
                        let precoRaw = p[1].trim().replace('R$','').replace(/\./g,'').replace(',','.'); 
                        // Se o valor era 120.00 (formato americano), o replace acima pode ter quebrado, vamos garantir:
                        if(p[1].includes('.') && !p[1].includes(',')) precoRaw = p[1].trim(); 
                        else precoRaw = p[1].trim().replace('.','').replace(',','.'); // Formato BR

                        let pr = parseFloat(precoRaw);
                        let unidade = (p[2] && p[2].trim()) ? p[2].trim() : 'un';
                        let codigo = (p[3] && p[3].trim()) ? p[3].trim() : '';

                        if(nome && !isNaN(pr)) {
                            novos.push({nome:nome, preco:pr, unidade:unidade, codigo:codigo});
                        } else {
                            erros++;
                        }
                    }
                }
            });

            if(novos.length === 0) {
                alert("Nenhum produto válido encontrado. Use o formato: Nome; Preço");
                return;
            }

            console.log("Enviando produtos:", novos);

            fetch('api.php?acao=salvar_produtos', {
                method: 'POST', 
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify(novos)
            })
            .then(r => r.json())
            .then(d => { 
                alert(d.msg + ` (${novos.length} itens importados)`); 
                carregarProdutos(); 
                const modal = bootstrap.Modal.getInstance(document.getElementById('modalProdutos'));
                if(modal) modal.hide();
            })
            .catch(e => {
                alert("Erro ao salvar no servidor. Verifique o console (F12).");
                console.error(e);
            });

        } catch (error) {
            console.error(error);
            alert("Ocorreu um erro no processamento da lista.");
        }
    }

    function abrirModalProdutos() {
        let t = ""; 
        catalogoProdutos.forEach(p => t += `${p.nome}; ${p.preco.toFixed(2)}; ${p.unidade}; ${p.codigo || ''}\n`);
        document.getElementById('textoImportacao').value = t;
        new bootstrap.Modal(document.getElementById('modalProdutos')).show();
    }

    // --- MANIPULAÇÃO DE DADOS ---
    function carregarProdutos() { 
        fetch('api.php?acao=listar_produtos')
        .then(r => r.json())
        .then(d => { 
            catalogoProdutos = d; 
            atualizarDatalist(); 
        })
        .catch(e => console.log("Ainda sem produtos cadastrados ou erro na API."));
    }

    function atualizarDatalist() {
        let dl = document.getElementById('listaSugestoes'); dl.innerHTML = '';
        catalogoProdutos.forEach(p => { 
            let op = document.createElement('option'); 
            op.value = p.nome; 
            dl.appendChild(op); 
        });
    }

    function buscarPrecoAutomatico() {
        let nome = document.getElementById('novo_nome').value;
        // Busca exata ou que começa com o texto (opcional, aqui estamos usando find exato pois o datalist preenche tudo)
        let prod = catalogoProdutos.find(p => p.nome.toLowerCase() === nome.trim().toLowerCase());
        
        if (prod) {
            let visual = (parseFloat(prod.preco)*100).toFixed(0);
            let campo = document.getElementById('novo_valor');
            campo.value = visual; 
            formatarMoeda(campo);
            
            if(prod.unidade) document.getElementById('novo_unidade').value = prod.unidade;
            atualizarPreviewTotal();
        }
    }

    // --- TECLADO E INPUTS ---
    document.addEventListener("keydown", function(e) {
        if (e.key === "Enter") {
            if(e.target.tagName === "INPUT" || e.target.tagName === "SELECT") {
                e.preventDefault();
                let id = e.target.id;
                if(id==="novo_nome") { document.getElementById('novo_qtd').focus(); document.getElementById('novo_qtd').select(); }
                else if(id==="novo_qtd") { document.getElementById('novo_valor').focus(); }
                else if(id==="novo_valor") { adicionarItem(); }
            }
        }
    });

    function formatarMoeda(el) {
        let v = el.value.replace(/\D/g, ""); 
        if (v === "") { el.value = ""; return; }
        v = (v / 100).toFixed(2) + ""; 
        v = v.replace(".", ","); 
        v = v.replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1."); 
        el.value = "R$ " + v;
    }
    
    function lerDinheiro(s) { 
        if(!s) return 0; 
        // Remove R$, espaços e troca virgula por ponto
        let l = s.replace('R$','').trim().replace(/\./g, '').replace(',', '.'); 
        return parseFloat(l) || 0; 
    }
    
    function atualizarPreviewTotal() {
        let qtd = parseFloat(document.getElementById('novo_qtd').value) || 0;
        let valor = lerDinheiro(document.getElementById('novo_valor').value);
        let total = qtd * valor;
        document.getElementById('novo_total_preview').value = "R$ " + total.toLocaleString('pt-BR', {minimumFractionDigits: 2});
    }

    // --- FUNÇÕES CORE (ADICIONAR/REMOVER) ---
    function adicionarItem() {
        let nome = document.getElementById('novo_nome').value; 
        let qtd = parseFloat(document.getElementById('novo_qtd').value); 
        let valor = lerDinheiro(document.getElementById('novo_valor').value); 
        let un = document.getElementById('novo_unidade').value.trim();
        
        if(!nome || isNaN(qtd) || valor === 0) return alert("Preencha corretamente o item.");
        
        itens.push({ nome, qtd, valor, un, total: qtd * valor }); 
        renderizarLista();
        
        document.getElementById('novo_nome').value=''; 
        document.getElementById('novo_valor').value=''; 
        document.getElementById('novo_qtd').value='1'; 
        document.getElementById('novo_total_preview').value='R$ 0,00'; 
        document.getElementById('novo_unidade').value=''; 
        document.getElementById('novo_nome').focus();
    }
    
    function renderizarLista() {
        let tb = document.getElementById('corpo-tabela'); 
        let inp = document.getElementById('area-inputs-ocultos'); 
        tb.innerHTML=''; inp.innerHTML='';
        
        let d = itens.length ? 'block' : 'none'; 
        document.getElementById('tabela-container').style.display=d; 
        document.getElementById('box-totais').style.display=d; 
        document.getElementById('lista-vazia').style.display=itens.length?'none':'block';

        let soma = 0;
        itens.forEach((i, idx) => {
            soma += i.total; 
            let u = i.un ? i.un : '';
            tb.innerHTML += `<tr><td class="ps-4 fw-bold">${i.nome}</td><td class="text-center"><span class="badge bg-light text-dark border">${i.qtd} ${u}</span></td><td class="text-end text-muted">R$ ${i.valor.toLocaleString('pt-BR',{minimumFractionDigits:2})}</td><td class="text-end fw-bold pe-4 text-dark">R$ ${i.total.toLocaleString('pt-BR',{minimumFractionDigits:2})}</td><td class="text-center"><button type="button" class="btn btn-sm text-danger hover-scale" onclick="remover(${idx})"><i class="fas fa-trash-alt"></i></button></td></tr>`;
            inp.innerHTML += `<input type="hidden" name="item_nome[]" value="${i.nome}"><input type="hidden" name="item_unidade[]" value="${i.un}"><input type="hidden" name="item_qtd[]" value="${i.qtd}"><input type="hidden" name="item_valor[]" value="${i.valor}"><input type="hidden" name="item_total[]" value="${i.total.toFixed(2)}">`;
        });
        
        document.getElementById('subtotal_post').value = soma; 
        document.getElementById('display-subtotal').innerText = soma.toLocaleString('pt-BR',{style:'currency', currency:'BRL'}); 
        calcularGeral();
    }
    
    function calcularGeral() {
        let sub = parseFloat(document.getElementById('subtotal_post').value)||0; 
        let frete = lerDinheiro(document.getElementById('input_frete').value); 
        let descInput = document.getElementById('input_desconto').value; 
        let descVal = lerDinheiro(descInput); 
        let descTipo = document.getElementById('select_tipo_desconto').value;
        
        // Correção para porcentagem
        let descReal = 0;
        if(descTipo === 'porcento') {
            // Pega apenas os números digitados para fazer a porcentagem
            let numbers = descInput.replace(/\D/g, "");
            let percent = parseFloat(numbers) / 100; // ex: digita 1000 vir 10.00%
            descReal = sub * (percent / 100);
        } else {
            descReal = descVal;
        }
        
        let final = (sub + frete) - descReal; 
        if(final < 0) final = 0;
        
        document.getElementById('footer-total').innerText = final.toLocaleString('pt-BR',{style:'currency', currency:'BRL'});
        document.getElementById('frete_post').value = frete; 
        document.getElementById('desconto_valor_post').value = descVal; 
        document.getElementById('desconto_tipo_post').value = descTipo; 
        document.getElementById('total_final_post').value = final.toFixed(2);
    }
    
    // --- PERSISTÊNCIA E AUXILIARES ---
    function remover(i) { if(confirm("Remover?")) { itens.splice(i,1); renderizarLista(); } }
    
    function novoOrcamento() { if(itens.length>0 && !confirm("Iniciar novo?")) return; itens=[]; document.getElementById('cliente_nome').value=''; document.getElementById('input_frete').value=''; document.getElementById('input_desconto').value=''; renderizarLista(); }
    
    function salvarNoServidor() {
        let cli = document.getElementById('cliente_nome').value; 
        if(!cli || !itens.length) return alert("Preencha cliente e itens.");
        let p = { cliente:cli, itens:itens, frete:document.getElementById('input_frete').value, desconto_val:document.getElementById('input_desconto').value, desconto_tipo:document.getElementById('select_tipo_desconto').value, total_final:document.getElementById('total_final_post').value };
        fetch('api.php?acao=salvar', {method:'POST', body:JSON.stringify(p)}).then(r=>r.json()).then(d=>{alert(d.msg);});
    }

    function abrirModalLista() { fetch('api.php?acao=listar').then(r=>r.json()).then(d=>{ let h=d.length?'':'<p class="text-center text-muted py-3">Vazio.</p>'; d.forEach(a=>h+=`<button class="list-group-item list-group-item-action py-3" onclick="carregar('${a.arquivo}')"><div class="d-flex justify-content-between fw-bold"><span>${a.cliente}</span><span class="text-danger">R$ ${parseFloat(a.total).toLocaleString('pt-BR',{minimumFractionDigits:2})}</span></div><small class="text-muted">${a.data}</small></button>`); document.getElementById('lista-arquivos').innerHTML=h; new bootstrap.Modal(document.getElementById('modalLista')).show(); }); }
    
    function carregar(arq) { fetch(`api.php?acao=carregar&arquivo=${arq}`).then(r=>r.json()).then(d=>{ document.getElementById('cliente_nome').value=d.cliente; document.getElementById('input_frete').value=d.frete; document.getElementById('input_desconto').value=d.desconto_val; document.getElementById('select_tipo_desconto').value=d.desconto_tipo; itens=d.itens||[]; renderizarLista(); bootstrap.Modal.getInstance(document.getElementById('modalLista')).hide(); }); }
    
    function abrirModalPDFs() { fetch('api.php?acao=listar_pdfs').then(r=>r.json()).then(d=>{ let h=d.length?'':'<p class="text-center text-muted py-3">Vazio.</p>'; d.forEach(p=>h+=`<div class="list-group-item d-flex justify-content-between align-items-center py-3"><div><div class="fw-bold text-dark text-truncate" style="max-width: 250px;">${p.nome_arquivo}</div><small class="text-muted">${p.data}</small></div><a href="orcamentos_pdfs/${p.nome_arquivo}" target="_blank" class="btn btn-sm btn-outline-danger"><i class="fas fa-download"></i></a></div>`); document.getElementById('lista-pdfs').innerHTML=h; new bootstrap.Modal(document.getElementById('modalPDFs')).show(); }); }

    function copiarZap() {
        if(!itens.length) return alert("Vazio."); 
        let t = `*ORÇAMENTO - MAIS CHURRASCO*\n\n👤 Cliente: ${document.getElementById('cliente_nome').value}\n📅 Data: ${new Date().toLocaleDateString()}\n-----------------------------------\n`;
        itens.forEach(i => { let u=i.un?i.un:''; t+=`▪ ${i.nome}\n   ${i.qtd}${u} x R$${i.valor.toLocaleString('pt-BR',{minimumFractionDigits:2})} = *R$${i.total.toLocaleString('pt-BR',{minimumFractionDigits:2})}*\n`; });
        let tot = document.getElementById('footer-total').innerText;
        t+=`-----------------------------------\n*TOTAL FINAL: ${tot}*`; 
        navigator.clipboard.writeText(t).then(()=>alert("Copiado!"));
    }
</script>
</body>
</html>