<?php
// ARQUIVO: api.php
header('Content-Type: application/json');

// Define as pastas
$pastaSalvos = 'orcamentos_salvos/';
$pastaPDFs = 'orcamentos_pdfs/';
$arquivoProdutos = 'produtos.json';

// Garante que as pastas existem
if(!is_dir($pastaSalvos)) mkdir($pastaSalvos);
if(!is_dir($pastaPDFs)) mkdir($pastaPDFs);

$acao = $_POST['acao'] ?? $_GET['acao'] ?? '';

// 1. SALVAR RASCUNHO (JSON)
if ($acao == 'salvar') {
    $dados = json_decode(file_get_contents('php://input'), true);
    if (!$dados || empty($dados['cliente'])) { echo json_encode(['sucesso'=>false, 'msg'=>'Dados inválidos']); exit; }
    
    $nomeLimpo = preg_replace('/[^a-zA-Z0-9]/', '_', $dados['cliente']);
    $arquivo = $nomeLimpo . '_' . time() . '.json';
    
    if (file_put_contents($pastaSalvos . $arquivo, json_encode($dados))) {
        echo json_encode(['sucesso'=>true, 'msg'=>'Rascunho salvo com sucesso!']);
    } else {
        echo json_encode(['sucesso'=>false, 'msg'=>'Erro de permissão na pasta.']);
    }
}

// 2. LISTAR RASCUNHOS
elseif ($acao == 'listar') {
    $arquivos = glob($pastaSalvos . '*.json');
    $lista = [];
    if($arquivos) {
        array_multisort(array_map('filemtime', $arquivos), SORT_DESC, $arquivos);
        foreach ($arquivos as $arq) {
            $conteudo = json_decode(file_get_contents($arq), true);
            $lista[] = [
                'arquivo' => basename($arq),
                'cliente' => $conteudo['cliente'] ?? 'Sem nome',
                'data' => date('d/m/Y H:i', filemtime($arq)),
                'total' => $conteudo['total_final'] ?? '0.00'
            ];
        }
    }
    echo json_encode($lista);
}

// 3. CARREGAR RASCUNHO
elseif ($acao == 'carregar') {
    $arq = $_GET['arquivo'] ?? '';
    if (file_exists($pastaSalvos . basename($arq))) {
        echo file_get_contents($pastaSalvos . basename($arq));
    }
}

// 4. LISTAR PDFs
elseif ($acao == 'listar_pdfs') {
    $arquivos = glob($pastaPDFs . '*.pdf');
    $lista = [];
    if($arquivos) {
        array_multisort(array_map('filemtime', $arquivos), SORT_DESC, $arquivos);
        foreach ($arquivos as $arq) {
            $lista[] = [
                'nome_arquivo' => basename($arq),
                'caminho' => $arq,
                'data' => date('d/m/Y H:i', filemtime($arq)),
                'tamanho' => round(filesize($arq) / 1024, 1) . ' KB'
            ];
        }
    }
    echo json_encode($lista);
}

// 5. LISTAR PRODUTOS
elseif ($acao == 'listar_produtos') {
    if (file_exists($arquivoProdutos)) {
        echo file_get_contents($arquivoProdutos);
    } else {
        echo json_encode([]);
    }
}

// 6. SALVAR PRODUTOS
elseif ($acao == 'salvar_produtos') {
    $dados = json_decode(file_get_contents('php://input'), true);
    if (file_put_contents($arquivoProdutos, json_encode($dados))) {
        echo json_encode(['sucesso' => true, 'msg' => 'Catálogo atualizado!']);
    } else {
        echo json_encode(['sucesso' => false, 'msg' => 'Erro ao salvar catálogo.']);
    }
}
?>