<?php
// ARQUIVO: gerar_pdf.php

require_once 'dompdf/autoload.inc.php'; 

use Dompdf\Dompdf;
use Dompdf\Options;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') die("Acesso inválido.");

// --- FUNÇÃO DE LIMPEZA (ESSENCIAL PARA O NOVO DESIGN) ---
function limparDinheiroPHP($valor) {
    if (is_numeric($valor)) return floatval($valor);
    // Remove o R$ e espaços
    $valor = str_replace('R$', '', $valor);
    $valor = trim($valor);
    // Remove tudo que não é dígito, vírgula ou ponto
    $valor = preg_replace('/[^\d,.]/', '', $valor);
    // Troca vírgula por ponto para cálculo
    $valor = str_replace(',', '.', $valor);
    
    // Resolve problemas de múltiplos pontos (ex: 1.200.50 viraria 1.200.50)
    // Mantém apenas o último ponto
    if(substr_count($valor, '.') > 1){
       $valor = str_replace('.', '', substr($valor, 0, strrpos($valor, '.'))) . substr($valor, strrpos($valor, '.'));
    }
    return floatval($valor);
}

// --- DADOS RECEBIDOS ---
$cliente_nome = $_POST['cliente_nome'] ?? 'Cliente';
$data_orcamento = $_POST['data_orcamento'] ?? date('d/m/Y');

$itens_nome = $_POST['item_nome'] ?? [];
$itens_unidade = $_POST['item_unidade'] ?? [];
$itens_qtd = $_POST['item_qtd'] ?? [];
$itens_valor = $_POST['item_valor'] ?? [];
$itens_total = $_POST['item_total'] ?? [];

// TOTAIS (Limpamos porque vêm formatados do JS)
$subtotal = limparDinheiroPHP($_POST['subtotal_post'] ?? 0);
$frete = limparDinheiroPHP($_POST['frete_post'] ?? 0);
$total_final = limparDinheiroPHP($_POST['total_final_post'] ?? 0);
$desc_valor = limparDinheiroPHP($_POST['desconto_valor_post'] ?? 0);
$desc_tipo = $_POST['desconto_tipo_post'] ?? 'valor';

// Cálculo do texto de desconto
$val_desc_real = ($desc_tipo == 'porcento') ? $subtotal * ($desc_valor/100) : $desc_valor;
$texto_desc = "";
if($val_desc_real > 0) {
    $texto_desc = ($desc_tipo == 'porcento') 
        ? "- R$ " . number_format($val_desc_real, 2, ',', '.') . " ({$desc_valor}%)"
        : "- R$ " . number_format($val_desc_real, 2, ',', '.');
}

// --- HTML DO PDF (DESIGN PREMIUM) ---
$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        @page { margin: 40px; }
        body { font-family: "Helvetica", sans-serif; font-size: 12px; color: #444; line-height: 1.4; }
        
        /* CABEÇALHO COM LOGO CENTRALIZADA */
        .header { text-align: center; margin-bottom: 40px; border-bottom: 2px solid #f0f0f0; padding-bottom: 20px; }
        .logo { height: 80px; width: auto; margin-bottom: 10px; }
        .titulo-doc { font-size: 14px; letter-spacing: 3px; text-transform: uppercase; color: #c00d0d; font-weight: bold; margin-top: 5px; }

        /* INFO DO CLIENTE */
        .info-container { 
            width: 100%; 
            margin-bottom: 30px; 
            padding: 15px 20px;
            background-color: #fcfcfc;
            border-left: 5px solid #c00d0d; /* Vermelho da marca */
            border-radius: 4px;
        }
        .info-label { font-size: 10px; text-transform: uppercase; color: #999; font-weight: bold; margin-bottom: 4px; }
        .info-valor { font-size: 14px; font-weight: bold; color: #333; margin-bottom: 0; }
        
        /* TABELA DE ITENS */
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        
        th { 
            background-color: #c00d0d; /* Cabeçalho Vermelho */
            color: white; 
            text-transform: uppercase; 
            font-size: 10px; 
            padding: 10px 12px; 
            text-align: left;
            font-weight: bold;
            letter-spacing: 0.5px;
        }
        
        td { 
            padding: 10px 12px; 
            border-bottom: 1px solid #eee; 
            color: #444;
            font-size: 11px;
        }
        
        /* Zebrado sutil */
        tr:nth-child(even) { background-color: #fafafa; }

        /* Alinhamentos */
        .text-right { text-align: right; }
        .text-center { text-align: center; }
        .col-produto { width: 50%; }
        .col-qtd { width: 15%; }
        .col-unit { width: 15%; }
        .col-total { width: 20%; font-weight: bold; color: #222; }

        /* UNIDADE PEQUENA */
        .badge-un { background: #eee; padding: 2px 5px; border-radius: 3px; font-size: 9px; color: #666; margin-left: 3px; }

        /* TOTAIS */
        .box-totais { width: 100%; page-break-inside: avoid; margin-top: 10px; }
        .tabela-totais { width: 45%; float: right; border-collapse: collapse; }
        .tabela-totais td { padding: 6px 0; text-align: right; border: none; }
        
        .label-resumo { color: #888; font-size: 11px; font-weight: bold; text-transform: uppercase; }
        .valor-resumo { font-size: 12px; font-weight: bold; color: #444; }
        
        .total-final-row td {
            padding-top: 15px;
            border-top: 2px solid #c00d0d;
        }
        .total-grande {
            font-size: 18px;
            font-weight: bold;
            color: #c00d0d;
        }

        /* RODAPÉ */
        .footer {
            position: fixed; bottom: 0; width: 100%; text-align: center;
            font-size: 9px; color: #aaa; border-top: 1px solid #eee; padding-top: 15px;
        }
    </style>
</head>
<body>

    <div class="header">
        <img src="https://mgatv.com.br/quality/quality.png" class="logo">
        <div class="titulo-doc">Orçamento Comercial</div>
    </div>

    <table style="width: 100%; margin-bottom: 20px; background:transparent;">
        <tr>
            <td style="padding: 0; border: none;">
                <div class="info-container">
                    <div class="info-label">Cliente / Evento</div>
                    <div class="info-valor">'.mb_strtoupper($cliente_nome).'</div>
                </div>
            </td>
            <td style="width: 20px; padding: 0; border: none; background:transparent;"></td>
            <td style="width: 140px; padding: 0; border: none;">
                <div class="info-container" style="border-left-color: #444;">
                    <div class="info-label">Data</div>
                    <div class="info-valor">'.$data_orcamento.'</div>
                </div>
            </td>
        </tr>
    </table>

    <table>
        <thead>
            <tr>
                <th class="col-produto">Produto</th>
                <th class="col-qtd text-center">Qtd</th>
                <th class="col-unit text-right">Unitário</th>
                <th class="col-total text-right">Total</th>
            </tr>
        </thead>
        <tbody>';

        if(count($itens_nome) > 0) {
            for($i=0; $i<count($itens_nome); $i++){
                $v_unit = limparDinheiroPHP($itens_valor[$i]);
                $v_total = limparDinheiroPHP($itens_total[$i]);
                $un = trim($itens_unidade[$i]);
                
                // Formatação da unidade
                $un_html = $un ? "<span class='badge-un'>".strtoupper($un)."</span>" : "";

                $html .= '<tr>
                    <td>'.$itens_nome[$i].'</td>
                    <td class="text-center">'.$itens_qtd[$i] . $un_html .'</td>
                    <td class="text-right">R$ '.number_format($v_unit, 2, ',', '.').'</td>
                    <td class="text-right">R$ '.number_format($v_total, 2, ',', '.').'</td>
                </tr>';
            }
        } else {
            $html .= '<tr><td colspan="4" class="text-center" style="padding: 30px; color: #ccc;">Nenhum item adicionado.</td></tr>';
        }

$html .= '
        </tbody>
    </table>

    <div class="box-totais">
        <table class="tabela-totais">
            <tr>
                <td class="label-resumo">Subtotal:</td>
                <td class="valor-resumo">R$ '.number_format($subtotal, 2, ',', '.').'</td>
            </tr>';
            
            if($frete > 0) {
                $html .= '<tr>
                    <td class="label-resumo">Frete:</td>
                    <td class="valor-resumo">+ R$ '.number_format($frete, 2, ',', '.').'</td>
                </tr>';
            }
            
            if($val_desc_real > 0) {
                $html .= '<tr>
                    <td class="label-resumo" style="color: #d32f2f;">Desconto:</td>
                    <td class="valor-resumo" style="color: #d32f2f;">'.$texto_desc.'</td>
                </tr>';
            }

$html .= '
            <tr class="total-final-row">
                <td style="font-size: 14px; font-weight:bold; color:#444;">TOTAL:</td>
                <td class="total-grande">R$ '.number_format($total_final, 2, ',', '.').'</td>
            </tr>
        </table>
        <div style="clear: both;"></div>
    </div>

    <div class="footer">
        Documento gerado eletronicamente. Não possui valor fiscal.
    </div>

</body>
</html>';

// --- GERAÇÃO DO PDF ---
$options = new Options();
$options->set('isRemoteEnabled', true); // Permite carregar a imagem da URL
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// --- SALVAR CÓPIA ---
$nome_limpo = preg_replace('/[^a-zA-Z0-9]/', '_', $cliente_nome);
$nome_arquivo = "Orcamento_" . $nome_limpo . "_" . date('Y-m-d_His') . ".pdf";

if(!is_dir('orcamentos_pdfs')) mkdir('orcamentos_pdfs');
file_put_contents("orcamentos_pdfs/" . $nome_arquivo, $dompdf->output());

// --- EXIBIR ---
$dompdf->stream($nome_arquivo, ["Attachment" => false]);
?>