<?php
// ARQUIVO: api.php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *"); // Evita bloqueio de navegador

// Configuração de Pastas
$pastaSalvos = 'orcamentos_salvos/';
$pastaPDFs = 'orcamentos_pdfs/';
$arquivoProdutos = 'produtos.json'; // O arquivo que vai guardar seu catálogo

// Cria as pastas se não existirem
if(!is_dir($pastaSalvos)) mkdir($pastaSalvos, 0777, true);
if(!is_dir($pastaPDFs)) mkdir($pastaPDFs, 0777, true);

// Cria o arquivo de produtos vazio se não existir
if(!file_exists($arquivoProdutos)) {
    file_put_contents($arquivoProdutos, '[]');
}

$acao = $_POST['acao'] ?? $_GET['acao'] ?? '';

// --- LOG DE ERROS (Para debug) ---
// Se der erro, procure por um arquivo 'error_log' na pasta
ini_set('log_errors', 1);
ini_set('error_log', 'php_errors.log');

try {
    // 1. SALVAR RASCUNHO
    if ($acao == 'salvar') {
        $dados = json_decode(file_get_contents('php://input'), true);
        if (!$dados || empty($dados['cliente'])) { throw new Exception('Dados inválidos'); }
        
        $nomeLimpo = preg_replace('/[^a-zA-Z0-9]/', '_', $dados['cliente']);
        $arquivo = $nomeLimpo . '_' . time() . '.json';
        
        if (file_put_contents($pastaSalvos . $arquivo, json_encode($dados))) {
            echo json_encode(['sucesso'=>true, 'msg'=>'Rascunho salvo!']);
        } else {
            throw new Exception('Erro de permissão ao salvar rascunho.');
        }
    }

    // 2. LISTAR RASCUNHOS
    elseif ($acao == 'listar') {
        $arquivos = glob($pastaSalvos . '*.json');
        $lista = [];
        if($arquivos) {
            array_multisort(array_map('filemtime', $arquivos), SORT_DESC, $arquivos);
            foreach ($arquivos as $arq) {
                $conteudo = json_decode(file_get_contents($arq), true);
                if($conteudo) {
                    $lista[] = [
                        'arquivo' => basename($arq),
                        'cliente' => $conteudo['cliente'] ?? 'Sem nome',
                        'data' => date('d/m/Y H:i', filemtime($arq)),
                        'total' => $conteudo['total_final'] ?? '0.00'
                    ];
                }
            }
        }
        echo json_encode($lista);
    }

    // 3. CARREGAR RASCUNHO
    elseif ($acao == 'carregar') {
        $arq = $_GET['arquivo'] ?? '';
        $caminho = $pastaSalvos . basename($arq);
        if (file_exists($caminho)) {
            echo file_get_contents($caminho);
        } else {
            echo json_encode([]);
        }
    }

    // 4. LISTAR PDFS
    elseif ($acao == 'listar_pdfs') {
        $arquivos = glob($pastaPDFs . '*.pdf');
        $lista = [];
        if($arquivos) {
            array_multisort(array_map('filemtime', $arquivos), SORT_DESC, $arquivos);
            foreach ($arquivos as $arq) {
                $lista[] = [
                    'nome_arquivo' => basename($arq),
                    'caminho' => $arq,
                    'data' => date('d/m/Y H:i', filemtime($arq)),
                    'tamanho' => round(filesize($arq) / 1024, 1) . ' KB'
                ];
            }
        }
        echo json_encode($lista);
    }

    // 5. LISTAR PRODUTOS (IMPORTANTE)
    elseif ($acao == 'listar_produtos') {
        if (file_exists($arquivoProdutos)) {
            $content = file_get_contents($arquivoProdutos);
            // Verifica se está vazio ou inválido
            if(empty($content) || $content == 'null') echo '[]';
            else echo $content;
        } else {
            echo '[]';
        }
    }

    // 6. SALVAR PRODUTOS (IMPORTANTE)
    elseif ($acao == 'salvar_produtos') {
        $rawInput = file_get_contents('php://input');
        $dados = json_decode($rawInput, true);
        
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception('Erro no formato JSON enviado.');
        }

        if (file_put_contents($arquivoProdutos, json_encode($dados, JSON_PRETTY_PRINT))) {
            echo json_encode(['sucesso' => true, 'msg' => 'Catálogo salvo com sucesso!']);
        } else {
            throw new Exception('Permissão negada ao gravar produtos.json');
        }
    }
    
    else {
        echo json_encode(['erro' => 'Ação não reconhecida']);
    }

} catch (Exception $e) {
    echo json_encode(['sucesso' => false, 'msg' => 'Erro: ' . $e->getMessage()]);
}
?>