<?php
require 'conexao.php';

$msg = '';
$estoque = getEstoque($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cli = $_POST['cliente'];
    $tel = $_POST['telefone'];
    $obs = $_POST['obs'];
    
    $q_int = intval($_POST['q_inteiro'] ?? 0);
    $q_meio = intval($_POST['q_meio'] ?? 0);
    $q_trop_g = intval($_POST['q_trop_g'] ?? 0);
    $q_trop_p = intval($_POST['q_trop_p'] ?? 0);
    $q_salp_g = intval($_POST['q_salp_g'] ?? 0);
    $q_salp_p = intval($_POST['q_salp_p'] ?? 0);
    $q_maio = intval($_POST['q_maionese'] ?? 0);
    $q_farofa = intval($_POST['q_farofa'] ?? 0);
    
    $total = ($q_int * $precos['inteiro']) + ($q_meio * $precos['meio']) +
             ($q_trop_g * $precos['trop_g']) + ($q_trop_p * $precos['trop_p']) +
             ($q_salp_g * $precos['salp_g']) + ($q_salp_p * $precos['salp_p']) +
             ($q_maio * $precos['maionese']) + ($q_farofa * $precos['farofa']);

    if ($total > 0) {
        $erro_estoque = false;
        if($q_int > $estoque['inteiro']) $erro_estoque = true;
        if($q_meio > $estoque['meio']) $erro_estoque = true;
        
        if (!$erro_estoque) {
            $sql = "INSERT INTO pedidos (cliente, telefone, observacao, valor_total, 
                    q_inteiro, q_meio, q_trop_g, q_trop_p, q_salp_g, q_salp_p, q_maionese, q_farofa, data_pedido) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
            $stmt = $pdo->prepare($sql);
            if($stmt->execute([$cli, $tel, $obs, $total, $q_int, $q_meio, $q_trop_g, $q_trop_p, $q_salp_g, $q_salp_p, $q_maio, $q_farofa])) {
                $msg = "<div class='alert alert-success fw-bold text-center mb-3 shadow-sm'>✅ Pedido Confirmado! R$ " . number_format($total, 2, ',', '.') . "</div>";
                $estoque = getEstoque($pdo);
            }
        } else {
            $msg = "<div class='alert alert-danger mb-3'>⚠️ Erro: Item esgotado durante o pedido!</div>";
        }
    } else {
        $msg = "<div class='alert alert-warning mb-3'>⚠️ Selecione algum item.</div>";
    }
}

function renderItem($label, $inputName, $price, $stock) {
    $is_out = ($stock <= 0);
    $rowClass = $is_out ? 'bg-danger bg-opacity-10' : 'bg-white';
    $nameClass = $is_out ? 'text-decoration-line-through text-danger' : 'fw-bold text-dark';
    $inputAttr = $is_out ? 'disabled value="0"' : 'value="0" min="0"';
    $stockDisplay = $is_out ? '<span class="badge bg-danger ms-1">ESGOTADO</span>' : "<small class='text-muted ms-1'>Restam: $stock</small>";
    $priceFmt = number_format($price, 2, ',', '.');

    return "
    <div class='d-flex justify-content-between align-items-center p-2 mb-2 border rounded shadow-sm $rowClass'>
        <div class='lh-sm'>
            <div class='$nameClass' style='font-size: 0.95rem;'>$label</div>
            <div style='font-size: 0.85rem;'>
                <span class='text-primary fw-bold'>R$ $priceFmt</span>
                $stockDisplay
            </div>
        </div>
        <div>
            <input type='number' name='$inputName' class='form-control text-center fw-bold border-secondary' style='width: 65px; height: 40px; font-size: 1.2rem;' $inputAttr onchange='calcTotal()'>
        </div>
    </div>
    ";
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PDV - Mais Churrasco</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body { background-color: #e9ecef; }
        .section-header { background: #495057; color: white; padding: 5px 10px; border-radius: 4px; font-size: 0.9rem; text-transform: uppercase; font-weight: bold; margin-bottom: 10px;}
        @media (min-width: 992px) { .sticky-checkout { position: sticky; top: 20px; } .main-area { padding-right: 20px; } }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark bg-dark mb-4 shadow-sm py-2">
        <div class="container-fluid">
            <a class="navbar-brand d-flex align-items-center" href="#">
                <img src="img/logomais.png" alt="Mais Churrasco" height="50" class="me-2">
            </a>
            <a href="painel.php" class="btn btn-outline-light btn-sm">Admin</a>
        </div>
    </nav>

    <div class="container-fluid px-4 pb-5">
        <?= $msg ?>
        <form method="POST" autocomplete="off">
            <div class="row g-4">
                <div class="col-lg-8 main-area">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <div class="card shadow-sm h-100">
                                <div class="card-body">
                                    <div class="section-header bg-warning text-dark"><i class="bi bi-fire"></i> ASSADOS</div>
                                    <?= renderItem("FG INTEIRO", "q_inteiro", $precos['inteiro'], $estoque['inteiro']) ?>
                                    <?= renderItem("FG MEIO", "q_meio", $precos['meio'], $estoque['meio']) ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card shadow-sm h-100">
                                <div class="card-body">
                                    <div class="section-header bg-info text-dark">EXTRAS</div>
                                    <?= renderItem("MAIONESE", "q_maionese", $precos['maionese'], $estoque['maionese']) ?>
                                    <?= renderItem("FAROFA", "q_farofa", $precos['farofa'], $estoque['farofa']) ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="card shadow-sm">
                                <div class="card-body">
                                    <div class="section-header">GUARNIÇÕES</div>
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <?= renderItem("TROPEIRO (G)", "q_trop_g", $precos['trop_g'], $estoque['trop_g']) ?>
                                            <?= renderItem("TROPEIRO (P)", "q_trop_p", $precos['trop_p'], $estoque['trop_p']) ?>
                                        </div>
                                        <div class="col-md-6">
                                            <?= renderItem("SALPICÃO (G)", "q_salp_g", $precos['salp_g'], $estoque['salp_g']) ?>
                                            <?= renderItem("SALPICÃO (P)", "q_salp_p", $precos['salp_p'], $estoque['salp_p']) ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card shadow border-0 sticky-checkout">
                        <div class="card-header bg-danger text-white text-center py-3">
                            <h5 class="m-0 fw-bold">FINALIZAR PEDIDO</h5>
                        </div>
                        <div class="card-body bg-white p-4">
                            <div class="mb-3">
                                <label class="form-label fw-bold small text-muted text-uppercase">Cliente</label>
                                <input type="text" name="cliente" class="form-control form-control-lg bg-light" required placeholder="Nome..." autofocus>
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-bold small text-muted text-uppercase">Telefone</label>
                                <input type="tel" name="telefone" class="form-control" placeholder="(31) 9...">
                            </div>
                            <div class="mb-3">
                                <label class="form-label fw-bold small text-muted text-uppercase">Observações</label>
                                <textarea name="obs" class="form-control" rows="2" placeholder="Ex: Sem cebola..."></textarea>
                            </div>
                            <hr>
                            <div class="text-center mb-3">
                                <small class="text-muted fw-bold">TOTAL A PAGAR</small>
                                <div class="display-4 fw-bold text-success">R$ <span id="displayTotal">0,00</span></div>
                            </div>
                            <button type="submit" class="btn btn-danger w-100 btn-lg fw-bold shadow-sm py-3">CONFIRMAR VENDA</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <script>
        const prices = {
            q_inteiro: <?= $precos['inteiro'] ?>, q_meio: <?= $precos['meio'] ?>,
            q_trop_g: <?= $precos['trop_g'] ?>, q_trop_p: <?= $precos['trop_p'] ?>,
            q_salp_g: <?= $precos['salp_g'] ?>, q_salp_p: <?= $precos['salp_p'] ?>,
            q_maionese: <?= $precos['maionese'] ?>, q_farofa: <?= $precos['farofa'] ?>
        };
        function calcTotal() {
            let total = 0;
            for (let key in prices) {
                let el = document.getElementsByName(key)[0];
                if (el && !el.disabled) {
                    let qtd = el.value ? parseInt(el.value) : 0;
                    total += qtd * prices[key];
                }
            }
            document.getElementById('displayTotal').innerText = total.toFixed(2).replace('.', ',');
        }
    </script>
</body>
</html>