<?php
require('fpdf/fpdf.php');
require('conexao.php'); // Certifique-se que o conexao.php tem a variavel $precos

class PDF extends FPDF {
    // Cabeçalho
    function Header() {
        $this->SetFont('Arial', 'B', 14);
        $this->SetFillColor(211, 84, 0); // Laranja Escuro
        $this->SetTextColor(255, 255, 255);
        $this->Cell(0, 10, utf8_decode('RELATÓRIO DE VENDAS DO DIA'), 0, 1, 'C', true);
        
        $this->SetTextColor(0);
        $this->SetFont('Arial', 'I', 9);
        $this->Cell(0, 8, 'Gerado em: ' . date('d/m/Y H:i'), 0, 1, 'R');
        $this->Ln(2);

        // Cabeçalho da Tabela
        $this->SetFont('Arial', 'B', 9);
        $this->SetFillColor(230, 230, 230);
        
        $this->Cell(10, 8, 'ID', 1, 0, 'C', true);
        $this->Cell(40, 8, 'Cliente', 1, 0, 'L', true);
        $this->Cell(95, 8, 'Resumo do Pedido', 1, 0, 'L', true); // Coluna larga para os itens
        $this->Cell(25, 8, 'Total (R$)', 1, 0, 'R', true);
        $this->Cell(20, 8, 'Status', 1, 1, 'C', true);
    }

    // Rodapé
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, utf8_decode('Página ') . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }
}

// --- LÓGICA DE DADOS ---

// Busca pedidos SOMENTE DE HOJE
$sql = "SELECT * FROM pedidos WHERE DATE(data_pedido) = CURDATE() ORDER BY id ASC";
$pedidos = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

// Variáveis para somatórios
$total_financeiro = 0;
$soma_qtd = [
    'inteiro' => 0, 'meio' => 0, 
    'trop_g' => 0, 'trop_p' => 0,
    'salp_g' => 0, 'salp_p' => 0,
    'maionese' => 0, 'farofa' => 0
];

// Inicia PDF
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 9);

foreach ($pedidos as $p) {
    $total_financeiro += $p['valor_total'];

    // Monta string de resumo e soma quantidades
    $itens_txt = [];
    
    if($p['q_inteiro'] > 0) { $itens_txt[] = $p['q_inteiro']."x Int"; $soma_qtd['inteiro'] += $p['q_inteiro']; }
    if($p['q_meio'] > 0)    { $itens_txt[] = $p['q_meio']."x Meio"; $soma_qtd['meio'] += $p['q_meio']; }
    if($p['q_trop_g'] > 0)  { $itens_txt[] = $p['q_trop_g']."x Tr(G)"; $soma_qtd['trop_g'] += $p['q_trop_g']; }
    if($p['q_trop_p'] > 0)  { $itens_txt[] = $p['q_trop_p']."x Tr(P)"; $soma_qtd['trop_p'] += $p['q_trop_p']; }
    if($p['q_salp_g'] > 0)  { $itens_txt[] = $p['q_salp_g']."x Sal(G)"; $soma_qtd['salp_g'] += $p['q_salp_g']; }
    if($p['q_salp_p'] > 0)  { $itens_txt[] = $p['q_salp_p']."x Sal(P)"; $soma_qtd['salp_p'] += $p['q_salp_p']; }
    if($p['q_maionese'] > 0){ $itens_txt[] = $p['q_maionese']."x Maio"; $soma_qtd['maionese'] += $p['q_maionese']; }
    if($p['q_farofa'] > 0)  { $itens_txt[] = $p['q_farofa']."x Far"; $soma_qtd['farofa'] += $p['q_farofa']; }

    $resumo = implode(', ', $itens_txt);
    
    // Status
    $status = $p['pago'] ? 'PAGO' : 'PENDENTE';

    // Desenha linha
    $pdf->Cell(10, 8, $p['id'], 1, 0, 'C');
    $pdf->Cell(40, 8, utf8_decode(substr($p['cliente'], 0, 20)), 1, 0, 'L');
    $pdf->Cell(95, 8, utf8_decode($resumo), 1, 0, 'L');
    $pdf->Cell(25, 8, number_format($p['valor_total'], 2, ',', '.'), 1, 0, 'R');
    $pdf->Cell(20, 8, $status, 1, 1, 'C');
}

// --- QUADRO DE RESUMO FINAL ---
$pdf->Ln(10);
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'RESUMO GERAL DO DIA', 0, 1, 'L');

$pdf->SetFont('Arial', '', 10);
$pdf->SetFillColor(245, 245, 245);

// Linha 1 de totais
$pdf->Cell(45, 8, utf8_decode('Frangos Inteiros: ') . $soma_qtd['inteiro'], 1, 0, 'L', true);
$pdf->Cell(45, 8, utf8_decode('Meios Frangos: ') . $soma_qtd['meio'], 1, 0, 'L', true);
$pdf->Cell(50, 8, utf8_decode('Tropeiros (G/P): ') . $soma_qtd['trop_g'] . ' / ' . $soma_qtd['trop_p'], 1, 0, 'L', true);
$pdf->Cell(50, 8, utf8_decode('Salpicão (G/P): ') . $soma_qtd['salp_g'] . ' / ' . $soma_qtd['salp_p'], 1, 1, 'L', true);

// Linha 2 de totais
$pdf->Cell(45, 8, utf8_decode('Maioneses: ') . $soma_qtd['maionese'], 1, 0, 'L', true);
$pdf->Cell(45, 8, utf8_decode('Farofas: ') . $soma_qtd['farofa'], 1, 1, 'L', true);

$pdf->Ln(5);

// Faturamento
$pdf->SetFont('Arial', 'B', 16);
$pdf->SetTextColor(255, 0, 0); // Vermelho
$pdf->Cell(60, 12, 'FATURAMENTO: ', 0, 0, 'L');
$pdf->Cell(50, 12, 'R$ ' . number_format($total_financeiro, 2, ',', '.'), 0, 1, 'L');

$pdf->Output('I', 'Relatorio_Vendas.pdf');
?>