<?php
require 'conexao.php';
verificarLogin();

if (isset($_GET['sair'])) session_destroy() & header("Location: login.php");

// Ações
if (isset($_GET['acao']) && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    if ($_GET['acao'] == 'pagar') $pdo->query("UPDATE pedidos SET pago = NOT pago WHERE id = $id");
    if ($_GET['acao'] == 'entregar') $pdo->query("UPDATE pedidos SET entregue = 1 WHERE id = $id");
    if ($_GET['acao'] == 'deletar') $pdo->query("DELETE FROM pedidos WHERE id = $id");
    if ($_GET['acao'] == 'restaurar') $pdo->query("UPDATE pedidos SET entregue = 0 WHERE id = $id");
    header("Location: painel.php"); exit;
}

if (isset($_POST['update_stock'])) {
    $sql = "UPDATE config SET estoque_inteiro=?, estoque_meio=?, estoque_trop_g=?, estoque_trop_p=?, 
            estoque_salp_g=?, estoque_salp_p=?, estoque_maionese=?, estoque_farofa=?";
    $pdo->prepare($sql)->execute([
        $_POST['e_int'], $_POST['e_meio'], $_POST['e_tg'], $_POST['e_tp'], 
        $_POST['e_sg'], $_POST['e_sp'], $_POST['e_maio'], $_POST['e_far']
    ]);
    header("Location: painel.php"); exit;
}

$pedidos = $pdo->query("SELECT * FROM pedidos WHERE entregue = 0 ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
$entregues = $pdo->query("SELECT * FROM pedidos WHERE entregue = 1 AND DATE(data_pedido) = CURDATE() ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
$cfg = $pdo->query("SELECT * FROM config LIMIT 1")->fetch(PDO::FETCH_ASSOC);
$estoque_real = getEstoque($pdo);

// MUDANÇA AQUI: Função de resumo atualizada
function listaResumida($p) {
    $txt = [];
    if($p['q_inteiro']>0) $txt[]=$p['q_inteiro']." FG INTEIRO"; 
    if($p['q_meio']>0) $txt[]=$p['q_meio']." FG MEIO";
    if($p['q_trop_g']>0) $txt[]=$p['q_trop_g']." TR(G)"; if($p['q_trop_p']>0) $txt[]=$p['q_trop_p']." TR(P)";
    if($p['q_salp_g']>0) $txt[]=$p['q_salp_g']." SA(G)"; if($p['q_salp_p']>0) $txt[]=$p['q_salp_p']." SA(P)";
    if($p['q_maionese']>0) $txt[]=$p['q_maionese']." MAIO"; if($p['q_farofa']>0) $txt[]=$p['q_farofa']." FAR";
    return implode(', ', $txt);
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <title>Painel Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        .badge-pago { background: #198754; cursor: pointer; }
        .badge-pendente { background: #dc3545; cursor: pointer; }
        .table-entregues { background: #e9ecef; color: #6c757d; font-size: 0.9em; }
        .box-estoque { background: #fff; border: 1px solid #ccc; padding: 5px; border-radius: 5px; text-align: center; }
        .label-topo { font-size: 10px; font-weight: bold; color: #666; text-transform: uppercase; display: block; }
        .input-inicial { width: 100%; border: 1px solid #ddd; text-align: center; color: #999; font-size: 12px; margin-bottom: 2px; }
        .valor-restante { font-size: 20px; font-weight: bold; color: #d35400; display: block; line-height: 1.2; }
        .label-resta { font-size: 9px; color: #d35400; }
    </style>
</head>
<body class="bg-light">
    <nav class="navbar navbar-dark bg-dark mb-3 px-3 py-3 shadow">
        <div class="container-fluid d-flex justify-content-between">
            <span class="navbar-brand h1 m-0"><i class="bi bi-gear-fill"></i> Gerenciador</span>
            <div class="d-flex gap-2">
                <a href="index.php" class="btn btn-warning fw-bold"><i class="bi bi-cart-plus"></i> VENDER</a>
                <a href="relatorio.php" target="_blank" class="btn btn-info fw-bold text-white"><i class="bi bi-printer"></i> PDF</a>
                <a href="?sair=true" class="btn btn-outline-light btn-sm">Sair</a>
            </div>
        </div>
    </nav>

    <div class="container-fluid px-3">
        <div class="card mb-4 shadow-sm border-secondary">
            <div class="card-header bg-secondary text-white py-1">
                <small><i class="bi bi-box-seam"></i> CONTROLE DE ESTOQUE (INICIAL vs RESTANTE)</small>
            </div>
            <div class="card-body bg-light p-2">
                <form method="POST">
                    <div class="row g-1">
                        <div class="col">
                            <div class="box-estoque">
                                <span class="label-topo">FG INTEIRO</span>
                                <input type="number" name="e_int" value="<?=$cfg['estoque_inteiro']?>" class="input-inicial">
                                <span class="valor-restante"><?= $estoque_real['inteiro'] ?></span>
                                <span class="label-resta">RESTAM</span>
                            </div>
                        </div>
                        <div class="col">
                            <div class="box-estoque">
                                <span class="label-topo">FG MEIO</span>
                                <input type="number" name="e_meio" value="<?=$cfg['estoque_meio']?>" class="input-inicial">
                                <span class="valor-restante"><?= $estoque_real['meio'] ?></span>
                                <span class="label-resta">RESTAM</span>
                            </div>
                        </div>
                        <div class="col"><div class="box-estoque"><span class="label-topo">TROP(G)</span><input type="number" name="e_tg" value="<?=$cfg['estoque_trop_g']?>" class="input-inicial"><span class="valor-restante"><?= $estoque_real['trop_g'] ?></span><span class="label-resta">RESTAM</span></div></div>
                        <div class="col"><div class="box-estoque"><span class="label-topo">TROP(P)</span><input type="number" name="e_tp" value="<?=$cfg['estoque_trop_p']?>" class="input-inicial"><span class="valor-restante"><?= $estoque_real['trop_p'] ?></span><span class="label-resta">RESTAM</span></div></div>
                        <div class="col"><div class="box-estoque"><span class="label-topo">SALP(G)</span><input type="number" name="e_sg" value="<?=$cfg['estoque_salp_g']?>" class="input-inicial"><span class="valor-restante"><?= $estoque_real['salp_g'] ?></span><span class="label-resta">RESTAM</span></div></div>
                        <div class="col"><div class="box-estoque"><span class="label-topo">SALP(P)</span><input type="number" name="e_sp" value="<?=$cfg['estoque_salp_p']?>" class="input-inicial"><span class="valor-restante"><?= $estoque_real['salp_p'] ?></span><span class="label-resta">RESTAM</span></div></div>
                        <div class="col"><div class="box-estoque"><span class="label-topo">MAIO</span><input type="number" name="e_maio" value="<?=$cfg['estoque_maionese']?>" class="input-inicial"><span class="valor-restante"><?= $estoque_real['maionese'] ?></span><span class="label-resta">RESTAM</span></div></div>
                        <div class="col"><div class="box-estoque"><span class="label-topo">FAROFA</span><input type="number" name="e_far" value="<?=$cfg['estoque_farofa']?>" class="input-inicial"><span class="valor-restante"><?= $estoque_real['farofa'] ?></span><span class="label-resta">RESTAM</span></div></div>
                        
                        <div class="col-auto d-flex align-items-center">
                            <button type="submit" name="update_stock" class="btn btn-primary btn-sm h-100 fw-bold">DEFINIR<br>INICIAL</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <div class="card shadow mb-4 border-danger">
            <div class="card-header bg-danger text-white d-flex justify-content-between">
                <span>PEDIDOS NA FILA</span>
                <span class="badge bg-white text-danger"><?= count($pedidos) ?></span>
            </div>
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                        <tr><th>#</th><th>Cliente</th><th>Itens</th><th>Total</th><th>Status</th><th class="text-end">Ações</th></tr>
                    </thead>
                    <tbody>
                        <?php foreach($pedidos as $p): ?>
                        <tr>
                            <td class="fw-bold"><?= $p['id'] ?></td>
                            <td><b><?= htmlspecialchars($p['cliente']) ?></b><br><small><?= $p['telefone'] ?></small></td>
                            <td class="fw-bold text-primary small"><?= listaResumida($p) ?></td>
                            <td class="fw-bold">R$ <?= number_format($p['valor_total'],2,',','.') ?></td>
                            <td><a href="?acao=pagar&id=<?= $p['id'] ?>" class="text-decoration-none"><?= $p['pago'] ? '<span class="badge badge-pago">PAGO</span>' : '<span class="badge badge-pendente">RECEBER</span>' ?></a></td>
                            <td class="text-end">
                                <button onclick="window.open('imprimir.php?id=<?= $p['id'] ?>', '_blank', 'width=400,height=600')" class="btn btn-dark btn-sm"><i class="bi bi-printer"></i></button>
                                <a href="?acao=entregar&id=<?= $p['id'] ?>" class="btn btn-success btn-sm ms-1"><i class="bi bi-check-lg"></i></a>
                                <a href="?acao=deletar&id=<?= $p['id'] ?>" class="btn btn-outline-danger btn-sm border-0 ms-1" onclick="return confirm('Cancelar?')"><i class="bi bi-x-lg"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php if(empty($pedidos)): ?><tr><td colspan="6" class="text-center py-4 text-muted">Fila Vazia</td></tr><?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="card shadow-sm mb-5 border-success">
            <div class="card-header bg-success text-white py-1"><small>ENTREGUES HOJE</small></div>
            <div class="table-responsive">
                <table class="table table-sm table-entregues mb-0">
                    <?php foreach($entregues as $e): ?>
                    <tr>
                        <td><?= $e['id'] ?></td>
                        <td><?= htmlspecialchars($e['cliente']) ?></td>
                        <td><?= listaResumida($e) ?></td>
                        <td>R$ <?= number_format($e['valor_total'],2,',','.') ?></td>
                        <td class="text-end"><a href="?acao=restaurar&id=<?= $e['id'] ?>" class="text-secondary small fw-bold">DESFAZER</a></td>
                    </tr>
                    <?php endforeach; ?>
                </table>
            </div>
        </div>
    </div>
</body>
</html>