<?php
require 'conexao.php';

$msg = '';
// Busca o estoque atualizado
$estoque = getEstoque($pdo);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cli = $_POST['cliente'];
    $tel = $_POST['telefone'];
    $obs = $_POST['obs'];
    
    // Captura quantidades com segurança
    $q_int = intval($_POST['q_inteiro'] ?? 0);
    $q_meio = intval($_POST['q_meio'] ?? 0);
    $q_trop_g = intval($_POST['q_trop_g'] ?? 0);
    $q_trop_p = intval($_POST['q_trop_p'] ?? 0);
    $q_salp_g = intval($_POST['q_salp_g'] ?? 0);
    $q_salp_p = intval($_POST['q_salp_p'] ?? 0);
    $q_maio = intval($_POST['q_maionese'] ?? 0);
    $q_farofa = intval($_POST['q_farofa'] ?? 0);
    
    // Calcula totais
    $total = ($q_int * $precos['inteiro']) + ($q_meio * $precos['meio']) +
             ($q_trop_g * $precos['trop_g']) + ($q_trop_p * $precos['trop_p']) +
             ($q_salp_g * $precos['salp_g']) + ($q_salp_p * $precos['salp_p']) +
             ($q_maio * $precos['maionese']) + ($q_farofa * $precos['farofa']);

    if ($total > 0) {
        // Validação extra no backend: Se tentar comprar algo esgotado, bloqueia
        // (Isso previne que alguém burle o HTML)
        $erro_estoque = false;
        if($q_int > $estoque['inteiro']) $erro_estoque = true;
        if($q_meio > $estoque['meio']) $erro_estoque = true;
        // ... você pode adicionar validação para todos se quiser ser muito rigoroso

        if (!$erro_estoque) {
            $sql = "INSERT INTO pedidos (cliente, telefone, observacao, valor_total, 
                    q_inteiro, q_meio, q_trop_g, q_trop_p, q_salp_g, q_salp_p, q_maionese, q_farofa, data_pedido) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
            $stmt = $pdo->prepare($sql);
            if($stmt->execute([$cli, $tel, $obs, $total, $q_int, $q_meio, $q_trop_g, $q_trop_p, $q_salp_g, $q_salp_p, $q_maio, $q_farofa])) {
                $msg = "<div class='alert alert-success fw-bold text-center'>✅ Pedido realizado com sucesso!<br>Total: R$ " . number_format($total, 2, ',', '.') . "</div>";
                $estoque = getEstoque($pdo); // Atualiza visualização imediatamente
            }
        } else {
            $msg = "<div class='alert alert-danger'>⚠️ Erro: Você tentou pedir um item que acabou de esgotar!</div>";
        }
    } else {
        $msg = "<div class='alert alert-warning'>⚠️ Selecione pelo menos um item.</div>";
    }
}

// --- FUNÇÃO PARA GERAR A LINHA DO PRODUTO (HTML) ---
function renderItem($label, $inputName, $price, $stock) {
    // Se estoque for 0 ou menor, marca como esgotado
    $is_out = ($stock <= 0);
    
    // Classes CSS dinâmicas
    $rowClass = $is_out ? 'bg-danger bg-opacity-10 border-danger' : 'border-bottom';
    $nameClass = $is_out ? 'text-decoration-line-through text-danger opacity-50' : 'fw-bold';
    $inputAttr = $is_out ? 'disabled value="0"' : 'value="0" min="0"';
    
    // O que mostrar: Texto de Restante ou Badge ESGOTADO
    $stockDisplay = $is_out 
        ? '<span class="badge bg-danger">ESGOTADO</span>' 
        : "<small class='text-muted fw-bold' style='font-size:0.8em'>Restam: $stock</small>";

    $priceFmt = number_format($price, 2, ',', '.');

    return "
    <div class='d-flex justify-content-between align-items-center mb-2 p-2 rounded $rowClass'>
        <div class='lh-1'>
            <div class='$nameClass'>$label</div>
            <div class='mt-1'>
                <span class='text-primary fw-bold me-2'>R$ $priceFmt</span>
                $stockDisplay
            </div>
        </div>
        <div>
            <input type='number' name='$inputName' class='form-control text-center fw-bold shadow-sm' style='width: 70px; font-size: 1.2rem;' $inputAttr onchange='calcTotal()'>
        </div>
    </div>
    ";
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Novo Pedido</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .cat-title { 
            background: #343a40; color: #fff; 
            padding: 8px 15px; font-weight: bold; 
            margin-top: 20px; border-radius: 5px; 
            text-transform: uppercase; letter-spacing: 1px;
        }
        .card-header { background: #d35400; color: white; }
    </style>
</head>
<body>
    <div class="container py-3">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="card shadow border-0">
                    <div class="card-header text-center py-3">
                        <h4 class="m-0">🍗 Novo Pedido</h4>
                    </div>
                    <div class="card-body p-3">
                        <?= $msg ?>
                        
                        <form method="POST" autocomplete="off">
                            <div class="mb-2">
                                <label class="fw-bold small text-muted">Nome do Cliente</label>
                                <input type="text" name="cliente" class="form-control" required placeholder="Ex: João">
                            </div>
                            <div class="mb-3">
                                <label class="fw-bold small text-muted">Telefone</label>
                                <input type="tel" name="telefone" class="form-control" placeholder="(xx) 9xxxx-xxxx">
                            </div>

                            <div class="cat-title"><small>Assados</small></div>
                            <?= renderItem("FG INTEIRO", "q_inteiro", $precos['inteiro'], $estoque['inteiro']) ?>
                            <?= renderItem("FG MEIO", "q_meio", $precos['meio'], $estoque['meio']) ?>

                            <div class="cat-title"><small>Guarnições</small></div>
                            <?= renderItem("TROPEIRO (G)", "q_trop_g", $precos['trop_g'], $estoque['trop_g']) ?>
                            <?= renderItem("TROPEIRO (P)", "q_trop_p", $precos['trop_p'], $estoque['trop_p']) ?>
                            <?= renderItem("SALPICÃO (G)", "q_salp_g", $precos['salp_g'], $estoque['salp_g']) ?>
                            <?= renderItem("SALPICÃO (P)", "q_salp_p", $precos['salp_p'], $estoque['salp_p']) ?>

                            <div class="cat-title"><small>Extras</small></div>
                            <?= renderItem("MAIONESE", "q_maionese", $precos['maionese'], $estoque['maionese']) ?>
                            <?= renderItem("FAROFA", "q_farofa", $precos['farofa'], $estoque['farofa']) ?>

                            <div class="mb-3 mt-4">
                                <label class="fw-bold small text-muted">Observação</label>
                                <textarea name="obs" class="form-control" rows="2" placeholder="Ex: Cortar em pedaços..."></textarea>
                            </div>

                            <div class="alert alert-dark text-center py-3 mb-3">
                                <small class="text-uppercase text-muted fw-bold">Total do Pedido</small><br>
                                <span class="fs-2 fw-bold text-success">R$ <span id="displayTotal">0,00</span></span>
                            </div>

                            <div class="d-grid gap-2">
                                <button type="submit" class="btn btn-danger btn-lg fw-bold shadow">
                                    CONFIRMAR PEDIDO
                                </button>
                                <a href="painel.php" class="btn btn-outline-secondary btn-sm">
                                    Acessar Painel Admin
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Passa os preços do PHP para o JS
        const prices = {
            q_inteiro: <?= $precos['inteiro'] ?>, q_meio: <?= $precos['meio'] ?>,
            q_trop_g: <?= $precos['trop_g'] ?>, q_trop_p: <?= $precos['trop_p'] ?>,
            q_salp_g: <?= $precos['salp_g'] ?>, q_salp_p: <?= $precos['salp_p'] ?>,
            q_maionese: <?= $precos['maionese'] ?>, q_farofa: <?= $precos['farofa'] ?>
        };

        function calcTotal() {
            let total = 0;
            for (let key in prices) {
                // Se o campo estiver desativado (esgotado), o value será 0 ou ignorado, 
                // mas garantimos pegando o elemento corretamente
                let el = document.getElementsByName(key)[0];
                if (el && !el.disabled) {
                    let qtd = el.value ? parseInt(el.value) : 0;
                    total += qtd * prices[key];
                }
            }
            document.getElementById('displayTotal').innerText = total.toFixed(2).replace('.', ',');
        }
    </script>
</body>
</html>