<?php
require 'conexao.php';
verificarLogin();

if (!isset($_GET['id'])) die("ID não informado");
$id = intval($_GET['id']);
$stmt = $pdo->prepare("SELECT * FROM pedidos WHERE id = ?");
$stmt->execute([$id]);
$p = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$p) die("Pedido não encontrado");

function checkRow($qtd, $nome, $preco_unit) {
    if ($qtd > 0) {
        $total_item = number_format($qtd * $preco_unit, 2, ',', '.');
        return "
        <tr class='row-active'>
            <td class='qtd-box'>$qtd</td>
            <td class='prod-name'>$nome</td>
            <td class='prod-price'>$total_item</td>
        </tr>";
    } else {
        return "
        <tr class='row-inactive'>
            <td class='qtd-box'>-</td>
            <td class='prod-name'>$nome</td>
            <td class='prod-price'>-</td>
        </tr>";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Pedido #<?= $id ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Arial', sans-serif; width: 80mm; padding: 5px; background: #fff; color: #000; }
        @media print { .no-print { display: none !important; } @page { margin: 0; } }
        .header { text-align: center; margin-bottom: 10px; border-bottom: 2px solid #000; padding-bottom: 5px; }
        .cli-info { font-size: 14px; margin-bottom: 10px; font-weight: bold; line-height: 1.4; }
        .check-table { width: 100%; border-collapse: collapse; font-size: 13px; }
        .check-table td { padding: 4px 0; border-bottom: 1px dotted #ccc; }
        .row-active { font-weight: bold; color: #000; }
        .row-inactive { color: #ccc; font-size: 11px; }
        .qtd-box { width: 30px; text-align: center; font-size: 16px; font-weight: 800; }
        .prod-name { text-align: left; padding-left: 5px; }
        .prod-price { text-align: right; }
        .total-area { margin-top: 15px; border-top: 2px solid #000; padding-top: 5px; font-size: 18px; font-weight: bold; text-align: right; }
        .obs-box { border: 2px solid #000; padding: 8px; margin-top: 10px; font-weight: bold; font-size: 14px; text-align: center; background: #eee; -webkit-print-color-adjust: exact; }
        .btn-print { width: 100%; padding: 15px; background: #000; color: #fff; border: none; font-size: 16px; cursor: pointer; margin-bottom: 10px; }
    </style>
</head>
<body>
    <button class="btn-print no-print" onclick="window.print()">IMPRIMIR</button>

    <div class="header">
        <h2 style="margin:0">SENHA: <?= str_pad($p['id'], 3, '0', STR_PAD_LEFT) ?></h2>
        <small><?= date('d/m H:i', strtotime($p['data_pedido'])) ?></small>
    </div>

    <div class="cli-info">
        <?= strtoupper(substr($p['cliente'], 0, 25)) ?><br>
        TEL: <?= $p['telefone'] ?>
    </div>

    <table class="check-table">
        <tr style="border-bottom: 1px solid #000; font-size: 10px;">
            <th style="text-align:center">QTD</th>
            <th style="text-align:left; padding-left:5px">ITEM</th>
            <th style="text-align:right">$$</th>
        </tr>

        <?= checkRow($p['q_inteiro'], "FG INTEIRO", $precos['inteiro']) ?>
        <?= checkRow($p['q_meio'], "FG MEIO", $precos['meio']) ?>
        <?= checkRow($p['q_trop_g'], "TROPEIRO (G)", $precos['trop_g']) ?>
        <?= checkRow($p['q_trop_p'], "TROPEIRO (P)", $precos['trop_p']) ?>
        <?= checkRow($p['q_salp_g'], "SALPICÃO (G)", $precos['salp_g']) ?>
        <?= checkRow($p['q_salp_p'], "SALPICÃO (P)", $precos['salp_p']) ?>
        <?= checkRow($p['q_maionese'], "MAIONESE", $precos['maionese']) ?>
        <?= checkRow($p['q_farofa'], "FAROFA", $precos['farofa']) ?>
    </table>

    <div class="total-area">
        TOTAL: R$ <?= number_format($p['valor_total'], 2, ',', '.') ?>
    </div>
    
    <div style="text-align: right; font-size: 12px; margin-top: 5px; font-weight: bold;">
        <?= $p['pago'] ? 'PAGAMENTO: [ OK ]' : 'PAGAMENTO: [ PENDENTE ]' ?>
    </div>

    <?php if(!empty($p['observacao'])): ?>
    <div class="obs-box">
        OBS: <?= strtoupper($p['observacao']) ?>
    </div>
    <?php endif; ?>

    <script>
        window.onload = function() { setTimeout(function() { window.print(); }, 800); }
    </script>
</body>
</html>