<?php
session_start();

// 1. FORÇA HORÁRIO DE BRASÍLIA NO PHP
date_default_timezone_set('America/Sao_Paulo');

$host = 'localhost';
$dbname = 'frango_db';
$username = 'root';
$password = '';

// TABELA DE PREÇOS
$precos = [
    'inteiro' => 50.00,
    'meio'    => 30.00,
    'trop_g'  => 25.00,
    'trop_p'  => 15.00,
    'salp_g'  => 25.00,
    'salp_p'  => 15.00,
    'maionese'=> 8.00,
    'farofa'  => 5.00
];

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

function verificarLogin() {
    if (!isset($_SESSION['usuario_logado'])) {
        header("Location: login.php");
        exit;
    }
}

// FUNÇÃO DE ESTOQUE BLINDADA
function getEstoque($pdo) {
    // A. Busca Estoque Inicial (Configuração)
    $stmt = $pdo->query("SELECT * FROM config LIMIT 1");
    $cfg = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$cfg) {
        // Retorna zerado se não houver config
        return array_fill_keys(['inteiro','meio','trop_g','trop_p','salp_g','salp_p','maionese','farofa'], 0);
    }
    
    // B. Soma itens vendidos HOJE (usando data do PHP para garantir precisão)
    $inicio_dia = date('Y-m-d 00:00:00');
    $fim_dia    = date('Y-m-d 23:59:59');
    
    // COALESCE(SUM(...), 0) garante que retorne 0 em vez de erro se não tiver vendas
    $sql = "SELECT 
            COALESCE(SUM(q_inteiro), 0) as s_inteiro, 
            COALESCE(SUM(q_meio), 0) as s_meio,
            COALESCE(SUM(q_trop_g), 0) as s_trop_g, 
            COALESCE(SUM(q_trop_p), 0) as s_trop_p,
            COALESCE(SUM(q_salp_g), 0) as s_salp_g, 
            COALESCE(SUM(q_salp_p), 0) as s_salp_p,
            COALESCE(SUM(q_maionese), 0) as s_maionese, 
            COALESCE(SUM(q_farofa), 0) as s_farofa
            FROM pedidos 
            WHERE data_pedido >= '$inicio_dia' AND data_pedido <= '$fim_dia'";
            
    $stmt = $pdo->query($sql);
    $vendidos = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // C. Retorna Array com cálculo: INICIAL - VENDIDO
    return [
        'inteiro' => $cfg['estoque_inteiro'] - $vendidos['s_inteiro'],
        'meio'    => $cfg['estoque_meio']    - $vendidos['s_meio'],
        'trop_g'  => $cfg['estoque_trop_g']  - $vendidos['s_trop_g'],
        'trop_p'  => $cfg['estoque_trop_p']  - $vendidos['s_trop_p'],
        'salp_g'  => $cfg['estoque_salp_g']  - $vendidos['s_salp_g'],
        'salp_p'  => $cfg['estoque_salp_p']  - $vendidos['s_salp_p'],
        'maionese'=> $cfg['estoque_maionese']- $vendidos['s_maionese'],
        'farofa'  => $cfg['estoque_farofa']  - $vendidos['s_farofa'],
    ];
}
?>