<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> <title>App Entregador</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { font-family: sans-serif; background: #222; color: #fff; margin: 0; padding: 10px; }
        
        /* TELA DE LOGIN */
        #tela-login { text-align: center; margin-top: 50px; }
        .btn-moto { display: block; width: 100%; padding: 20px; margin: 10px 0; background: #444; color: white; border: 1px solid #555; font-size: 1.2rem; border-radius: 10px; cursor: pointer; }
        .btn-moto:active { background: #FF6B00; }

        /* LISTA DE ENTREGAS */
        #tela-lista { display: none; }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; border-bottom: 1px solid #444; padding-bottom: 10px; }
        
        .card { background: #333; border-radius: 10px; padding: 15px; margin-bottom: 15px; border-left: 5px solid #FF6B00; }
        .card h2 { margin: 0 0 10px 0; font-size: 1.1rem; }
        .card p { color: #ccc; margin: 5px 0; }
        .card strong { color: #FF6B00; font-size: 1.2rem; }
        
        /* ESTILOS DOS BOTÕES (AGORA PADRONIZADOS) */
        .btn-acao {
            display: block; 
            width: 100%; 
            text-align: center; 
            padding: 12px; /* Tamanho igual para ambos */
            border-radius: 8px; 
            margin-top: 10px;
            font-weight: bold; 
            font-size: 1rem;
            text-decoration: none; 
            border: none;
            cursor: pointer;
            box-sizing: border-box; /* Garante que a borda não aumente o tamanho */
            color: white;
            font-family: sans-serif;
        }

        .btn-gps { background: #2ecc71; } /* Verde */
        .btn-concluir { background: #e74c3c; } /* Vermelho */
        
        /* Efeito de clique */
        .btn-acao:active { opacity: 0.8; transform: scale(0.98); }

    </style>
</head>
<body>

    <div id="tela-login">
        <h2>Quem é você?</h2>
        <button class="btn-moto" onclick="logar(1)">Entregador 01</button>
        <button class="btn-moto" onclick="logar(2)">Entregador 02</button>
        <button class="btn-moto" onclick="logar(3)">Entregador 03</button>
        <button class="btn-moto" onclick="logar(4)">Entregador 04</button>
    </div>

    <div id="tela-lista">
        <div class="header">
            <span id="nome-moto">Moto ?</span>
            <button onclick="sair()" style="background:none; border:none; color:#ccc;">Sair</button>
        </div>
        
        <div id="lista-pedidos">Carregando...</div>
    </div>

    <script>
        let meuId = localStorage.getItem('delivery_moto_id');

        // Se já tiver logado, vai direto pra lista
        if (meuId) {
            mostrarLista(meuId);
        }

        function logar(id) {
            localStorage.setItem('delivery_moto_id', id);
            meuId = id;
            mostrarLista(id);
        }

        function sair() {
            localStorage.removeItem('delivery_moto_id');
            location.reload();
        }

        function mostrarLista(id) {
            document.getElementById('tela-login').style.display = 'none';
            document.getElementById('tela-lista').style.display = 'block';
            document.getElementById('nome-moto').innerText = "Entregador 0" + id;
            
            carregarMeusPedidos();
            setInterval(carregarMeusPedidos, 10000); // Atualiza a cada 10s
        }

        function carregarMeusPedidos() {
            // Reutilizamos a API get_pedidos e filtramos no JS
            fetch('../api/get_pedidos.php')
                .then(res => res.json())
                .then(todosPedidos => {
                    // Filtra onde status é 'saiu_entrega' E o ID do entregador bate
                    const meus = todosPedidos.filter(p => p.status === 'saiu_entrega' && p.entregador_id == meuId);
                    renderizar(meus);
                })
                .catch(err => console.log("Erro de conexão ou JSON vazio"));
        }

        function renderizar(pedidos) {
            const container = document.getElementById('lista-pedidos');
            
            if(pedidos.length === 0) {
                container.innerHTML = '<p style="text-align:center; margin-top:50px; opacity:0.5">Nenhuma entrega agora.<br>Aguarde...</p>';
                return;
            }

            container.innerHTML = '';
            pedidos.forEach(p => {
                // Link GPS Direto
                const linkMap = `https://www.google.com/maps/dir/?api=1&destination=${p.lat},${p.lng}`;

                let html = `
                    <div class="card">
                        <h2>#${p.id} - ${p.cliente_nome}</h2>
                        <p>${p.endereco_escrito}</p>
                        <p>Total a cobrar: <strong>R$ ${p.total}</strong></p>
                        
                        <a href="${linkMap}" target="_blank" class="btn-acao btn-gps">
                            <i class="fas fa-location-arrow"></i> ABRIR NO GPS
                        </a>

                        <button class="btn-acao btn-concluir" onclick="entregue(${p.id})">
                            <i class="fas fa-check"></i> ENTREGUE / RECEBIDO
                        </button>
                    </div>
                `;
                container.innerHTML += html;
            });
        }

        function entregue(id) {
            if(!confirm("Entregou o pedido e recebeu o dinheiro?")) return;
            
            fetch('../api/atualizar_status.php', {
                method: 'POST',
                body: JSON.stringify({ id: id, status: 'concluido' })
            }).then(() => carregarMeusPedidos());
        }
    </script>
</body>
</html>