<?php
// api/relatorio.php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X'; // <--- CONFIRA SUA SENHA AQUI
$dsn  = "mysql:host=$host;dbname=$db;charset=utf8mb4";

try {
    $pdo = new PDO($dsn, $user, $pass);

    // Recebe as datas do filtro (ou usa a data de hoje como padrão)
    $inicio = $_GET['inicio'] ?? date('Y-m-d');
    $fim    = $_GET['fim'] ?? date('Y-m-d');

    // Adiciona as horas para pegar o dia inteiro (00:00 até 23:59)
    $inicio_full = $inicio . " 00:00:00";
    $fim_full    = $fim . " 23:59:59";

    // SQL: Busca pedidos CONCLUÍDOS dentro do prazo
    $sql = "SELECT id, cliente_nome, total, data_pedido, entregador_id 
            FROM pedidos 
            WHERE status = 'concluido' 
            AND data_pedido BETWEEN :inicio AND :fim 
            ORDER BY data_pedido DESC";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([':inicio' => $inicio_full, ':fim' => $fim_full]);
    $pedidos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($pedidos);

} catch (Exception $e) {
    echo json_encode([]);
}
?>