<?php
// api/get_pedidos.php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
ini_set('display_errors', 0); // Evita sujar o JSON

// --- CONFIGURAÇÃO ---
$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X'; // <--- CONFIRA SUA SENHA AQUI
$dsn  = "mysql:host=$host;dbname=$db;charset=utf8mb4";

try {
    $pdo = new PDO($dsn, $user, $pass);

    // Selecionamos explicitamente o entregador_id
    $sql = "SELECT id, cliente_nome, cliente_telefone, endereco_escrito, lat, lng, total, status, data_pedido, entregador_id 
            FROM pedidos 
            WHERE status IN ('pendente', 'aceito', 'preparando', 'saiu_entrega') 
            ORDER BY id DESC";
    
    $stmt = $pdo->query($sql);
    $pedidos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Pega os itens
    foreach($pedidos as &$p) {
        // Garante que se for nulo, vira 0 (importante para o Javascript não falhar)
        if (!$p['entregador_id']) { $p['entregador_id'] = 0; }

        $sql_itens = "SELECT i.*, p.nome as nome_produto, p.unidade 
                      FROM itens_pedido i 
                      LEFT JOIN produtos p ON i.produto_id = p.id 
                      WHERE i.pedido_id = :id";
        $stmt_itens = $pdo->prepare($sql_itens);
        $stmt_itens->execute([':id' => $p['id']]);
        $p['itens'] = $stmt_itens->fetchAll(PDO::FETCH_ASSOC);
    }

    echo json_encode($pedidos);

} catch (Exception $e) {
    echo json_encode(["erro" => true, "msg" => $e->getMessage()]);
}
?>