<?php
// api/diagnostico.php
header("Content-Type: text/html; charset=UTF-8");

// --- PREENCHA SEUS DADOS AQUI COM MUITA ATENÇÃO ---
$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X'; // <--- CONFIRA SUA SENHA AQUI
$dsn  = "mysql:host=$host;dbname=$db;charset=utf8mb4";
// ---------------------------------------------------

echo "<h2>🕵️‍♂️ Diagnóstico do Sistema de Entregadores</h2>";

try {
    // 1. TESTE DE CONEXÃO
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    echo "<p style='color:green'>✅ 1. Conexão com Banco de Dados: SUCESSO!</p>";

    // 2. TESTE DA COLUNA
    $stmt = $pdo->query("SHOW COLUMNS FROM pedidos LIKE 'entregador_id'");
    $coluna = $stmt->fetch();

    if ($coluna) {
        echo "<p style='color:green'>✅ 2. Coluna 'entregador_id': ELA EXISTE!</p>";
    } else {
        echo "<p style='color:red'>❌ 2. Coluna 'entregador_id': NÃO EXISTE.</p>";
        echo "<p><strong>Tentando corrigir agora...</strong></p>";
        try {
            $pdo->exec("ALTER TABLE pedidos ADD COLUMN entregador_id INT DEFAULT 0");
            echo "<p style='color:blue'>🛠️ Coluna criada automaticamente. Tente usar o sistema agora.</p>";
        } catch (Exception $e2) {
            echo "<p style='color:red'>Erro ao criar coluna: " . $e2->getMessage() . "</p>";
        }
    }

    // 3. TESTE DE DADOS RECENTES
    $stmt = $pdo->query("SELECT id, status, entregador_id FROM pedidos ORDER BY id DESC LIMIT 1");
    $pedido = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($pedido) {
        echo "<hr><h3>Último Pedido no Banco (#{$pedido['id']}):</h3>";
        echo "Status: <strong>{$pedido['status']}</strong><br>";
        echo "ID Entregador Salvo: <strong>" . ($pedido['entregador_id'] ?? 'NULO') . "</strong>";
        
        if ($pedido['entregador_id'] > 0) {
            echo "<p style='color:green'>✅ O sistema ESTÁ salvando o entregador.</p>";
        } else {
            echo "<p style='color:orange'>⚠️ O entregador está Zero ou Nulo. O painel Admin não enviou o dado corretamente.</p>";
        }
    } else {
        echo "<p>Nenhum pedido encontrado para testar.</p>";
    }

} catch (PDOException $e) {
    echo "<h2 style='color:red'>❌ ERRO FATAL DE CONEXÃO</h2>";
    echo "Verifique o usuário e senha no arquivo diagnostico.php<br>";
    echo "Erro técnico: " . $e->getMessage();
}
?>