<?php
// api/cardapio.php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *"); // Permite que seu App/React acesse

// Configuração do Banco
$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X'; 
$dsn  = "mysql:host=$host;dbname=$db;charset=utf8mb4";

try {
    $pdo = new PDO($dsn, $user, $pass, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

    // 1. Buscamos todas as categorias que têm produtos ativos
    // Usamos LEFT JOIN para trazer os produtos junto com dados da categoria
    $sql = "SELECT 
                c.id as cat_id, 
                c.nome as cat_nome, 
                c.icone as cat_icone,
                p.id as prod_id, 
                p.nome as prod_nome, 
                p.descricao, 
                p.preco, 
                p.unidade 
            FROM categorias c
            JOIN produtos p ON p.categoria_id = c.id
            WHERE p.disponivel = 1
            ORDER BY c.id ASC, p.nome ASC";

    $stmt = $pdo->query($sql);
    $dados_brutos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 2. Agrupamento (Transformando lista plana em hierarquia)
    $cardapio = [];

    foreach ($dados_brutos as $linha) {
        $cat_id = $linha['cat_id'];

        // Se a categoria ainda não existe no array final, cria ela
        if (!isset($cardapio[$cat_id])) {
            $cardapio[$cat_id] = [
                'id' => $cat_id,
                'titulo' => $linha['cat_nome'],
                'icone' => $linha['cat_icone'], // Ex: 'assets/icon-meat.png'
                'produtos' => []
            ];
        }

        // Adiciona o produto dentro da categoria correspondente
        $cardapio[$cat_id]['produtos'][] = [
            'id' => $linha['prod_id'],
            'nome' => $linha['prod_nome'],
            'descricao' => $linha['descricao'],
            'preco' => (float) $linha['preco'],
            'unidade' => $linha['unidade'] // Aqui está a chave: 'KG' ou 'UN'
        ];
    }

    // 3. Remove as chaves de ID para retornar um array limpo (JSON Array)
    echo json_encode(array_values($cardapio));

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["erro" => "Erro ao carregar cardápio: " . $e->getMessage()]);
}
?>