<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatórios Financeiros</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { font-family: 'Segoe UI', sans-serif; background: #f0f2f5; margin: 0; padding: 20px; color: #333; }
        
        /* HEADER E FILTROS */
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .btn-voltar { text-decoration: none; color: #666; font-weight: bold; display: flex; align-items: center; gap: 5px; }
        
        .filtros { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); display: flex; gap: 15px; align-items: end; flex-wrap: wrap;}
        .input-group { display: flex; flex-direction: column; }
        .input-group label { font-size: 0.8rem; color: #666; margin-bottom: 5px; }
        .input-group input { padding: 10px; border: 1px solid #ddd; border-radius: 5px; }
        
        .btn-buscar { background: #3498db; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; font-weight: bold; height: 38px;}
        .btn-print { background: #2c3e50; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; height: 38px; margin-left: auto;}

        /* CARDS DE RESUMO */
        .resumo-grid { display: flex; gap: 20px; margin: 20px 0; }
        .card { flex: 1; background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); border-left: 5px solid #ccc; }
        .card h3 { margin: 0; font-size: 0.9rem; color: #777; text-transform: uppercase; }
        .card strong { display: block; font-size: 1.8rem; color: #222; margin-top: 5px; }
        
        .border-green { border-left-color: #2ecc71; }
        .border-blue { border-left-color: #3498db; }
        .border-orange { border-left-color: #f39c12; }

        /* TABELA */
        table { width: 100%; border-collapse: collapse; background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        th, td { padding: 12px 15px; text-align: left; border-bottom: 1px solid #eee; }
        th { background: #f8f9fa; color: #555; font-weight: 600; }
        tr:hover { background: #fafafa; }
        .total-row { font-weight: bold; background: #eee; }

        /* IMPRESSÃO */
        @media print {
            body { background: white; padding: 0; }
            .header, .filtros, .btn-print { display: none; }
            .card { border: 1px solid #ccc; box-shadow: none; }
        }
    </style>
</head>
<body>

    <div class="header">
        <a href="index.php" class="btn-voltar"><i class="fas fa-arrow-left"></i> Voltar para Pedidos</a>
        <h2>Relatório de Vendas</h2>
    </div>

    <div class="filtros">
        <div class="input-group">
            <label>Data Início</label>
            <input type="date" id="data-inicio">
        </div>
        <div class="input-group">
            <label>Data Fim</label>
            <input type="date" id="data-fim">
        </div>
        <button class="btn-buscar" onclick="buscarRelatorio()"><i class="fas fa-search"></i> Filtrar</button>
        <button class="btn-print" onclick="window.print()"><i class="fas fa-print"></i> Imprimir</button>
    </div>

    <div class="resumo-grid">
        <div class="card border-green">
            <h3>Faturamento Total</h3>
            <strong id="res-faturamento">R$ 0,00</strong>
        </div>
        <div class="card border-blue">
            <h3>Total de Pedidos</h3>
            <strong id="res-qtd">0</strong>
        </div>
        <div class="card border-orange">
            <h3>Ticket Médio</h3>
            <strong id="res-ticket">R$ 0,00</strong>
        </div>
    </div>

    <table>
        <thead>
            <tr>
                <th>#ID</th>
                <th>Data/Hora</th>
                <th>Cliente</th>
                <th>Entregador</th>
                <th style="text-align:right">Valor (R$)</th>
            </tr>
        </thead>
        <tbody id="tabela-corpo">
            <tr><td colspan="5" style="text-align:center">Selecione as datas e clique em Filtrar</td></tr>
        </tbody>
    </table>

    <script>
        // Define data de hoje nos inputs ao abrir
        const hoje = new Date().toISOString().split('T')[0];
        document.getElementById('data-inicio').value = hoje;
        document.getElementById('data-fim').value = hoje;

        function buscarRelatorio() {
            const inicio = document.getElementById('data-inicio').value;
            const fim = document.getElementById('data-fim').value;
            const tbody = document.getElementById('tabela-corpo');

            tbody.innerHTML = '<tr><td colspan="5" style="text-align:center">Carregando...</td></tr>';

            fetch(`../api/relatorio.php?inicio=${inicio}&fim=${fim}`)
                .then(res => res.json())
                .then(pedidos => {
                    if(pedidos.length === 0) {
                        tbody.innerHTML = '<tr><td colspan="5" style="text-align:center">Nenhum pedido concluído neste período.</td></tr>';
                        zerarResumo();
                        return;
                    }

                    tbody.innerHTML = '';
                    let totalFaturamento = 0;

                    pedidos.forEach(p => {
                        let valor = parseFloat(p.total);
                        totalFaturamento += valor;

                        let dataFormatada = new Date(p.data_pedido).toLocaleString('pt-BR');
                        let entregador = p.entregador_id > 0 ? "Moto " + p.entregador_id : "Não inf.";

                        let html = `
                            <tr>
                                <td>${p.id}</td>
                                <td>${dataFormatada}</td>
                                <td>${p.cliente_nome}</td>
                                <td>${entregador}</td>
                                <td style="text-align:right">R$ ${valor.toFixed(2).replace('.', ',')}</td>
                            </tr>
                        `;
                        tbody.innerHTML += html;
                    });

                    atualizarCards(totalFaturamento, pedidos.length);
                })
                .catch(err => {
                    console.error(err);
                    tbody.innerHTML = '<tr><td colspan="5" style="text-align:center; color:red">Erro ao buscar dados.</td></tr>';
                });
        }

        function atualizarCards(total, qtd) {
            document.getElementById('res-faturamento').innerText = total.toLocaleString('pt-BR', {style: 'currency', currency: 'BRL'});
            document.getElementById('res-qtd').innerText = qtd;
            
            let ticket = qtd > 0 ? (total / qtd) : 0;
            document.getElementById('res-ticket').innerText = ticket.toLocaleString('pt-BR', {style: 'currency', currency: 'BRL'});
        }

        function zerarResumo() {
            document.getElementById('res-faturamento').innerText = "R$ 0,00";
            document.getElementById('res-qtd').innerText = "0";
            document.getElementById('res-ticket').innerText = "R$ 0,00";
        }

        // Busca automaticamente ao abrir
        buscarRelatorio();
    </script>
</body>
</html>