<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel Delivery - Gestão Completa</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        body { font-family: 'Segoe UI', sans-serif; background: #eaeff2; margin: 0; padding: 20px; }
        
        .dashboard { display: flex; gap: 20px; margin-bottom: 30px; flex-wrap: wrap; }
        .dash-card {
            background: white; padding: 20px; border-radius: 10px; flex: 1; min-width: 200px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.05); display: flex; align-items: center; justify-content: space-between;
        }
        
        .dash-info strong { font-size: 1.8rem; color: #2c3e50; }
        .card-orange { border-bottom: 4px solid #e67e22; }
        .card-blue { border-bottom: 4px solid #3498db; }
        .card-green { border-bottom: 4px solid #2ecc71; }

        .titulo-secao { color: #2c3e50; margin-bottom: 20px; border-bottom: 2px solid #ddd; padding-bottom: 10px; }
        .grid-pedidos { display: grid; grid-template-columns: repeat(auto-fill, minmax(320px, 1fr)); gap: 20px; }
        
        .pedido-card {
            background: white; border-radius: 8px; overflow: hidden;
            box-shadow: 0 2px 5px rgba(0,0,0,0.05); border-left: 6px solid #ccc;
        }
        .status-pendente { border-left-color: #e74c3c; }   
        .status-preparando { border-left-color: #f1c40f; } 
        .status-saiu_entrega { border-left-color: #3498db; } 

        .card-header, .card-body, .card-footer { padding: 15px; }
        .card-header { background: #f8f9fa; border-bottom: 1px solid #eee; display: flex; justify-content: space-between; }
        .card-footer { background: #f8f9fa; border-top: 1px solid #eee; display: flex; flex-direction: column; gap: 10px; }

        .itens-lista { list-style: none; padding: 0; margin: 0; }
        .itens-lista li { padding: 8px 0; border-bottom: 1px dashed #eee; display: flex; justify-content: space-between; font-size: 0.95rem; }

        .btn { border: none; padding: 10px; border-radius: 5px; cursor: pointer; color: white; font-weight: bold; width: 100%; display: flex; justify-content: center; align-items: center; gap: 5px;}
        .btn-aceitar { background: #f1c40f; color: #333; }
        .btn-entrega { background: #3498db; }
        .btn-concluir { background: #2ecc71; }
        .btn-print { background: #34495e; width: 100%; margin-bottom: 5px;}

        /* Select de Entregador */
        .select-moto { width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 5px; margin-bottom: 5px; }

        #area-impressao { display: none; }
        @media print {
            body * { visibility: hidden; }
            #area-impressao, #area-impressao * { visibility: visible; }
            #area-impressao { display: block; position: absolute; left: 0; top: 0; width: 80mm; font-family: monospace; font-size: 12px; color:black;}
        }
    </style>
</head>
<body>
<div style="margin-bottom: 20px; text-align: right;">
    <a href="relatorios.php" style="background: #2c3e50; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; font-weight: bold;">
        <i class="fas fa-chart-line"></i> Ver Relatórios
    </a>
</div>
    <div class="dashboard">
        <div class="dash-card card-orange">
            <div class="dash-info"><h3>Aguardando</h3><strong id="dash-pendentes">0</strong></div>
        </div>
        <div class="dash-card card-blue">
            <div class="dash-info"><h3>Em Entrega</h3><strong id="dash-entrega">0</strong></div>
        </div>
        <div class="dash-card card-green">
            <div class="dash-info"><h3>Faturamento</h3><strong id="dash-faturamento">R$ 0,00</strong></div>
        </div>
    </div>

    <h2 class="titulo-secao">Pedidos em Andamento</h2>
    <div id="mural-pedidos" class="grid-pedidos"><p>Carregando...</p></div>
    <div id="area-impressao"></div>
    <audio id="som-campainha" src="campainha.mp3"></audio>

    <script>
        let ultimosPedidosIds = [];

        function iniciarSistema() {
            carregarPedidos();      
            carregarEstatisticas(); 
        }

        function carregarPedidos() {
            fetch('../api/get_pedidos.php')
                .then(res => res.json())
                .then(pedidos => renderizarPedidos(pedidos))
                .catch(err => console.error(err));
        }

        function carregarEstatisticas() {
            fetch('../api/stats.php').then(res => res.json()).then(dados => {
                if(dados.erro) return;
                document.getElementById('dash-pendentes').innerText = dados.pendentes || 0;
                document.getElementById('dash-entrega').innerText = dados.em_andamento || 0;
                let valor = parseFloat(dados.faturamento_hoje || 0);
                document.getElementById('dash-faturamento').innerText = valor.toLocaleString('pt-BR', {style: 'currency', currency: 'BRL'});
            });
        }

        function renderizarPedidos(pedidos) {
            const mural = document.getElementById('mural-pedidos');
            if(pedidos.length === 0) { mural.innerHTML = 'Sem pedidos.'; return; }

            let novosIds = pedidos.map(p => p.id);
            const diferenca = novosIds.filter(x => !ultimosPedidosIds.includes(x));
            if (diferenca.length > 0 && ultimosPedidosIds.length > 0) document.getElementById('som-campainha').play().catch(e=>{});
            ultimosPedidosIds = novosIds;

            mural.innerHTML = '';

            pedidos.forEach(p => {
                let htmlItens = '';
                let jsonItensSeguro = JSON.stringify(p.itens).replace(/"/g, "&quot;");

                p.itens.forEach(item => {
                    let qtd = item.unidade === 'KG' ? parseFloat(item.quantidade).toFixed(3) + 'kg' : parseInt(item.quantidade) + 'un';
                    htmlItens += `<li><span>${item.nome_produto}</span><span>${qtd}</span></li>`;
                });

                // LÓGICA DO BOTÃO DE ENTREGADOR
                let areaAcao = '';
                
                if(p.status === 'pendente') {
                    areaAcao = `<button class="btn btn-aceitar" onclick="mudarStatus(${p.id}, 'preparando')">🔥 Preparar</button>`;
                } 
                else if(p.status === 'preparando') {
                    // AQUI ESTÁ A MUDANÇA: SELETOR DE MOTOBOY
                    areaAcao = `
                        <select id="moto-select-${p.id}" class="select-moto">
                            <option value="1">Entregador 1</option>
                            <option value="2">Entregador 2</option>
                            <option value="3">Entregador 3</option>
                            <option value="4">Entregador 4</option>
                        </select>
                        <button class="btn btn-entrega" onclick="enviarParaMoto(${p.id})">🛵 Enviar</button>
                    `;
                } 
                else if(p.status === 'saiu_entrega') {
                    // Mostra quem está levando
                    let motoId = p.entregador_id || '?';
                    areaAcao = `
                        <div style="text-align:center; color:#3498db; margin-bottom:5px;">Com Entregador ${motoId}</div>
                        <button class="btn btn-concluir" onclick="mudarStatus(${p.id}, 'concluido')">✅ Concluir</button>
                    `;
                }

                const card = `
                    <div class="pedido-card status-${p.status}">
                        <div class="card-header"><strong>#${p.id} ${p.cliente_nome}</strong><small>${p.data_pedido.substring(11,16)}</small></div>
                        <div class="card-body">
                            <p>${p.endereco_escrito}</p>
                            <ul class="itens-lista">${htmlItens}</ul>
                            <h4 style="text-align:right">R$ ${p.total}</h4>
                        </div>
                        <div class="card-footer">
                            <button class="btn btn-print" onclick="imprimirCupom('${p.id}', '${p.cliente_nome}', '', '${p.endereco_escrito}', '${p.total}', ${jsonItensSeguro})"><i class="fas fa-print"></i> Imprimir</button>
                            ${areaAcao}
                        </div>
                    </div>
                `;
                mural.innerHTML += card;
            });
        }

        // Função Especial para capturar o ID do Moto
        function enviarParaMoto(idPedido) {
            const select = document.getElementById(`moto-select-${idPedido}`);
            const motoId = select.value;
            
            if(!confirm(`Enviar pedido #${idPedido} para o Entregador ${motoId}?`)) return;

            fetch('../api/atualizar_status.php', {
                method: 'POST',
                body: JSON.stringify({ id: idPedido, status: 'saiu_entrega', entregador_id: motoId })
            }).then(() => iniciarSistema());
        }

        function mudarStatus(id, novoStatus) {
            if(!confirm("Confirmar mudança?")) return;
            fetch('../api/atualizar_status.php', {
                method: 'POST',
                body: JSON.stringify({ id: id, status: novoStatus })
            }).then(() => iniciarSistema());
        }

        function imprimirCupom(id, nome, tel, end, total, itens) {
            // (Mesma função de impressão de antes, omitida para economizar espaço)
             let itensHtml = '';
            itens.forEach(i => {
                let qtd = i.unidade === 'KG' ? parseFloat(i.quantidade).toFixed(3) + 'kg' : parseInt(i.quantidade) + 'un';
                itensHtml += `<div class="cupom-item"><span>${qtd} ${i.nome_produto}</span></div>`;
            });
            const cupom = `<div class="cupom-header">PEDIDO #${id}<br>${end}<br></div><hr>${itensHtml}<hr><div class="cupom-total">TOTAL: R$ ${total}</div>`;
            document.getElementById('area-impressao').innerHTML = cupom;
            window.print();
        }

        setInterval(iniciarSistema, 10000);
        iniciarSistema();
    </script>
</body>
</html>