<?php
// api/get_pedidos.php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X'; // VERIFIQUE SE A SENHA ESTÁ CERTA

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Busca pedidos pendentes, preparando ou saiu_entrega (ignora concluidos do dia anterior)
    // Faz o JOIN para pegar o nome do entregador se houver
    $sql = "SELECT p.*, e.nome as nome_entregador 
            FROM pedidos p 
            LEFT JOIN entregadores e ON p.entregador_id = e.id
            WHERE p.status IN ('pendente', 'preparando', 'saiu_entrega') 
            ORDER BY p.id DESC";
            
    $stmt = $pdo->query($sql);
    $pedidos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Busca os itens de cada pedido
    foreach($pedidos as &$p) {
        $stmtItens = $pdo->prepare("SELECT i.*, pr.nome as nome_produto, pr.unidade 
                                    FROM itens_pedido i 
                                    JOIN produtos pr ON i.produto_id = pr.id 
                                    WHERE i.pedido_id = ?");
        $stmtItens->execute([$p['id']]);
        $p['itens'] = $stmtItens->fetchAll(PDO::FETCH_ASSOC);
    }

    echo json_encode($pedidos);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["erro" => "Erro Banco: " . $e->getMessage()]);
}
?>