<?php
// api/fazer_pedido.php
require_once 'conexao.php';

try {
    // Recebe os dados do App (JSON)
    $json = file_get_contents("php://input");
    $dados = json_decode($json, true);

    if (empty($dados['itens']) || empty($dados['total'])) {
        throw new Exception("Carrinho vazio ou inválido.");
    }

    // --- DADOS DO CLIENTE ---
    $nome = $dados['cliente_nome'];
    $tel  = $dados['cliente_telefone'];
    $end  = $dados['endereco_escrito'];
    $lat  = $dados['lat'];
    $lng  = $dados['lng'];
    $total = $dados['total'];
    
    // --- NOVOS CAMPOS ---
    $obs   = isset($dados['observacao']) ? $dados['observacao'] : '';
    $frete = isset($dados['frete']) ? $dados['frete'] : 0.00;

    $pdo->beginTransaction();

    // 1. Cria o Pedido (Com Frete e Obs)
    $sql = "INSERT INTO pedidos (cliente_nome, cliente_telefone, endereco_escrito, lat, lng, total, frete, observacao, data_pedido, status) 
            VALUES (:nome, :tel, :end, :lat, :lng, :total, :frete, :obs, NOW(), 'pendente')";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':nome' => $nome,
        ':tel' => $tel,
        ':end' => $end,
        ':lat' => $lat,
        ':lng' => $lng,
        ':total' => $total,
        ':frete' => $frete,
        ':obs' => $obs
    ]);
    
    $pedidoId = $pdo->lastInsertId();

    // 2. Insere os Itens
    foreach ($dados['itens'] as $item) {
        $sqlItem = "INSERT INTO itens_pedido (pedido_id, produto_id, quantidade, observacao, preco_momento) 
                    VALUES (:pid, :prod, :qtd, :obs_item, :preco)";
        $stmtItem = $pdo->prepare($sqlItem);
        $stmtItem->execute([
            ':pid' => $pedidoId,
            ':prod' => $item['id'],
            ':qtd' => $item['quantidade'],
            ':obs_item' => isset($item['observacao']) ? $item['observacao'] : '', // Obs individual do item
            ':preco' => $item['preco']
        ]);
    }

    $pdo->commit();
    echo json_encode(["sucesso" => true, "id_pedido" => $pedidoId]);

} catch (Exception $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    echo json_encode(["sucesso" => false, "erro" => $e->getMessage()]);
}
?>