<?php
session_start();
if(!isset($_SESSION['admin_logado']) || $_SESSION['admin_logado'] !== true){
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel Delivery - Gestão</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        /* --- ESTILOS --- */
        body { font-family: 'Segoe UI', sans-serif; background: #eaeff2; margin: 0; padding: 15px; }
        
        .top-nav { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; background: white; padding: 15px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); flex-wrap: wrap; gap: 10px; }
        .top-nav h2 { margin: 0; color: #2c3e50; font-size: 1.4rem; }
        .nav-buttons { display: flex; gap: 10px; flex-wrap: wrap; }
        
        .btn-nav { text-decoration: none; padding: 10px 15px; border-radius: 5px; font-weight: bold; font-size: 0.9rem; color: white; display: flex; align-items: center; gap: 8px; transition: opacity 0.2s; white-space: nowrap; }
        .bg-prod { background: #27ae60; } .bg-moto { background: #e67e22; } .bg-rela { background: #2c3e50; } .bg-menu { background: #8e44ad; } 
        
        .btn-som { border: none; padding: 10px 15px; border-radius: 20px; font-weight: bold; font-size: 0.9rem; cursor: pointer; display: flex; align-items: center; gap: 8px; transition: all 0.3s; }
        .som-off { background: #e74c3c; color: white; animation: pulse-red 2s infinite; } .som-on { background: #2ecc71; color: white; }
        @keyframes pulse-red { 0% { box-shadow: 0 0 0 0 rgba(231, 76, 60, 0.7); } 70% { box-shadow: 0 0 0 10px rgba(231, 76, 60, 0); } 100% { box-shadow: 0 0 0 0 rgba(231, 76, 60, 0); } }

        .dashboard { display: flex; gap: 15px; margin-bottom: 20px; flex-wrap: wrap; }
        .dash-card { background: white; padding: 20px; border-radius: 10px; flex: 1; min-width: 200px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); display: flex; align-items: center; justify-content: space-between; }
        .dash-info h3 { margin: 0; color: #7f8c8d; font-size: 0.8rem; text-transform: uppercase; } .dash-info strong { font-size: 1.8rem; color: #2c3e50; }
        .card-orange { border-bottom: 4px solid #e67e22; } .card-blue { border-bottom: 4px solid #3498db; } .card-green { border-bottom: 4px solid #2ecc71; }

        .grid-pedidos { display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 15px; }
        .pedido-card { background: white; border-radius: 8px; overflow: hidden; box-shadow: 0 2px 5px rgba(0,0,0,0.05); position: relative; border-left: 6px solid #ccc; transition: transform 0.2s; }
        .status-pendente { border-left-color: #e74c3c; } .status-preparando { border-left-color: #f1c40f; } .status-saiu_entrega { border-left-color: #3498db; } 

        .card-header { padding: 15px; background: #f8f9fa; border-bottom: 1px solid #eee; display: flex; justify-content: space-between; align-items: center; } .card-body { padding: 15px; } .card-footer { padding: 15px; background: #f8f9fa; border-top: 1px solid #eee; display: flex; flex-direction: column; gap: 8px; }
        .itens-lista { list-style: none; padding: 0; margin: 0; } .itens-lista li { padding: 8px 0; border-bottom: 1px dashed #eee; display: flex; justify-content: space-between; font-size: 0.95rem; } .obs { color: #e74c3c; font-size: 0.8rem; display: block; }
        .box-obs-pedido { background: #fff3cd; color: #856404; padding: 10px; border-radius: 5px; margin: 10px 0; font-size: 0.9rem; border: 1px solid #ffeeba; }

        .select-moto { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 5px; margin-bottom: 5px; font-size: 1rem; }
        .btn { border: none; padding: 12px; border-radius: 5px; cursor: pointer; color: white; font-weight: bold; width: 100%; display: flex; justify-content: center; align-items: center; gap: 8px; font-size: 1rem;}
        
        .btn-aceitar { background: #f1c40f; color: #333; } .btn-entrega { background: #3498db; } .btn-concluir { background: #2ecc71; } .btn-print { background: #34495e; margin-bottom: 5px; } .btn-cancelar { background: #c0392b; } .btn-cancelar:hover { background: #a93226; }
        .btn-mapa { background: white; color: #e74c3c; border: 1px solid #e74c3c; text-decoration: none; padding: 8px; display: block; text-align: center; margin-top: 15px; border-radius: 5px; font-weight: bold; } .btn-mapa:hover { background: #e74c3c; color: white; }
        
        .btn-zap-cliente { background: #25D366; color: white; text-decoration: none; margin-top: 5px; border-radius: 5px; padding: 10px; font-weight: bold; display: flex; align-items: center; justify-content: center; gap: 8px; }
        .btn-zap-cliente:hover { background: #128C7E; }

        #debug-box { display: none; width: 100%; background: #2d3436; color: #fab1a0; padding: 15px; margin-bottom: 20px; border-radius: 8px; font-family: monospace; font-size: 12px; white-space: pre-wrap; }
        #area-impressao { display: none; }
        @media print { body * { visibility: hidden; } #area-impressao, #area-impressao * { visibility: visible; } #area-impressao { display: block; position: absolute; left: 0; top: 0; width: 80mm; font-family: 'Courier New', monospace; font-size: 12px; color: black; } .cupom-linha { border-bottom: 1px dashed #000; margin: 5px 0; } .cupom-item { display: flex; justify-content: space-between; margin-bottom: 3px;} }
    </style>
</head>
<body>

    <div class="top-nav">
        <div style="display:flex; align-items:center; gap:15px;">
            <h2><i class="fas fa-store"></i> Gestão</h2>
            <button id="btn-som" class="btn-som som-off" onclick="ativarSom()"><i class="fas fa-volume-mute"></i> Ativar Som</button>
        </div>
        <div class="nav-buttons">
            <a href="../entrega/app.php" target="_blank" class="btn-nav bg-menu"><i class="fas fa-mobile-alt"></i> App Cliente</a>
            <a href="produtos.php" class="btn-nav bg-prod"><i class="fas fa-hamburger"></i> Produtos</a>
            <a href="entregadores.php" class="btn-nav bg-moto"><i class="fas fa-motorcycle"></i> Motos</a>
            <a href="relatorios.php" class="btn-nav bg-rela"><i class="fas fa-chart-line"></i> Relatório</a>
            <a href="logout.php" class="btn-nav" style="background:#c0392b;"><i class="fas fa-sign-out-alt"></i> Sair</a>
        </div>
    </div>

    <div id="debug-box"></div>

    <div class="dashboard">
        <div class="dash-card card-orange"><div class="dash-info"><h3>Aguardando</h3><strong id="dash-pendentes">0</strong></div><i class="fas fa-clock" style="font-size:2rem; opacity:0.2; color:#e67e22"></i></div>
        <div class="dash-card card-blue"><div class="dash-info"><h3>Em Entrega</h3><strong id="dash-entrega">0</strong></div><i class="fas fa-motorcycle" style="font-size:2rem; opacity:0.2; color:#3498db"></i></div>
        <div class="dash-card card-green"><div class="dash-info"><h3>Faturamento</h3><strong id="dash-faturamento">R$ 0,00</strong></div><i class="fas fa-cash-register" style="font-size:2rem; opacity:0.2; color:#2ecc71"></i></div>
    </div>

    <div id="mural-pedidos" class="grid-pedidos">
        <div style="grid-column: 1/-1; text-align:center; padding: 20px;">
            <i class="fas fa-circle-notch fa-spin fa-2x" style="color:#ccc;"></i>
            <p style="color:#666;">Conectando ao sistema...</p>
        </div>
    </div>

    <div id="area-impressao"></div>
    <audio id="som-campainha" src="campainha.mp3" preload="auto"></audio>

    <script>
        let ultimosPedidosIds = [];
        let listaEntregadores = []; 
        let audioHabilitado = false;

        document.addEventListener("DOMContentLoaded", () => {
            carregarEntregadores(); 
            iniciarSistema();       
        });

        function ativarSom() {
            const btn = document.getElementById('btn-som');
            const audio = document.getElementById('som-campainha');
            audio.play().then(() => {
                audio.pause(); audio.currentTime = 0; audioHabilitado = true;
                btn.className = "btn-som som-on"; btn.innerHTML = '<i class="fas fa-volume-up"></i> Som Ativado';
            }).catch(erro => { alert("Clique novamente para ativar o som."); });
        }
        function tocarCampainha() { if(audioHabilitado) { const audio = document.getElementById('som-campainha'); audio.currentTime = 0; audio.play().catch(e => {}); } }

        function carregarEntregadores() {
            fetch('../api/get_entregadores.php').then(r => r.json()).then(d => listaEntregadores = d).catch(e => console.log(e));
        }

        function iniciarSistema() {
            carregarPedidos();      
            carregarEstatisticas(); 
        }
        setInterval(iniciarSistema, 5000);

        function carregarPedidos() {
            fetch('../api/get_pedidos.php?v=' + Math.random())
                .then(async response => {
                    const text = await response.text();
                    if (!response.ok) throw new Error("Erro HTTP: " + text);
                    try { return JSON.parse(text); } catch (e) { throw new Error("Erro ao ler dados do servidor. API inválida."); }
                })
                .then(pedidos => {
                    document.getElementById('debug-box').style.display = 'none';
                    renderizarPedidos(pedidos);
                })
                .catch(err => {
                    const debug = document.getElementById('debug-box');
                    debug.style.display = 'block';
                    debug.innerHTML = '<strong>⚠️ ERRO NO SISTEMA:</strong><br>' + err.message;
                });
        }

        function carregarEstatisticas() {
            fetch('../api/stats.php').then(r => r.json()).then(d => {
                if(d.erro) return;
                document.getElementById('dash-pendentes').innerText = d.pendentes || 0;
                document.getElementById('dash-entrega').innerText = d.em_andamento || 0;
                document.getElementById('dash-faturamento').innerText = parseFloat(d.faturamento_hoje || 0).toLocaleString('pt-BR', {style: 'currency', currency: 'BRL'});
            }).catch(e=>{});
        }

        function renderizarPedidos(pedidos) {
            const mural = document.getElementById('mural-pedidos');
            if(pedidos.length === 0) {
                mural.innerHTML = '<div style="text-align:center; color:#999; grid-column: 1 / -1; margin-top:20px;">Sem pedidos pendentes.</div>';
                return;
            }

            let novosIds = pedidos.map(p => p.id);
            const temNovidade = novosIds.some(x => !ultimosPedidosIds.includes(x));
            if (temNovidade && ultimosPedidosIds.length > 0) { tocarCampainha(); }
            ultimosPedidosIds = novosIds;

            mural.innerHTML = '';

            pedidos.forEach(p => {
                let htmlItens = '';
                let jsonItensSeguro = "[]";
                try { jsonItensSeguro = JSON.stringify(p.itens).replace(/"/g, ""); } catch(e) {}

                if(p.itens && p.itens.length > 0) {
                    p.itens.forEach(item => {
                        let qtd = item.unidade === 'KG' ? parseFloat(item.quantidade).toFixed(3) + 'kg' : parseInt(item.quantidade) + 'un';
                        let subtotal = (item.preco_momento * item.quantidade).toFixed(2);
                        htmlItens += '<li>' +
                            '<div><strong>' + item.nome_produto + '</strong><br><small>' + qtd + '</small> ' + (item.observacao ? '<span class="obs">('+item.observacao+')</span>' : '') + '</div>' +
                            '<div>R$ ' + subtotal + '</div>' +
                        '</li>';
                    });
                }

                let htmlObs = p.observacao ? '<div class="box-obs-pedido"><i class="fas fa-exclamation-circle"></i> <strong>Obs:</strong> ' + p.observacao + '</div>' : '';
                let frete = parseFloat(p.frete || 0);
                let freteHtml = frete > 0 ? '<div style="font-size:0.9rem; color:#7f8c8d; text-align:right;">Frete: R$ ' + frete.toFixed(2).replace('.', ',') + '</div>' : '';

                // --- LÓGICA DO WHATSAPP DO CLIENTE ---
                let numLimpo = p.cliente_telefone.replace(/[^0-9]/g, '');
                let textoZap = "";
                let botaoZap = "";

                if(numLimpo.length >= 10) {
                    if(p.status === 'pendente') textoZap = "Olá, confirmamos o recebimento do seu pedido!";
                    if(p.status === 'preparando') textoZap = "Seu pedido já está sendo preparado!";
                    if(p.status === 'saiu_entrega') textoZap = "Seu pedido saiu para entrega!";
                    
                    let link = "https://wa.me/55" + numLimpo + "?text=" + encodeURIComponent(textoZap);
                    
                    botaoZap = '<a href="' + link + '" target="_blank" class="btn-zap-cliente">' +
                                    '<i class="fab fa-whatsapp"></i> Avisar no WhatsApp' +
                                '</a>';
                }

                let areaAcao = '';
                if(p.status === 'pendente') {
                    areaAcao = '<button class="btn btn-aceitar" onclick="mudarStatus(' + p.id + ', \'preparando\')"><i class="fas fa-fire"></i> Preparar</button>' +
                               '<button class="btn btn-cancelar" onclick="mudarStatus(' + p.id + ', \'cancelado\')"><i class="fas fa-times-circle"></i> Cancelar</button>';
                } else if(p.status === 'preparando') {
                    let opcoes = listaEntregadores.map(m => '<option value="' + m.id + '">' + m.nome + '</option>').join('');
                    if(listaEntregadores.length === 0) opcoes = '<option value="">Cadastre Motos</option>';
                    areaAcao = '<select id="moto-select-' + p.id + '" class="select-moto">' + opcoes + '</select>' +
                               '<button class="btn btn-entrega" onclick="enviarParaMoto(' + p.id + ')"><i class="fas fa-motorcycle"></i> Enviar</button>';
                } else if(p.status === 'saiu_entrega') {
                    let entregador = listaEntregadores.find(m => m.id == p.entregador_id);
                    let nomeMoto = entregador ? entregador.nome : 'Moto '+p.entregador_id;
                    areaAcao = '<div style="text-align:center; color:#3498db; margin-bottom:10px;"><strong><i class="fas fa-helmet-safety"></i> ' + nomeMoto + '</strong></div>' +
                               '<button class="btn btn-concluir" onclick="mudarStatus(' + p.id + ', \'concluido\')"><i class="fas fa-check"></i> Concluir</button>';
                }

                // LINK DO MAPA SEGURO (CONCATENAÇÃO)
                let linkMapa = 'http://googleusercontent.com/maps.google.com/?q=' + encodeURIComponent(p.endereco_escrito);
                if(parseFloat(p.lat) !== 0 && parseFloat(p.lng) !== 0) {
                    linkMapa = 'http://googleusercontent.com/maps.google.com/?q=' + p.lat + ',' + p.lng;
                }

                const card = `
                    <div class="pedido-card status-${p.status}">
                        <div class="card-header">
                            <div><strong>#${p.id} ${p.cliente_nome.split(' ')[0]}</strong></div>
                            <small>${p.data_pedido.substring(11,16)}</small>
                        </div>
                        <div class="card-body">
                            <p style="margin-top:0; font-size:0.9rem"><i class="fas fa-map-marker-alt"></i> ${p.endereco_escrito}</p>
                            <a href="${linkMapa}" target="_blank" class="btn-mapa"><i class="fas fa-map-marked-alt"></i> Abrir Mapa</a>
                            <hr style="border:0; border-top:1px dashed #eee; margin:10px 0;">
                            ${htmlObs}
                            <ul class="itens-lista">${htmlItens}</ul>
                            <div style="margin-top:15px; border-top: 1px solid #eee; padding-top:10px;">
                                ${freteHtml}
                                <div style="text-align:right; font-size:1.3rem; font-weight:bold; color:#2c3e50">Total: R$ ${parseFloat(p.total).toFixed(2).replace('.', ',')}</div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <button class="btn btn-print" onclick="imprimirCupom('${p.id}', '${p.cliente_nome}', '${p.cliente_telefone}', '${p.endereco_escrito}', '${p.total}', '${p.frete}', '${p.observacao ? p.observacao.replace(/'/g, '') : ''}', ${jsonItensSeguro})"><i class="fas fa-print"></i> Imprimir</button>
                            ${areaAcao}
                            ${botaoZap}
                        </div>
                    </div>
                `;
                mural.innerHTML += card;
            });
        }

        function enviarParaMoto(id) {
            const select = document.getElementById(`moto-select-${id}`);
            if(!select || !select.value) { alert("Selecione um entregador!"); return; }
            if(!confirm(`Enviar pedido #${id}?`)) return;
            fetch('../api/atualizar_status.php', { method: 'POST', body: JSON.stringify({ id: id, status: 'saiu_entrega', entregador_id: select.value }) }).then(() => iniciarSistema());
        }

        function mudarStatus(id, st) {
            let msg = "Confirmar ação?";
            if(st === 'cancelado') msg = "Tem certeza que deseja CANCELAR este pedido?";
            if(st === 'concluido') msg = "Finalizar pedido?";
            if(!confirm(msg)) return;
            fetch('../api/atualizar_status.php', { method: 'POST', body: JSON.stringify({ id: id, status: st }) }).then(() => iniciarSistema());
        }

        function imprimirCupom(id, nome, tel, end, total, frete, obs, itens) {
            let itensHtml = '';
            itens.forEach(i => {
                let qtd = i.unidade === 'KG' ? parseFloat(i.quantidade).toFixed(3) + 'kg' : parseInt(i.quantidade) + 'un';
                let val = (i.preco_momento * i.quantidade).toFixed(2);
                itensHtml += `<div class="cupom-item"><span>${qtd} ${i.nome_produto}</span><span>${val}</span></div>`;
            });
            let htmlObs = obs ? `<div class="cupom-linha"></div><strong>OBS: ${obs}</strong>` : '';
            let htmlFrete = parseFloat(frete) > 0 ? `<div class="cupom-item"><span>Taxa Entrega</span><span>${parseFloat(frete).toFixed(2)}</span></div>` : '';
            const layout = `
                <div style="text-align:center; font-weight:bold; margin-bottom:10px;">DELIVERY<br>Pedido #${id}<br><small>${new Date().toLocaleString()}</small></div>
                <div class="cupom-linha"></div>
                <div><strong>CLIENTE:</strong><br>${nome}<br>${tel}<br><small>${end}</small></div>
                <div class="cupom-linha"></div>
                <strong>ITENS:</strong>${itensHtml}${htmlObs}
                <div class="cupom-linha"></div>${htmlFrete}
                <div style="text-align:right; font-size:16px; font-weight:bold; margin-top:10px;">TOTAL: R$ ${parseFloat(total).toFixed(2).replace('.', ',')}</div>
                <br>.
            `;
            document.getElementById('area-impressao').innerHTML = layout;
            window.print();
        }
    </script>
</body>
</html>