<?php
session_start();
if(!isset($_SESSION['admin_logado']) || $_SESSION['admin_logado'] !== true){
    header("Location: login.php");
    exit;
}

// CONEXÃO
$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro Conexão: " . $e->getMessage());
}

// --- AÇÕES ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // 1. NOVO ENTREGADOR
    if (isset($_POST['acao']) && $_POST['acao'] == 'novo') {
        $nome = trim($_POST['nome']);
        $tel  = trim($_POST['telefone']);
        if($nome) {
            $stmt = $pdo->prepare("INSERT INTO entregadores (nome, telefone) VALUES (?, ?)");
            $stmt->execute([$nome, $tel]);
        }
        header("Location: entregadores.php"); exit;
    }

    // 2. EDITAR ENTREGADOR (NOVO!)
    if (isset($_POST['acao']) && $_POST['acao'] == 'editar') {
        $id   = $_POST['id'];
        $nome = trim($_POST['nome']);
        $tel  = trim($_POST['telefone']);
        
        $stmt = $pdo->prepare("UPDATE entregadores SET nome = ?, telefone = ? WHERE id = ?");
        $stmt->execute([$nome, $tel, $id]);
        
        header("Location: entregadores.php"); exit;
    }

    // 3. EXCLUIR ENTREGADOR
    if (isset($_POST['acao']) && $_POST['acao'] == 'excluir') {
        $id = $_POST['id'];
        $pdo->prepare("DELETE FROM entregadores WHERE id = ?")->execute([$id]);
        header("Location: entregadores.php"); exit;
    }
}

// BUSCA LISTA
$entregadores = $pdo->query("SELECT * FROM entregadores ORDER BY nome ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Entregadores</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { font-family: 'Segoe UI', sans-serif; background: #eaeff2; padding: 20px; }
        .card { background: white; padding: 20px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); max-width: 800px; margin: 0 auto; }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #eee; }
        th { background: #f8f9fa; color: #555; }
        
        input { padding: 10px; border: 1px solid #ddd; border-radius: 5px; width: 100%; box-sizing: border-box; margin-bottom: 10px;}
        label { font-weight: bold; font-size: 0.9rem; display: block; margin-bottom: 5px; color: #333; }

        .btn { padding: 8px 12px; border: none; border-radius: 5px; cursor: pointer; color: white; font-weight: bold; font-size: 0.9rem; display: inline-flex; align-items: center; justify-content: center; text-decoration: none;}
        
        .btn-green { background: #27ae60; width: 100%; padding: 12px; font-size: 1rem; } /* Botão Cadastrar Grande */
        .btn-red { background: #e74c3c; }
        .btn-blue { background: #3498db; }
        .btn-zap { background: #25D366; } .btn-zap:hover { background: #128C7E; }
        
        .btn-voltar { text-decoration: none; color: #555; font-weight: bold; display: flex; align-items: center; gap: 5px; }
        .acoes-group { display: flex; gap: 5px; justify-content: flex-end; }

        /* ESTILO DO MODAL (JANELA) */
        .modal { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); align-items: center; justify-content: center; z-index: 999; }
        .modal-content { background: white; padding: 25px; border-radius: 10px; width: 90%; max-width: 400px; box-shadow: 0 10px 25px rgba(0,0,0,0.3); }
    </style>
</head>
<body>

    <div class="card">
        <div class="header">
            <a href="index.php" class="btn-voltar"><i class="fas fa-arrow-left"></i> Voltar</a>
            <h2>Equipe de Motos</h2>
        </div>

        <form method="POST" style="background:#f9f9f9; padding:20px; border-radius:8px; margin-bottom:20px; border:1px solid #eee;">
            <input type="hidden" name="acao" value="novo">
            <h4 style="margin-top:0; margin-bottom:15px; color:#555">Novo Cadastro</h4>
            
            <div style="display: flex; gap: 15px; flex-wrap: wrap;">
                <div style="flex: 1; min-width: 200px;">
                    <label>Nome do Entregador</label>
                    <input type="text" name="nome" placeholder="Ex: João da Silva" required>
                </div>
                <div style="flex: 1; min-width: 200px;">
                    <label>Telefone (DDD + Número)</label>
                    <input type="text" name="telefone" placeholder="Ex: 11999998888">
                </div>
            </div>
            
            <button type="submit" class="btn btn-green"><i class="fas fa-plus-circle"></i> CADASTRAR</button>
        </form>

        <h3>Entregadores Ativos (<?php echo count($entregadores); ?>)</h3>
        <table>
            <thead>
                <tr>
                    <th>Nome</th>
                    <th>Telefone</th>
                    <th style="text-align:right">Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($entregadores) == 0): ?>
                    <tr><td colspan="3" style="text-align:center; color:#999; padding: 20px;">Nenhum entregador cadastrado.</td></tr>
                <?php else: ?>
                    <?php foreach($entregadores as $e): 
                        $numeroLimpo = preg_replace("/[^0-9]/", "", $e['telefone']);
                        $linkZap = "";
                        if(strlen($numeroLimpo) > 8) {
                            $linkZap = "https://wa.me/55{$numeroLimpo}?text=Entrega%20Pronta!%20Pode%20retirar.";
                        }
                    ?>
                    <tr>
                        <td><i class="fas fa-motorcycle" style="color:#e67e22"></i> <strong><?php echo $e['nome']; ?></strong></td>
                        <td><?php echo $e['telefone'] ? $e['telefone'] : '<small style="color:#ccc">Sem nº</small>'; ?></td>
                        <td style="text-align:right">
                            <div class="acoes-group">
                                <?php if($linkZap): ?>
                                    <a href="<?php echo $linkZap; ?>" target="_blank" class="btn btn-zap" title="Chamar no Whats"><i class="fab fa-whatsapp"></i></a>
                                <?php endif; ?>

                                <button type="button" class="btn btn-blue" onclick="abrirEditar('<?php echo $e['id']; ?>', '<?php echo $e['nome']; ?>', '<?php echo $e['telefone']; ?>')" title="Editar">
                                    <i class="fas fa-edit"></i>
                                </button>

                                <form method="POST" onsubmit="return confirm('Excluir <?php echo $e['nome']; ?>?');" style="margin:0;">
                                    <input type="hidden" name="acao" value="excluir">
                                    <input type="hidden" name="id" value="<?php echo $e['id']; ?>">
                                    <button class="btn btn-red" title="Excluir"><i class="fas fa-trash"></i></button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div id="modal-editar" class="modal">
        <div class="modal-content">
            <h3 style="margin-top:0">Editar Entregador</h3>
            <form method="POST">
                <input type="hidden" name="acao" value="editar">
                <input type="hidden" name="id" id="edit-id">
                
                <label>Nome</label>
                <input type="text" name="nome" id="edit-nome" required>
                
                <label>Telefone</label>
                <input type="text" name="telefone" id="edit-tel">
                
                <button type="submit" class="btn btn-green" style="margin-top:10px;">SALVAR ALTERAÇÕES</button>
                <button type="button" class="btn btn-red" onclick="document.getElementById('modal-editar').style.display='none'" style="width:100%; margin-top:5px; background:#ccc; color:#333;">CANCELAR</button>
            </form>
        </div>
    </div>

    <script>
        function abrirEditar(id, nome, tel) {
            document.getElementById('edit-id').value = id;
            document.getElementById('edit-nome').value = nome;
            document.getElementById('edit-tel').value = tel;
            document.getElementById('modal-editar').style.display = 'flex';
        }
        
        // Fecha modal ao clicar fora
        window.onclick = function(event) {
            if (event.target == document.getElementById('modal-editar')) {
                document.getElementById('modal-editar').style.display = "none";
            }
        }
    </script>

</body>
</html>