<?php
// ARQUIVO: ai_generator.php
// ATUALIZAÇÃO: Inclusão de Natação e Hidroginástica

function traduzirTermoFitness($termoOriginal) {
    $termo = strtolower(trim($termoOriginal));
    
    // 1. DICIONÁRIO MANUAL (Termos Específicos)
    $dicionario = [
        // ESPORTES AQUÁTICOS (NOVOS)
        'natacao' => 'swimming pool athlete swimmer competition',
        'hidroginastica' => 'water aerobics aqua fitness pool exercise group',
        'hidro' => 'water aerobics aqua fitness',

        // TREINO / ACADEMIA
        'musculacao' => 'bodybuilding gym workout weights',
        'treino' => 'gym workout fitness athlete',
        'crossfit' => 'crossfit intense workout',
        'aerobico' => 'cardio treadmill running gym',
        'esteira' => 'treadmill running gym',
        'pilates' => 'pilates reformer gym',
        'perna' => 'leg day workout gym',
        'braco' => 'biceps workout gym',
        'costas' => 'back workout bodybuilding',
        'gluteo' => 'squat woman gym fitness',
        'abdominal' => 'abs workout core fitness',
        'funcional' => 'functional training gym',
        'boxe' => 'boxing training gym',
        'luta' => 'mma fighting gym',
        'zumba' => 'zumba dance fitness class',
        'spinning' => 'spinning bike gym class',

        // NUTRIÇÃO
        'nutricao' => 'fresh healthy food vegetables fruits',
        'dieta' => 'healthy meal prep chicken salad',
        'fruta' => 'fresh fruits close up',
        'salada' => 'healthy salad bowl',
        'proteina' => 'grilled chicken steak food',
        'agua' => 'drinking water bottle gym',
        'suplemento' => 'whey protein shake powder',
        'detox' => 'green detox juice',

        // SAÚDE
        'saude' => 'doctor medical checkup',
        'bem-estar' => 'meditation relaxing yoga',
        'sono' => 'sleeping bed peaceful',
        'coracao' => 'heart rate monitor smart watch',
        'fisioterapia' => 'physiotherapy massage'
    ];

    foreach ($dicionario as $pt => $en) {
        if (strpos($termo, $pt) !== false) return $en;
    }

    // LÓGICA DE FALLBACK
    if (strpos($termo, 'comer') !== false || strpos($termo, 'alimento') !== false) {
        return $termoOriginal . " healthy food";
    }
    if (strpos($termo, 'medico') !== false || strpos($termo, 'dor') !== false) {
        return "doctor health medicine";
    }

    // Padrão agressivo de academia
    return $termoOriginal . " gym workout fitness athlete intense";
}

function buscarTextoIA($tema) {
    $termo = strtolower($tema);

    // Dicas de Nutrição
    $dicasNutri = [
        ['titulo' => 'HIDRATE-SE', 'texto' => 'Músculo desidratado não cresce. Beba água durante o treino.'],
        ['titulo' => 'COMER LIMPO', 'texto' => 'Descasque mais, desembale menos. Prefira alimentos naturais.'],
        ['titulo' => 'PRÉ-TREINO', 'texto' => 'Carboidratos complexos 1h antes do treino garantem energia.'],
        ['titulo' => 'PÓS-TREINO', 'texto' => 'Proteína é essencial agora para recuperar as fibras musculares.']
    ];

    // Dicas de Saúde
    $dicasSaude = [
        ['titulo' => 'SONO', 'texto' => 'É dormindo que o músculo cresce. Garanta 8h de sono.'],
        ['titulo' => 'CHECK-UP', 'texto' => 'Faça exames regularmente. Prevenção é o melhor remédio.'],
        ['titulo' => 'MENTE SÃ', 'texto' => 'Treinar combate a ansiedade e libera endorfina.']
    ];

    // Dicas de Água (NOVO)
    $dicasAgua = [
        ['titulo' => 'RESPIRAÇÃO', 'texto' => 'Controle a respiração para nadar mais longe e cansar menos.'],
        ['titulo' => 'IMPACTO ZERO', 'texto' => 'A água protege suas articulações enquanto você queima calorias.'],
        ['titulo' => 'CIRCULAÇÃO', 'texto' => 'A pressão da água ajuda no retorno venoso e reduz inchaços.']
    ];

    // Dicas de Treino (Padrão)
    $dicasTreino = [
        ['titulo' => 'FOCO TOTAL', 'texto' => 'Esqueça o celular. Conecte-se com seu músculo.'],
        ['titulo' => 'CONSTÂNCIA', 'texto' => 'O segredo não é a intensidade, é a frequência.'],
        ['titulo' => 'SEM DESCULPAS', 'texto' => 'Seu corpo aguenta quase tudo. É sua mente que manda.'],
        ['titulo' => 'FALHA', 'texto' => 'Vá até a falha. É lá que o resultado mora.']
    ];

    // Seleção Inteligente
    if (strpos($termo, 'nutri') !== false || strpos($termo, 'dieta') !== false) return $dicasNutri[array_rand($dicasNutri)];
    if (strpos($termo, 'saude') !== false || strpos($termo, 'sono') !== false) return $dicasSaude[array_rand($dicasSaude)];
    if (strpos($termo, 'nata') !== false || strpos($termo, 'hidro') !== false) return $dicasAgua[array_rand($dicasAgua)];

    return $dicasTreino[array_rand($dicasTreino)];
}

function gerarImagemIA($tema, $formato = '16:9') {
    if (!defined('API_KEY_PEXELS') || empty(API_KEY_PEXELS)) return 'https://placehold.co/1920x1080/000/FFF?text=ERRO+API';
    if (!is_dir('uploads')) mkdir('uploads', 0777, true);

    $orientacao = ($formato == '9:16') ? 'portrait' : 'landscape';
    $termoBusca = urlencode(traduzirTermoFitness($tema));
    $pagina = rand(1, 10); 

    $url = "https://api.pexels.com/v1/search?query=$termoBusca&orientation=$orientacao&size=large&per_page=1&page=$pagina";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Authorization: ' . API_KEY_PEXELS]);

    $result = curl_exec($ch);
    curl_close($ch);

    $json = json_decode($result, true);

    if (isset($json['photos'][0]['src']['large'])) {
        $urlRemota = $json['photos'][0]['src']['large']; 
        $conteudo = file_get_contents($urlRemota);
        if ($conteudo) {
            $nomeArquivo = 'uploads/pexels_' . uniqid() . '.jpg';
            file_put_contents($nomeArquivo, $conteudo);
            return $nomeArquivo;
        }
    }
    return 'https://placehold.co/1920x1080/333/FFF?text=TENTE+OUTRO+TERMO';
}
?>