<?php
// Limpa qualquer texto ou erro que tenha sido gerado antes (Isso conserta o erro de não baixar)
ob_start();

require('fpdf/fpdf.php');
require('conexao.php');

class PDF extends FPDF {
    function Header() {
        // Logo (Verifica se existe para não dar erro)
        if(file_exists('img/logomais.png')) {
            $this->Image('img/logomais.png', 10, 6, 30);
        }
        
        $this->SetFont('Arial', 'B', 14);
        $this->Cell(0, 10, utf8_decode('RELATÓRIO DE VENDAS DO DIA'), 0, 1, 'C');
        
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 5, 'Data: ' . date('d/m/Y'), 0, 1, 'C');
        $this->Ln(10);

        // Cabeçalho da Tabela
        $this->SetFont('Arial', 'B', 8);
        $this->SetFillColor(200, 200, 200);
        $this->Cell(10, 6, 'ID', 1, 0, 'C', true);
        $this->Cell(40, 6, 'CLIENTE', 1, 0, 'L', true); // Aumentei um pouco a largura
        $this->Cell(100, 6, 'ITENS / RESUMO', 1, 0, 'L', true);
        $this->Cell(25, 6, 'VALOR', 1, 0, 'R', true);
        $this->Cell(15, 6, 'PG', 1, 1, 'C', true);
    }

    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, utf8_decode('Página ') . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }
}

// 1. Definição do Período (Hoje)
$inicio = date('Y-m-d 00:00:00');
$fim    = date('Y-m-d 23:59:59');

// 2. Busca no Banco
$sql = "SELECT * FROM pedidos WHERE data_pedido >= '$inicio' AND data_pedido <= '$fim' ORDER BY id ASC";
$pedidos = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);

// 3. Inicializa Totais
$total_dinheiro = 0;
$resumo_itens = []; // Array dinâmico para somar qualquer produto

$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 8);

foreach ($pedidos as $p) {
    $total_dinheiro += $p['valor_total'];
    
    // --- LÓGICA DE ITENS (Híbrida: JSON + Antigo) ---
    $txt_itens = [];

    // Tenta ler JSON (Novo Sistema)
    $json_decodificado = json_decode($p['itens_json'] ?? '', true);
    
    if (is_array($json_decodificado)) {
        // É um pedido novo
        foreach ($json_decodificado as $item) {
            $nome = $item['nome'];
            $qtd = intval($item['qtd']);
            $txt_itens[] = "{$qtd}x $nome";
            
            // Soma no resumo geral
            if (!isset($resumo_itens[$nome])) $resumo_itens[$nome] = 0;
            $resumo_itens[$nome] += $qtd;
        }
    } else {
        // É um pedido antigo (Colunas fixas)
        $mapa = [
            'q_inteiro' => 'Frango Int.', 'q_meio' => 'Meio Frango',
            'q_trop_g' => 'Tropeiro G', 'q_trop_p' => 'Tropeiro P',
            'q_salp_g' => 'Salpicão G', 'q_salp_p' => 'Salpicão P',
            'q_maionese' => 'Maionese', 'q_farofa' => 'Farofa'
        ];
        foreach ($mapa as $col => $nomeNice) {
            if (!empty($p[$col]) && $p[$col] > 0) {
                $qtd = $p[$col];
                $txt_itens[] = "{$qtd}x $nomeNice";
                
                if (!isset($resumo_itens[$nomeNice])) $resumo_itens[$nomeNice] = 0;
                $resumo_itens[$nomeNice] += $qtd;
            }
        }
    }

    // Transforma array em string (ex: "1x Frango, 1x Coca")
    $linha_pedido = implode(', ', $txt_itens);
    
    // Garante que o nome do cliente apareça (utf8 para acentos)
    $nome_cliente = utf8_decode(substr($p['cliente'], 0, 22)); 

    // --- DESENHA A LINHA NA TABELA ---
    // Cell(largura, altura, texto, borda, quebra_linha, alinhamento)
    $pdf->Cell(10, 6, $p['id'], 1, 0, 'C');
    $pdf->Cell(40, 6, $nome_cliente, 1, 0, 'L');
    $pdf->Cell(100, 6, utf8_decode(substr($linha_pedido, 0, 80)), 1, 0, 'L'); // Corta se for mto longo
    $pdf->Cell(25, 6, number_format($p['valor_total'], 2, ',', '.'), 1, 0, 'R');
    
    // Status Pagamento
    $status = $p['pago'] ? 'OK' : 'PEND';
    $pdf->SetTextColor($p['pago'] ? 0 : 200, 0, 0); // Vermelho se pendente
    $pdf->Cell(15, 6, $status, 1, 1, 'C');
    $pdf->SetTextColor(0); // Reseta cor
}

// --- RODAPÉ DE RESUMO ---
$pdf->Ln(10);
$pdf->SetFont('Arial', 'B', 10);
$pdf->Cell(0, 8, utf8_decode('RESUMO DOS ITENS VENDIDOS:'), 0, 1, 'L');

$pdf->SetFont('Arial', '', 9);
$pdf->SetFillColor(240, 240, 240);

// Imprime totais dinamicamente
arsort($resumo_itens); // Ordena do maior para o menor
$contador = 0;

foreach ($resumo_itens as $nome => $qtd) {
    // Imprime 3 itens por linha para economizar folha
    $pdf->Cell(63, 7, utf8_decode("$nome: $qtd"), 1, 0, 'L', true);
    $contador++;
    if ($contador % 3 == 0) $pdf->Ln();
}
if ($contador % 3 != 0) $pdf->Ln(); // Fecha linha se sobrou

$pdf->Ln(5);
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, 'TOTAL DO DIA: R$ ' . number_format($total_dinheiro, 2, ',', '.'), 1, 1, 'C');

// Limpa buffer novamente antes da saída final
ob_end_clean();

// Gera o PDF no navegador (I = Inline)
$pdf->Output('I', 'relatorio_vendas.pdf');
?>