<?php
require 'conexao.php';

// --- LGICA DE DADOS DO DIA ---
$hoje = date('Y-m-d');

// 1. Busca todos os pedidos de HOJE
$sql = "SELECT * FROM pedidos WHERE DATE(data_pedido) = '$hoje' ORDER BY id DESC";
$stmt = $pdo->query($sql);
$pedidosHoje = $stmt->fetchAll(PDO::FETCH_ASSOC);

// 2. Calcula Totais
$faturamento = 0;
$qtdPedidos = count($pedidosHoje);
$pedidosPagos = 0;
$pedidosEntregues = 0;

// 3. Contagem de Itens Vendidos (O "Pulo do Gato" para o sistema dinmico)
$rankingItens = [];

foreach ($pedidosHoje as $p) {
    $faturamento += $p['valor_total'];
    if ($p['pago']) $pedidosPagos++;
    if ($p['entregue']) $pedidosEntregues++;

    // Decodifica o JSON para contar os itens
    if (!empty($p['itens_json'])) {
        $itens = json_decode($p['itens_json'], true);
        if (is_array($itens)) {
            foreach ($itens as $item) {
                $nome = $item['nome'];
                $qtd = $item['qtd'];
                
                if (!isset($rankingItens[$nome])) {
                    $rankingItens[$nome] = 0;
                }
                $rankingItens[$nome] += $qtd;
            }
        }
    }
}

// Ordena os itens mais vendidos primeiro
arsort($rankingItens);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Mais Churrasco</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    
    <meta http-equiv="refresh" content="60">

    <style>
        body { background-color: #f4f6f9; }
        .card-stat { border: none; border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); transition: transform 0.2s; }
        .card-stat:hover { transform: translateY(-5px); }
        .icon-box { width: 50px; height: 50px; border-radius: 10px; display: flex; align-items: center; justify-content: center; font-size: 1.5rem; }
        .bg-gradient-primary { background: linear-gradient(45deg, #4e73df, #224abe); color: white; }
        .bg-gradient-success { background: linear-gradient(45deg, #1cc88a, #13855c); color: white; }
        .bg-gradient-warning { background: linear-gradient(45deg, #f6c23e, #dda20a); color: white; }
        .table-itens tr td:first-child { font-weight: bold; color: #555; }
    </style>
</head>
<body>

    <nav class="navbar navbar-dark bg-dark mb-4 shadow">
        <div class="container-fluid">
            <span class="navbar-brand fw-bold mb-0 h1">
                <i class="bi bi-speedometer2"></i> DASHBOARD GERAL
            </span>
            <span class="text-white-50 small">Dados de Hoje: <?= date('d/m/Y') ?></span>
        </div>
    </nav>

    <div class="container pb-5">

        <div class="row g-3 mb-4">
            <div class="col-6 col-md-3">
                <a href="admin_ped.php" class="btn btn-dark w-100 py-3 fw-bold shadow-sm">
                    <i class="bi bi-list-ul d-block fs-3 mb-1"></i> ADMIN (PEDIDOS)
                </a>
            </div>
            <div class="col-6 col-md-3">
                <a href="pdv.php" class="btn btn-primary w-100 py-3 fw-bold shadow-sm">
                    <i class="bi bi-cart-plus d-block fs-3 mb-1"></i> NOVO PEDIDO
                </a>
            </div>
            <div class="col-6 col-md-3">
                <a href="entrega_pdv.php" class="btn btn-warning w-100 py-3 fw-bold shadow-sm text-dark">
                    <i class="bi bi-truck d-block fs-3 mb-1"></i> TELA ENTREGA
                </a>
            </div>
            <div class="col-6 col-md-3">
                <a href="produtos.php" class="btn btn-secondary w-100 py-3 fw-bold shadow-sm">
                    <i class="bi bi-box-seam d-block fs-3 mb-1"></i> PRODUTOS
                </a>
            </div>
        </div>

        <div class="row g-4 mb-4">
            <div class="col-md-4">
                <div class="card card-stat h-100">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="text-uppercase text-muted fw-bold mb-1">Faturamento (Hoje)</h6>
                            <h2 class="mb-0 fw-bold text-success">R$ <?= number_format($faturamento, 2, ',', '.') ?></h2>
                        </div>
                        <div class="icon-box bg-success bg-opacity-10 text-success">
                            <i class="bi bi-currency-dollar"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card card-stat h-100">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h6 class="text-uppercase text-muted fw-bold mb-1">Total Pedidos</h6>
                            <h2 class="mb-0 fw-bold text-primary"><?= $qtdPedidos ?></h2>
                            <small class="text-muted">Pagos: <?= $pedidosPagos ?> | Pend: <?= $qtdPedidos - $pedidosPagos ?></small>
                        </div>
                        <div class="icon-box bg-primary bg-opacity-10 text-primary">
                            <i class="bi bi-receipt"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card card-stat h-100">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <?php $ticketMedio = $qtdPedidos > 0 ? $faturamento / $qtdPedidos : 0; ?>
                        <div>
                            <h6 class="text-uppercase text-muted fw-bold mb-1">Ticket Mdio</h6>
                            <h2 class="mb-0 fw-bold text-warning">R$ <?= number_format($ticketMedio, 2, ',', '.') ?></h2>
                        </div>
                        <div class="icon-box bg-warning bg-opacity-10 text-warning">
                            <i class="bi bi-graph-up-arrow"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-6 mb-4">
                <div class="card shadow border-0 h-100">
                    <div class="card-header bg-white py-3 border-bottom">
                        <h6 class="m-0 fw-bold text-primary"><i class="bi bi-basket"></i> ITENS VENDIDOS HOJE</h6>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                            <table class="table table-striped table-hover mb-0 table-itens">
                                <thead class="table-light sticky-top">
                                    <tr>
                                        <th>Produto</th>
                                        <th class="text-center">Qtd Vendida</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(count($rankingItens) > 0): ?>
                                        <?php foreach($rankingItens as $nomeItem => $qtdItem): ?>
                                            <tr>
                                                <td><?= $nomeItem ?></td>
                                                <td class="text-center">
                                                    <span class="badge bg-dark fs-6"><?= $qtdItem ?></span>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="2" class="text-center text-muted py-4">Nenhuma venda hoje.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-6 mb-4">
                <div class="card shadow border-0 h-100">
                    <div class="card-header bg-white py-3 border-bottom d-flex justify-content-between align-items-center">
                        <h6 class="m-0 fw-bold text-primary"><i class="bi bi-clock-history"></i> LTIMOS 5 PEDIDOS</h6>
                        <a href="admin_ped.php" class="btn btn-sm btn-outline-primary">Ver Todos</a>
                    </div>
                    <div class="card-body p-0">
                        <ul class="list-group list-group-flush">
                            <?php 
                            // Pega apenas os 5 primeiros
                            $ultimos5 = array_slice($pedidosHoje, 0, 5);
                            ?>
                            <?php foreach($ultimos5 as $p): ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center p-3">
                                    <div>
                                        <span class="fw-bold">#<?= str_pad($p['id'], 3, '0', STR_PAD_LEFT) ?> <?= strtoupper($p['cliente']) ?></span>
                                        <br>
                                        <small class="text-muted"><?= date('H:i', strtotime($p['data_pedido'])) ?></small>
                                        <?php if($p['entregue']): ?>
                                            <span class="badge bg-secondary ms-1">Entregue</span>
                                        <?php else: ?>
                                            <span class="badge bg-warning text-dark ms-1">Prep.</span>
                                        <?php endif; ?>
                                    </div>
                                    <span class="fw-bold text-success">R$ <?= number_format($p['valor_total'], 2, ',', '.') ?></span>
                                </li>
                            <?php endforeach; ?>
                            <?php if(empty($ultimos5)): ?>
                                <li class="list-group-item text-center text-muted py-4">Sem pedidos hoje.</li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

    </div>

</body>
</html>