<?php
require 'conexao.php';

// Verifica ID
if (!isset($_GET['id'])) die("Pedido não informado.");
$id = intval($_GET['id']);

// Busca pedido
$stmt = $pdo->prepare("SELECT * FROM pedidos WHERE id = ?");
$stmt->execute([$id]);
$p = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$p) die("Pedido não encontrado.");

// --- MONTAGEM DOS ITENS ---
$linhasItens = "";

if (!empty($p['itens_json'])) {
    $itens = json_decode($p['itens_json'], true);
    if (is_array($itens)) {
        foreach ($itens as $i) {
            $sub = number_format($i['subtotal'] ?? ($i['qtd'] * $i['preco']), 2, ',', '.');
            $linhasItens .= "
            <tr>
                <td class='col-qtd'>{$i['qtd']}</td>
                <td class='col-item'>{$i['nome']}</td>
                <td class='col-price'>$sub</td>
            </tr>";
        }
    }
} else {
    // Legado
    $mapaAntigo = [
        'q_inteiro' => ['Frango Int.', $precos['inteiro'] ?? 0],
        'q_meio' => ['Meio Frango', $precos['meio'] ?? 0],
        'q_trop_g' => ['Tropeiro G', $precos['trop_g'] ?? 0],
        'q_trop_p' => ['Tropeiro P', $precos['trop_p'] ?? 0],
        'q_salp_g' => ['Salpicão G', $precos['salp_g'] ?? 0],
        'q_salp_p' => ['Salpicão P', $precos['salp_p'] ?? 0],
        'q_maionese' => ['Maionese', $precos['maionese'] ?? 0],
        'q_farofa' => ['Farofa', $precos['farofa'] ?? 0],
    ];

    foreach($mapaAntigo as $col => $dados) {
        $qtd = intval($p[$col] ?? 0);
        if($qtd > 0) {
            $valUnit = $dados[1];
            $sub = number_format($qtd * $valUnit, 2, ',', '.');
            $linhasItens .= "
            <tr>
                <td class='col-qtd'>{$qtd}</td>
                <td class='col-item'>{$dados[0]}</td>
                <td class='col-price'>$sub</td>
            </tr>";
        }
    }
}

// Dados Gerais
$dataHora = date('d/m/Y H:i', strtotime($p['data_pedido']));
$senhaFmt = str_pad($p['id'], 3, '0', STR_PAD_LEFT);
$totalFmt = number_format($p['valor_total'], 2, ',', '.');
$statusPag = $p['pago'] ? "PAGAMENTO: [ PAGO ]" : "PAGAMENTO: [ PENDENTE ]";
$obsBlock = !empty($p['observacao']) ? "<div class='obs-box'>OBS: ".strtoupper($p['observacao'])."</div>" : "";

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Pedido #<?= $id ?></title>
    <style>
        /* RESET TOTAL */
        * { box-sizing: border-box; margin: 0; padding: 0; }
        
        /* CORPO DA PÁGINA (Visualização Tela) */
        body { 
            background-color: #555; 
            display: flex; 
            flex-direction: column;
            align-items: center; 
            padding-top: 20px;
            font-family: 'Arial', sans-serif;
        }

        /* BOTÃO DE IMPRIMIR NA TELA */
        .btn-print { 
            position: fixed; top: 20px; right: 20px;
            padding: 15px 30px; background: #28a745; color: #fff; 
            border: none; font-size: 16px; font-weight: bold; cursor: pointer; 
            border-radius: 5px; box-shadow: 0 4px 6px rgba(0,0,0,0.3);
            z-index: 1000;
        }
        .btn-print:hover { background: #218838; }

        /* --- CONFIGURAÇÃO DO PAPEL (CSS CRÍTICO) --- */
        #area-impressao {
            width: 72mm; /* LARGURA SEGURA PARA PAPEL 80MM */
            background: #fff;
            padding: 5px 2px; /* Margens internas mínimas */
            margin: 0 auto; /* Centraliza na tela */
            box-shadow: 0 0 15px rgba(0,0,0,0.5);
            font-size: 12px;
            color: #000;
            overflow: hidden; /* Evita que conteúdo estoure */
        }

        /* ELEMENTOS INTERNOS */
        .cupom-wrapper { width: 100%; }

        .logo-container { text-align: center; border-bottom: 3px solid #000; padding-bottom: 5px; margin-bottom: 5px; }
        .logo-img { max-width: 90px; height: auto; display: block; margin: 0 auto; }
        
        .header { text-align: center; border-bottom: 2px solid #000; padding-bottom: 5px; margin-bottom: 5px; line-height: 1.1; }
        .cli-info { font-weight: bold; border-bottom: 1px dashed #000; padding-bottom: 5px; margin-bottom: 5px; font-size: 12px; line-height: 1.2; }

        /* TABELA AJUSTADA */
        .check-table { width: 100%; border-collapse: collapse; table-layout: fixed; }
        .check-table th { border-bottom: 1px solid #000; text-align: left; font-size: 10px; padding: 2px 0; }
        .check-table td { border-bottom: 1px dotted #999; padding: 3px 0; vertical-align: top; }
        
        /* COLUNAS OTIMIZADAS PARA 72MM */
        .col-qtd { width: 12%; text-align: center; font-weight: 800; font-size: 13px; }
        .col-item { width: 58%; text-align: left; padding-left: 2px; line-height: 1.1; }
        .col-price { width: 30%; text-align: right; white-space: nowrap; font-weight: 600; }
        
        /* ALINHAMENTO DIREITA */
        .check-table th:last-child { text-align: right; }

        .total-area { border-top: 2px solid #000; font-size: 16px; font-weight: 800; text-align: right; margin-top: 8px; padding-top: 5px; }
        .obs-box { border: 2px solid #000; background: #eee !important; padding: 3px; text-align: center; font-weight: bold; margin-top: 8px; font-size: 11px; -webkit-print-color-adjust: exact; }
        
        /* --- MODO IMPRESSÃO (O MAIS IMPORTANTE) --- */
        @media print {
            @page {
                margin: 0; /* ZERA MARGENS DA IMPRESSORA */
                size: 80mm auto; /* FORÇA TAMANHO DO PAPEL */
            }
            
            body { 
                background: #fff; 
                display: block; 
                margin: 0; 
                padding: 0; 
            }
            
            .btn-print { display: none !important; } /* Esconde botão */
            
            #area-impressao {
                width: 100%; /* Ocupa 100% da área definida no @page */
                max-width: 74mm; /* Trava largura máxima */
                box-shadow: none; 
                margin: 0; 
                padding: 0 2px;
                position: absolute; 
                left: 0; 
                top: 0;
            }
        }
    </style>
</head>
<body>

    <button class="btn-print" onclick="window.print()">IMPRIMIR AGORA</button>

    <div id="area-impressao">
        <div class="cupom-wrapper">
            <div class="logo-container">
                <img src="img/logomais.png" alt="MC" class="logo-img">
            </div>

            <div class="header">
                <h2 style="margin:0; font-size: 20px;">SENHA: <?= $senhaFmt ?></h2>
                <span style="font-size: 11px;"><?= $dataHora ?></span>
            </div>

            <div class="cli-info">
                <?= strtoupper($p['cliente']) ?><br>
                <?= $p['telefone'] ? "TEL: {$p['telefone']}" : "" ?>
            </div>

            <table class="check-table">
                <thead>
                    <tr>
                        <th class="col-qtd">QTD</th>
                        <th class="col-item">ITEM</th>
                        <th class="col-price">$$</th>
                    </tr>
                </thead>
                <tbody>
                    <?= $linhasItens ?>
                </tbody>
            </table>

            <div class="total-area">
                TOTAL: R$ <?= $totalFmt ?>
            </div>
            
            <div style="text-align: right; font-size: 12px; margin-top: 5px; font-weight: bold;">
                <?= $statusPag ?>
            </div>

            <?= $obsBlock ?>
            
            <div style="text-align: center; font-size: 10px; margin-top: 15px;">
                *** OBRIGADO PELA PREFERÊNCIA ***
            </div>
        </div>
    </div>

    <script>
        // Auto impressão e fecha ao terminar
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
        window.onafterprint = function() {
            window.close();
        };
    </script>
</body>
</html>