<?php
require 'conexao.php';

// Ação Entregar
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id_entregue'])) {
    $id = intval($_POST['id_entregue']);
    $pdo->query("UPDATE pedidos SET entregue = 1 WHERE id = $id");
    header("Location: entrega.php");
    exit;
}

$sql = "SELECT * FROM pedidos WHERE entregue = 0 ORDER BY id ASC";
$pedidos = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Expedição</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <meta http-equiv="refresh" content="15">
    <style>
        body { background-color: #212529; color: #fff; padding-bottom: 20px; }
        .card-pedido { background: #fff; color: #000; border-radius: 8px; margin-bottom: 20px; overflow: hidden; position: relative; }
        .senha-box { background: #ffc107; color: #000; font-weight: 900; font-size: 3rem; text-align: center; padding: 5px; line-height: 1; }
        .cliente-box { padding: 12px; font-weight: 800; font-size: 1.5rem; text-align: center; border-bottom: 1px solid #ddd; }
        .area-assados { padding: 15px; text-align: center; background-color: #f8f9fa; }
        .btn-entregar { width: 100%; border-radius: 0; padding: 25px; font-size: 1.5rem; font-weight: 900; text-transform: uppercase; }
        .status-badge { position: absolute; top: 10px; right: 10px; font-size: 0.9rem; z-index: 10; padding: 5px 10px; }
    </style>
</head>
<body>
    <div class="bg-black p-3 sticky-top border-bottom border-danger d-flex justify-content-between align-items-center">
        <div class="fw-bold fs-4 text-white"><i class="bi bi-truck text-danger"></i> KDS / EXPEDIÇÃO</div>
        <div class="spinner-grow spinner-grow-sm text-danger"></div>
    </div>
    <div class="container mt-4">
        <?php if(count($pedidos) > 0): ?>
            <div class="row">
                <?php foreach($pedidos as $p): ?>
                    <?php 
                        // --- LÓGICA HÍBRIDA (Compatível com Antigo e Novo) ---
                        $q_int = 0;
                        $q_meio = 0;

                        // Verifica se é JSON (Novo sistema)
                        if (!empty($p['itens_json'])) {
                            $itens = json_decode($p['itens_json'], true);
                            if (is_array($itens)) {
                                foreach($itens as $i) {
                                    // Procura palavras chaves no nome
                                    if (stripos($i['nome'], 'Inteiro') !== false) $q_int += $i['qtd'];
                                    if (stripos($i['nome'], 'Meio') !== false)    $q_meio += $i['qtd'];
                                }
                            }
                        } else {
                            // Sistema antigo
                            $q_int = intval($p['q_inteiro'] ?? 0);
                            $q_meio = intval($p['q_meio'] ?? 0);
                        }
                    ?>
                    <div class="col-12 col-md-6 col-lg-4">
                        <div class="card-pedido shadow-lg">
                            <?php if($p['pago']): ?>
                                <span class="badge bg-success status-badge shadow">PAGO</span>
                            <?php else: ?>
                                <span class="badge bg-danger status-badge shadow">PENDENTE</span>
                            <?php endif; ?>

                            <div class="senha-box">#<?= str_pad($p['id'], 3, '0', STR_PAD_LEFT) ?></div>
                            <div class="cliente-box"><?= strtoupper($p['cliente']) ?></div>

                            <?php if($q_int > 0 || $q_meio > 0): ?>
                                <div class="area-assados">
                                    <?php if($q_int > 0): ?>
                                        <span class="badge bg-primary fs-3 shadow-sm border border-dark border-opacity-25 w-100 py-3 mb-2"><?= $q_int ?>x INTEIRO</span>
                                    <?php endif; ?>
                                    <?php if($q_meio > 0): ?>
                                        <span class="badge bg-info text-dark fs-3 shadow-sm border border-dark border-opacity-25 w-100 py-3"><?= $q_meio ?>x MEIO</span>
                                    <?php endif; ?>
                                </div>
                            <?php else: ?>
                                <div class="area-assados bg-warning bg-opacity-10 py-4"><span class="text-muted fw-bold fs-5">APENAS ACOMPANHAMENTOS</span></div>
                            <?php endif; ?>

                            <form method="POST" onsubmit="return confirm('Entregar?');">
                                <input type="hidden" name="id_entregue" value="<?= $p['id'] ?>">
                                <button type="submit" class="btn btn-success btn-entregar text-white">ENTREGUE <i class="bi bi-check2-circle"></i></button>
                            </form>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="text-center mt-5 text-secondary"><h2 class="fw-bold">Tudo Entregue!</h2></div>
        <?php endif; ?>
    </div>
</body>
</html>