<?php
require 'conexao.php';

// --- AÇÃO: Marcar como entregue ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id_entregue'])) {
    $id = intval($_POST['id_entregue']);
    $stmt = $pdo->prepare("UPDATE pedidos SET entregue = 1 WHERE id = ?");
    $stmt->execute([$id]);
    header("Location: entrega.php");
    exit;
}

// --- BUSCA: Trazendo quantidades dos frangos ---
$sql = "SELECT id, cliente, pago, q_inteiro, q_meio FROM pedidos WHERE entregue = 0 ORDER BY id ASC";
$stmt = $pdo->query($sql);
$pedidos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Expedição / Entrega</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    
    <meta http-equiv="refresh" content="15">

    <style>
        body { background-color: #343a40; color: #fff; padding-bottom: 20px; }
        .header-bar { background: #212529; padding: 15px; position: sticky; top: 0; z-index: 1000; box-shadow: 0 2px 5px rgba(0,0,0,0.5); }
        .card-pedido { background: #fff; color: #000; border-radius: 10px; margin-bottom: 15px; overflow: hidden; position: relative; }
        
        .senha-box { background: #ffc107; color: #000; font-weight: 900; font-size: 2.5rem; text-align: center; padding: 10px; line-height: 1; }
        .cliente-box { padding: 10px; font-weight: bold; font-size: 1.4rem; text-align: center; border-bottom: 1px solid #eee; }
        
        /* Área dos Itens Principais */
        .itens-destaque { padding: 10px; text-align: center; background-color: #f8f9fa; }
        .badge-item { font-size: 1.1rem; padding: 8px 12px; margin: 2px; display: inline-block; }
        
        .btn-entregar { width: 100%; border-radius: 0; padding: 20px; font-size: 1.2rem; font-weight: bold; text-transform: uppercase; }
        .status-badge { position: absolute; top: 10px; right: 10px; font-size: 0.8rem; }
    </style>
</head>
<body>

    <div class="header-bar d-flex justify-content-between align-items-center">
        <div class="fw-bold fs-5"><i class="bi bi-truck"></i> EXPEDIÇÃO</div>
        <div class="text-warning small"><i class="bi bi-arrow-clockwise"></i> Atualizando...</div>
    </div>

    <div class="container mt-3">
        <?php if(count($pedidos) > 0): ?>
            <div class="row">
                <?php foreach($pedidos as $p): ?>
                    <div class="col-12 col-md-6 col-lg-4">
                        <div class="card-pedido shadow">
                            
                            <?php if($p['pago']): ?>
                                <span class="badge bg-success status-badge">PAGO</span>
                            <?php else: ?>
                                <span class="badge bg-danger status-badge">PENDENTE</span>
                            <?php endif; ?>

                            <div class="senha-box">
                                #<?= str_pad($p['id'], 3, '0', STR_PAD_LEFT) ?>
                            </div>
                            
                            <div class="cliente-box">
                                <?= strtoupper($p['cliente']) ?>
                            </div>

                            <?php if($p['q_inteiro'] > 0 || $p['q_meio'] > 0): ?>
                            <div class="itens-destaque">
                                <?php if($p['q_inteiro'] > 0): ?>
                                    <span class="badge bg-primary badge-item">
                                        <?= $p['q_inteiro'] ?>x INTEIRO
                                    </span>
                                <?php endif; ?>
                                
                                <?php if($p['q_meio'] > 0): ?>
                                    <span class="badge bg-info text-dark badge-item">
                                        <?= $p['q_meio'] ?>x MEIO
                                    </span>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>

                            <form method="POST" onsubmit="return confirm('Entregar pedido #<?= $p['id'] ?>?');">
                                <input type="hidden" name="id_entregue" value="<?= $p['id'] ?>">
                                <button type="submit" class="btn btn-success btn-entregar">
                                    <i class="bi bi-check-lg"></i> ENTREGUE
                                </button>
                            </form>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="text-center text-muted mt-5 opacity-50">
                <i class="bi bi-cup-hot display-1"></i>
                <h3 class="mt-3">Sem pedidos pendentes</h3>
                <p>Aguardando novas vendas...</p>
            </div>
        <?php endif; ?>
    </div>

</body>
</html>