<?php
session_start();
date_default_timezone_set('America/Sao_Paulo');

$host = 'localhost';
$dbname = 'mgatvcom_frangoapp';
$username = 'mgatvcom_frangoapp';
$password = '3CQcFGvY=%z^';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec("SET time_zone = '-03:00'"); // Garante fuso no MySQL também
} catch (PDOException $e) {
    die("Erro na conexão: " . $e->getMessage());
}

// --- BUSCA CONFIGURAÇÕES (ESTOQUE E PREÇOS) ---
$stmt = $pdo->query("SELECT * FROM config LIMIT 1");
$cfg = $stmt->fetch(PDO::FETCH_ASSOC);

// Se o banco estiver vazio (primeira vez), define valores padrão para não dar erro
if (!$cfg) {
    $cfg = [
        'preco_inteiro' => 50, 'preco_meio' => 30, 'preco_trop_g' => 25, 'preco_trop_p' => 15,
        'preco_salp_g' => 25, 'preco_salp_p' => 15, 'preco_maionese' => 8, 'preco_farofa' => 5,
        'estoque_inteiro' => 0, 'estoque_meio' => 0, 'estoque_trop_g' => 0, 'estoque_trop_p' => 0,
        'estoque_salp_g' => 0, 'estoque_salp_p' => 0, 'estoque_maionese' => 0, 'estoque_farofa' => 0
    ];
}

// --- DEFINE A VARIÁVEL GLOBAL DE PREÇOS ---
$precos = [
    'inteiro' => $cfg['preco_inteiro'],
    'meio'    => $cfg['preco_meio'],
    'trop_g'  => $cfg['preco_trop_g'],
    'trop_p'  => $cfg['preco_trop_p'],
    'salp_g'  => $cfg['preco_salp_g'],
    'salp_p'  => $cfg['preco_salp_p'],
    'maionese'=> $cfg['preco_maionese'],
    'farofa'  => $cfg['preco_farofa']
];

function verificarLogin() {
    if (!isset($_SESSION['usuario_logado'])) {
        header("Location: login.php");
        exit;
    }
}

// --- FUNÇÃO DE ESTOQUE ---
function getEstoque($pdo) {
    global $cfg; // Usa a config já carregada acima para economizar consulta
    
    $inicio_dia = date('Y-m-d 00:00:00');
    $fim_dia    = date('Y-m-d 23:59:59');
    
    $sql = "SELECT 
            COALESCE(SUM(q_inteiro), 0) as s_inteiro, COALESCE(SUM(q_meio), 0) as s_meio,
            COALESCE(SUM(q_trop_g), 0) as s_trop_g, COALESCE(SUM(q_trop_p), 0) as s_trop_p,
            COALESCE(SUM(q_salp_g), 0) as s_salp_g, COALESCE(SUM(q_salp_p), 0) as s_salp_p,
            COALESCE(SUM(q_maionese), 0) as s_maionese, COALESCE(SUM(q_farofa), 0) as s_farofa
            FROM pedidos WHERE data_pedido >= '$inicio_dia' AND data_pedido <= '$fim_dia'";
            
    $stmt = $pdo->query($sql);
    $vendidos = $stmt->fetch(PDO::FETCH_ASSOC);
    
    return [
        'inteiro' => $cfg['estoque_inteiro'] - $vendidos['s_inteiro'],
        'meio'    => $cfg['estoque_meio']    - $vendidos['s_meio'],
        'trop_g'  => $cfg['estoque_trop_g']  - $vendidos['s_trop_g'],
        'trop_p'  => $cfg['estoque_trop_p']  - $vendidos['s_trop_p'],
        'salp_g'  => $cfg['estoque_salp_g']  - $vendidos['s_salp_g'],
        'salp_p'  => $cfg['estoque_salp_p']  - $vendidos['s_salp_p'],
        'maionese'=> $cfg['estoque_maionese']- $vendidos['s_maionese'],
        'farofa'  => $cfg['estoque_farofa']  - $vendidos['s_farofa'],
    ];
}
// --- NOVA FUNÇÃO: Carrega preços do banco ---
function getPrecosDoBanco($pdo) {
    $stmt = $pdo->query("SELECT slug, preco FROM produtos");
    $lista = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Cria um array igual ao que você tinha: ['inteiro' => 45.00, 'meio' => ...]
        $lista[$row['slug']] = floatval($row['preco']);
    }
    return $lista;
}

// Agora a variável global $precos vem do banco!
$precos = getPrecosDoBanco($pdo);
?>