<?php
require 'conexao.php';

$msg = '';
$sucesso = false;

// 1. BUSCA OS PRODUTOS DO BANCO
$stmt = $pdo->query("SELECT * FROM produtos ORDER BY nome ASC");
$produtos_db = $stmt->fetchAll(PDO::FETCH_ASSOC);

// 2. PROCESSA O PEDIDO
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cli = $_POST['cliente'];
    $tel = $_POST['telefone'];
    $obs = $_POST['obs'];
    
    $itens_vendidos = [];
    $total = 0;

    foreach ($produtos_db as $prod) {
        $id = $prod['id'];
        $qtd = intval($_POST['qtd_' . $id] ?? 0);
        
        if ($qtd > 0) {
            $subtotal = $qtd * $prod['preco'];
            $total += $subtotal;
            
            $itens_vendidos[] = [
                'id' => $id,
                'nome' => $prod['nome'],
                'qtd' => $qtd,
                'preco' => $prod['preco'],
                'subtotal' => $subtotal
            ];
        }
    }

    if ($total > 0) {
        $json_itens = json_encode($itens_vendidos, JSON_UNESCAPED_UNICODE);
        
        // Insere no banco
        $sql = "INSERT INTO pedidos (cliente, telefone, observacao, valor_total, itens_json, data_pedido, pago, entregue) 
                VALUES (?, ?, ?, ?, ?, NOW(), 0, 0)";
        $stmt = $pdo->prepare($sql);
        
        if($stmt->execute([$cli, $tel, $obs, $total, $json_itens])) {
            $id_pedido = $pdo->lastInsertId();
            $sucesso = true;
            
            // --- RECUPERADO: GERA O RESUMO VISUAL DOS ITENS ---
            $html_resumo = '<div class="card border-0 shadow-sm my-3"><ul class="list-group list-group-flush text-start">';
            foreach($itens_vendidos as $item) {
                // Formata o item: "2x Frango Inteiro"
                $html_resumo .= "
                <li class='list-group-item py-2'>
                    <i class='bi bi-check-circle-fill text-success me-2'></i> 
                    <span class='fw-bold'>{$item['qtd']}x</span> {$item['nome']}
                </li>";
            }
            $html_resumo .= '</ul></div>';
            // --------------------------------------------------

            $msg = "
            <div class='alert alert-success text-center shadow p-4'>
                <h2 class='alert-heading fw-bold'>✅ PEDIDO RECEBIDO!</h2>
                <p class='fs-5'>Obrigado, <b>$cli</b>!</p>
                <hr>
                
                <p class='mb-1 fw-bold text-muted'>RESUMO DO PEDIDO:</p>
                $html_resumo
                
                <hr>
                <p class='mb-0'>Sua senha é:</p>
                <h1 class='display-1 fw-bold text-dark mb-3'>#$id_pedido</h1>
                
                <div class='bg-white p-3 rounded border mb-4'>
                    <span class='text-muted text-uppercase small fw-bold'>Total a pagar na retirada:</span><br>
                    <b class='text-success display-6 fw-bold'>R$ " . number_format($total, 2, ',', '.') . "</b>
                </div>
                
                <a href='cliente.php' class='btn btn-outline-success w-100 py-3 fw-bold'>FAZER OUTRO PEDIDO</a>
            </div>";
        }
    } else {
        $msg = "<div class='alert alert-warning mb-3 shadow'>⚠️ Selecione pelo menos um item.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Faça seu Pedido - Mais Churrasco</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body { background-color: #f8f9fa; padding-bottom: 100px; }
        .section-header { color: white; padding: 10px 15px; border-radius: 5px; font-size: 1.1rem; text-transform: uppercase; font-weight: 800; margin-bottom: 15px; display: flex; align-items: center; gap: 10px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .sticky-bottom-bar { position: fixed; bottom: 0; left: 0; right: 0; background: white; padding: 10px; box-shadow: 0 -2px 10px rgba(0,0,0,0.1); z-index: 1000; }
        input[type=number]::-webkit-inner-spin-button { -webkit-appearance: none; margin: 0; }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark bg-dark mb-3 shadow">
        <div class="container justify-content-center">
            <a class="navbar-brand d-flex align-items-center m-0" href="#">
                <img src="img/logomais.png" alt="MC" height="40" class="me-2">
                <span class="fw-bold">Pedido Online</span>
            </a>
        </div>
    </nav>

    <div class="container">
        
        <?php if($sucesso): ?>
            <?= $msg ?>
        <?php else: ?>
            
            <?= $msg ?>
            <form method="POST" autocomplete="off" id="formPedido">
                <div class="row g-3">
                    
                    <div class="col-12">
                        <div class="card shadow-sm border-0">
                            <div class="card-body bg-white">
                                <h6 class="text-muted fw-bold mb-3"><i class="bi bi-person"></i> SEUS DADOS</h6>
                                <div class="mb-2">
                                    <input type="text" name="cliente" class="form-control form-control-lg bg-light" required placeholder="Seu Nome (Obrigatório)">
                                </div>
                                <div class="mb-2">
                                    <input type="tel" name="telefone" class="form-control" placeholder="Seu WhatsApp (Opcional)">
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php 
                    $ordemCategorias = [
                        'assados'    => [],
                        'guarnicoes' => [],
                        'extras'     => [],
                        'bebidas'    => [],
                        'outros'     => [] 
                    ];

                    foreach($produtos_db as $p) {
                        $cat = strtolower(trim($p['categoria']));
                        if (strpos($cat, 'assad') !== false) {
                            $ordemCategorias['assados'][] = $p;
                        } elseif (strpos($cat, 'guarni') !== false) {
                            $ordemCategorias['guarnicoes'][] = $p;
                        } elseif (strpos($cat, 'extra') !== false) {
                            $ordemCategorias['extras'][] = $p;
                        } elseif (strpos($cat, 'bebida') !== false) {
                            $ordemCategorias['bebidas'][] = $p;
                        } else {
                            $ordemCategorias['outros'][] = $p;
                        }
                    }

                    $visual = [
                        'assados'    => ['cor' => 'warning', 'icone' => 'bi-fire', 'titulo' => 'Assados'],
                        'guarnicoes' => ['cor' => 'danger',  'icone' => 'bi-basket', 'titulo' => 'Guarnições'],
                        'extras'     => ['cor' => 'info',    'icone' => 'bi-plus-circle', 'titulo' => 'Extras'],
                        'bebidas'    => ['cor' => 'success', 'icone' => 'bi-cup-straw', 'titulo' => 'Bebidas'],
                        'outros'     => ['cor' => 'secondary', 'icone' => 'bi-grid', 'titulo' => 'Outros']
                    ];
                    ?>

                    <?php foreach($ordemCategorias as $chave => $itens): ?>
                        <?php if(!empty($itens)): ?>
                            <?php 
                                $v = $visual[$chave];
                                $bgClass = 'bg-' . $v['cor'];
                                $textClass = ($v['cor'] == 'warning' || $v['cor'] == 'info') ? 'text-dark' : 'text-white';
                            ?>
                            
                            <div class="col-12">
                                <div class="section-header <?= $bgClass ?> <?= $textClass ?>">
                                    <i class="bi <?= $v['icone'] ?> fs-5"></i> <?= strtoupper($v['titulo']) ?>
                                </div>
                                
                                <?php foreach($itens as $prod): ?>
                                    <div class='d-flex justify-content-between align-items-center p-3 mb-2 border rounded shadow-sm bg-white'>
                                        <div class='lh-sm col-7'>
                                            <div class='fw-bold text-dark' style='font-size: 1rem;'><?= $prod['nome'] ?></div>
                                            <div style='font-size: 0.9rem;'>
                                                <span class='text-primary fw-bold'>R$ <?= number_format($prod['preco'], 2, ',', '.') ?></span>
                                            </div>
                                        </div>
                                        <div class='col-5 d-flex justify-content-end'>
                                            <div class='input-group' style='width: 120px;'>
                                                <button class='btn btn-outline-secondary fw-bold' type='button' onclick="updateQty(<?= $prod['id'] ?>, -1)">-</button>
                                                <input type='number' name='qtd_<?= $prod['id'] ?>' id='qtd_<?= $prod['id'] ?>' 
                                                       class='form-control text-center fw-bold border-secondary' 
                                                       style='padding:0; font-size: 1.2rem;' value='0' min='0' onchange='calcTotal()'>
                                                <button class='btn btn-outline-secondary fw-bold' type='button' onclick="updateQty(<?= $prod['id'] ?>, 1)">+</button>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>

                    <div class="col-12">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <label class="fw-bold small text-muted">OBSERVAÇÕES (Opcional)</label>
                                <textarea name="obs" class="form-control" rows="2" placeholder="Ex: Frango bem passado..."></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="sticky-bottom-bar">
                    <div class="container">
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <span class="text-muted small">Total a pagar:</span>
                            <span class="display-6 fw-bold text-success">R$ <span id="displayTotal">0,00</span></span>
                        </div>
                        <button type="submit" class="btn btn-danger w-100 btn-lg fw-bold shadow">ENVIAR PEDIDO</button>
                    </div>
                </div>
            </form>
        <?php endif; ?>
    </div>

    <script>
        const produtos = <?= json_encode($produtos_db) ?>;

        function updateQty(id, change) {
            let el = document.getElementById('qtd_' + id);
            if (el) {
                let currentVal = parseInt(el.value) || 0;
                let newVal = currentVal + change;
                if (newVal < 0) newVal = 0;
                el.value = newVal;
                calcTotal();
            }
        }

        function calcTotal() {
            let total = 0;
            produtos.forEach(function(p) {
                let el = document.getElementById('qtd_' + p.id);
                if (el) {
                    let qtd = parseInt(el.value) || 0;
                    if (qtd > 0) {
                        total += qtd * parseFloat(p.preco);
                    }
                }
            });
            document.getElementById('displayTotal').innerText = total.toFixed(2).replace('.', ',');
        }
    </script>
</body>
</html>