<?php
require 'conexao.php';

// --- AÇÃO: EXCLUIR PEDIDO ---
if (isset($_GET['excluir'])) {
    $id = intval($_GET['excluir']);
    $pdo->query("DELETE FROM pedidos WHERE id = $id");
    header("Location: admin_ped.php");
    exit;
}

// --- AÇÃO: ALTERAR STATUS PAGAMENTO ---
if (isset($_GET['pagar'])) {
    $id = intval($_GET['pagar']);
    $pdo->query("UPDATE pedidos SET pago = NOT pago WHERE id = $id");
    header("Location: admin_ped.php");
    exit;
}

// --- AÇÃO: ALTERAR STATUS ENTREGA (ADICIONADO AGORA) ---
if (isset($_GET['entregar'])) {
    $id = intval($_GET['entregar']);
    // Inverte: Se entregue(1) vira (0), se (0) vira (1)
    $pdo->query("UPDATE pedidos SET entregue = NOT entregue WHERE id = $id");
    header("Location: admin_ped.php");
    exit;
}

// Busca pedidos
$pedidos = $pdo->query("SELECT * FROM pedidos ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);

function verResumo($p) {
    if (!empty($p['itens_json'])) {
        $itens = json_decode($p['itens_json'], true);
        if (is_array($itens)) {
            $txt = [];
            foreach ($itens as $i) $txt[] = "{$i['qtd']}x {$i['nome']}";
            return implode(', ', $txt);
        }
    }
    // Fallback para legado...
    $txt = [];
    if(($p['q_inteiro'] ?? 0) > 0) $txt[] = "{$p['q_inteiro']}x Inteiro";
    if(($p['q_meio'] ?? 0) > 0)    $txt[] = "{$p['q_meio']}x Meio";
    return empty($txt) ? "Ver detalhes..." : implode(', ', $txt);
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Painel Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>body { background-color: #f8f9fa; }</style>
</head>
<body>

    <nav class="navbar navbar-dark bg-dark mb-4 shadow-sm p-3">
        <div class="container-fluid d-flex justify-content-between align-items-center">
            <div class="navbar-brand fw-bold fs-4">
                <img src="img/logomais.png" height="35" class="me-2"> ADMINISTRAÇÃO
            </div>
            <div>
                <a href="relatorio.php" target="_blank" class="btn btn-warning fw-bold me-2">
                    <i class="bi bi-file-earmark-text"></i> RELATORIO
                </a>
                <a href="painel.php" class="btn btn-warning fw-bold me-2">
                    <i class="bi bi-speedometer2"></i> DASHBOARD
                </a>
                <a href="produtos.php" class="btn btn-warning fw-bold me-2">
                    <i class="bi bi-box-seam"></i> PRODUTOS
                </a>
                <a href="pdv.php" class="btn btn-warning fw-bold me-2">
                    <i class="bi bi-cart"></i> PDV
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid px-4">
        <div class="card shadow border-0">
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-striped table-hover align-middle mb-0">
                        <thead class="table-dark">
                            <tr>
                                <th>#Senha</th>
                                <th>Cliente</th>
                                <th>Resumo do Pedido</th>
                                <th>Total</th>
                                <th>Pagamento</th>
                                <th>Status</th>
                                <th class="text-end">Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($pedidos as $p): ?>
                            <tr>
                                <td class="fw-bold text-center fs-5">#<?= str_pad($p['id'], 3, '0', STR_PAD_LEFT) ?></td>
                                <td>
                                    <span class="fw-bold text-uppercase"><?= $p['cliente'] ?></span>
                                    <?php if($p['telefone']): ?><br><small class="text-muted"><?= $p['telefone'] ?></small><?php endif; ?>
                                </td>
                                <td>
                                    <small class="text-secondary fw-bold"><?= verResumo($p) ?></small>
                                    <?php if($p['observacao']): ?>
                                        <div class="badge bg-warning text-dark d-block w-auto mt-1">Obs: <?= $p['observacao'] ?></div>
                                    <?php endif; ?>
                                </td>
                                <td class="fw-bold text-success">R$ <?= number_format($p['valor_total'], 2, ',', '.') ?></td>
                                <td>
                                    <a href="?pagar=<?= $p['id'] ?>" class="text-decoration-none">
                                        <?= $p['pago'] ? '<span class="badge bg-success">PAGO</span>' : '<span class="badge bg-danger">PENDENTE</span>' ?>
                                    </a>
                                </td>
                                <td>
                                    <a href="?entregar=<?= $p['id'] ?>" class="text-decoration-none">
                                        <?= $p['entregue'] ? '<span class="badge bg-secondary">ENTREGUE</span>' : '<span class="badge bg-primary spinner-grow-sm">PREPARANDO</span>' ?>
                                    </a>
                                </td>
                                <td class="text-end">
                                    
                                    <a href="?entregar=<?= $p['id'] ?>" class="btn btn-sm btn-success me-1" title="Marcar como Entregue">
                                        <i class="bi bi-check-lg"></i>
                                    </a>

                                    <a href="imprimir.php?id=<?= $p['id'] ?>" target="_blank" class="btn btn-sm btn-dark me-1" title="Imprimir Cupom">
                                        <i class="bi bi-printer-fill"></i>
                                    </a>

                                    <a href="?excluir=<?= $p['id'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Excluir?');" title="Excluir">
                                        <i class="bi bi-trash"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</body>
</html>