<?php
require 'conexao.php';

// --- AÇÕES (Adicionar, Editar, Excluir) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // EXCLUIR
    if (isset($_POST['excluir_id'])) {
        $stmt = $pdo->prepare("DELETE FROM produtos WHERE id = ?");
        $stmt->execute([$_POST['excluir_id']]);
    }
    
    // ADICIONAR NOVO
    elseif (isset($_POST['novo_nome'])) {
        $nome = $_POST['novo_nome'];
        $preco = str_replace(',', '.', $_POST['novo_preco']);
        $cat = $_POST['novo_cat'];
        
        if($nome && $preco) {
            $stmt = $pdo->prepare("INSERT INTO produtos (nome, preco, categoria) VALUES (?, ?, ?)");
            $stmt->execute([$nome, $preco, $cat]);
        }
    }
    
    // SALVAR ALTERAÇÕES EM MASSA
    elseif (isset($_POST['produtos'])) {
        foreach ($_POST['produtos'] as $id => $dados) {
            $nome = $dados['nome'];
            $preco = str_replace(',', '.', $dados['preco']);
            $cat = $dados['categoria']; // Agora permite mudar a categoria na edição
            
            $stmt = $pdo->prepare("UPDATE produtos SET nome = ?, preco = ?, categoria = ? WHERE id = ?");
            $stmt->execute([$nome, $preco, $cat, $id]);
        }
    }
    
    header("Location: produtos.php");
    exit;
}

// Busca produtos ordenados por categoria
$produtos = $pdo->query("SELECT * FROM produtos ORDER BY categoria ASC, nome ASC")->fetchAll(PDO::FETCH_ASSOC);

// Agrupa produtos para exibição organizada
$grupos = [];
foreach($produtos as $p) {
    $grupos[$p['categoria']][] = $p;
}

// Configuração de nomes bonitos para as categorias
$catLabels = [
    'assados' => ['nome' => 'Assados', 'cor' => 'warning'],
    'guarnicoes' => ['nome' => 'Guarnições', 'cor' => 'danger'],
    'extras' => ['nome' => 'Extras', 'cor' => 'info'],
    'bebidas' => ['nome' => 'Bebidas', 'cor' => 'success']
];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Produtos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</head>
<body class="bg-light">

    <div class="container py-4" style="max-width: 900px;">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h3 class="fw-bold"><i class="bi bi-box-seam"></i> Meus Produtos</h3>
            <a href="painel.php" class="btn btn-secondary">Voltar ao Admin</a>
        </div>

        <div class="card shadow-sm mb-5 border-primary border-2">
            <div class="card-header bg-primary text-white fw-bold">
                <i class="bi bi-plus-circle"></i> Adicionar Novo Produto
            </div>
            <div class="card-body bg-white">
                <form method="POST" class="row g-2">
                    <div class="col-md-5">
                        <label class="form-label small text-muted">Nome</label>
                        <input type="text" name="novo_nome" class="form-control" placeholder="Ex: Coca Cola 2L" required>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label small text-muted">Categoria</label>
                        <select name="novo_cat" class="form-select">
                            <option value="assados">Assados</option>
                            <option value="guarnicoes">Guarnições</option> <option value="extras">Extras</option>         <option value="bebidas">Bebidas</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small text-muted">Preço</label>
                        <input type="text" name="novo_preco" class="form-control" placeholder="0,00" required>
                    </div>
                    <div class="col-md-2 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100 fw-bold">SALVAR</button>
                    </div>
                </form>
            </div>
        </div>

        <form method="POST">
            <?php foreach($grupos as $catKey => $itens): ?>
                <?php 
                    $label = $catLabels[$catKey]['nome'] ?? strtoupper($catKey);
                    $cor = $catLabels[$catKey]['cor'] ?? 'secondary';
                ?>
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-<?= $cor ?> bg-opacity-25 fw-bold text-dark border-<?= $cor ?>">
                        <?= $label ?>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-hover mb-0 align-middle">
                            <tbody>
                                <?php foreach($itens as $p): ?>
                                <tr>
                                    <td>
                                        <input type="text" name="produtos[<?= $p['id'] ?>][nome]" class="form-control fw-bold border-0 bg-transparent" value="<?= $p['nome'] ?>">
                                    </td>
                                    
                                    <td width="140">
                                        <select name="produtos[<?= $p['id'] ?>][categoria]" class="form-select form-select-sm border-0 bg-light">
                                            <option value="assados" <?= $p['categoria']=='assados'?'selected':'' ?>>Assados</option>
                                            <option value="guarnicoes" <?= $p['categoria']=='guarnicoes'?'selected':'' ?>>Guarnições</option>
                                            <option value="extras" <?= $p['categoria']=='extras'?'selected':'' ?>>Extras</option>
                                            <option value="bebidas" <?= $p['categoria']=='bebidas'?'selected':'' ?>>Bebidas</option>
                                        </select>
                                    </td>

                                    <td width="120">
                                        <div class="input-group input-group-sm">
                                            <span class="input-group-text border-0 bg-transparent">R$</span>
                                            <input type="text" name="produtos[<?= $p['id'] ?>][preco]" class="form-control text-center fw-bold" value="<?= number_format($p['preco'], 2, ',', '') ?>">
                                        </div>
                                    </td>
                                    <td width="50" class="text-center">
                                        <button type="submit" name="excluir_id" value="<?= $p['id'] ?>" class="btn btn-link text-danger p-0" onclick="return confirm('Apagar este produto?')">
                                            <i class="bi bi-trash-fill fs-5"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endforeach; ?>

            <div class="sticky-bottom bg-white p-3 border-top shadow-lg">
                <button type="submit" class="btn btn-success w-100 fw-bold py-3">
                    <i class="bi bi-check-circle-fill"></i> SALVAR TODAS AS ALTERAÇÕES
                </button>
            </div>
        </form>
        <br><br>
    </div>

</body>
</html>