<?php
require 'conexao.php';

$msg = '';
$cupomFiscalHTML = '';
$sucesso = false;

// Busca produtos ativos
$stmt = $pdo->query("SELECT * FROM produtos ORDER BY categoria DESC, nome ASC");
$produtos_db = $stmt->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cli = $_POST['cliente'];
    $tel = $_POST['telefone'];
    $obs = $_POST['obs'];
    $status_pago = isset($_POST['status_pago']) ? 1 : 0;
    
    $itens_vendidos = [];
    $total = 0;

    foreach ($produtos_db as $prod) {
        $id = $prod['id'];
        $qtd = intval($_POST['qtd_' . $id] ?? 0);
        
        if ($qtd > 0) {
            $subtotal = $qtd * $prod['preco'];
            $total += $subtotal;
            
            $itens_vendidos[] = [
                'id' => $id,
                'nome' => $prod['nome'],
                'qtd' => $qtd,
                'preco' => $prod['preco'],
                'subtotal' => $subtotal
            ];
        }
    }

    if ($total > 0) {
        $json_itens = json_encode($itens_vendidos, JSON_UNESCAPED_UNICODE);

        $sql = "INSERT INTO pedidos (cliente, telefone, observacao, valor_total, itens_json, data_pedido, pago, entregue) 
                VALUES (?, ?, ?, ?, ?, NOW(), ?, 0)";
        $stmt = $pdo->prepare($sql);
        
        if($stmt->execute([$cli, $tel, $obs, $total, $json_itens, $status_pago])) {
            $id_pedido = $pdo->lastInsertId();
            $sucesso = true;
            
            // --- DADOS DO CUPOM ---
            $dataHora = date('d/m/Y H:i');
            $senhaFmt = str_pad($id_pedido, 3, '0', STR_PAD_LEFT);
            $nomeCli = strtoupper(substr($cli, 0, 25));
            $totalFmt = number_format($total, 2, ',', '.');
            $obsBlock = !empty($obs) ? "<div class='obs-box'>OBS: ".strtoupper($obs)."</div>" : "";
            $txtPagamento = ($status_pago == 1) ? "PAGAMENTO: [ PAGO ]" : "PAGAMENTO: [ PENDENTE ]";

            // Gera linhas da tabela
            $linhasItens = "";
            foreach ($itens_vendidos as $item) {
                $subFmt = number_format($item['subtotal'], 2, ',', '.');
                $linhasItens .= "
                <tr>
                    <td class='col-qtd'>{$item['qtd']}</td>
                    <td class='col-item'>{$item['nome']}</td>
                    <td class='col-price'>$subFmt</td>
                </tr>";
            }

            // HTML DO CUPOM (Escondido na tela normal)
            $cupomFiscalHTML = "
            <div id='area-impressao'>
                <div class='cupom-wrapper'>
                    <div class='logo-container'>
                        <img src='img/logomais.png' alt='MC' class='logo-img'>
                    </div>

                    <div class='header'>
                        <h2 style='margin:0; font-size: 22px;'>SENHA: $senhaFmt</h2>
                        <span style='font-size: 11px;'>$dataHora</span>
                    </div>

                    <div class='cli-info'>
                        $nomeCli<br>" . ($tel ? "TEL: $tel" : "") . "
                    </div>

                    <table class='check-table'>
                        <thead>
                            <tr>
                                <th class='col-qtd'>QTD</th>
                                <th class='col-item'>ITEM</th>
                                <th class='col-price'>$$</th>
                            </tr>
                        </thead>
                        <tbody>
                            $linhasItens
                        </tbody>
                    </table>

                    <div class='total-area'>
                        TOTAL: R$ $totalFmt
                    </div>
                    
                    <div style='text-align: right; font-size: 12px; margin-top: 5px; font-weight: bold;'>
                        $txtPagamento
                    </div>

                    $obsBlock
                    
                    <div style='text-align: center; margin-top: 15px; font-size: 10px;'>
                        *** OBRIGADO PELA PREFERÊNCIA ***
                    </div>
                </div>
            </div>";

            // Botão de Imprimir corrigido (type=button)
            $msg = "<div class='alert alert-success fw-bold text-center mb-3 shadow-sm'>
                <h4 class='alert-heading'>✅ Pedido #$id_pedido Confirmado!</h4>
                <p class='fs-4 text-success'>Total: R$ $totalFmt</p>
                <button type='button' onclick='imprimirCupom()' class='btn btn-dark btn-lg w-100 shadow py-3 mb-2'>
                    <i class='bi bi-printer-fill'></i> IMPRIMIR CUPOM
                </button>
                <a href='pdv.php' class='btn btn-outline-secondary btn-sm'>Novo Pedido</a>
            </div>";
        }
    } else {
        $msg = "<div class='alert alert-warning mb-3'>⚠️ Selecione algum item.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PDV - Mais Churrasco</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        /* ESTILOS DA TELA NORMAL */
        body { background-color: #e9ecef; }
        .section-header { background: #495057; color: white; padding: 5px 10px; border-radius: 4px; font-size: 0.9rem; text-transform: uppercase; font-weight: bold; margin-bottom: 10px;}
        input[type=number]::-webkit-inner-spin-button { -webkit-appearance: none; margin: 0; }
        #resumoCarrinho { max-height: 200px; overflow-y: auto; font-size: 0.9rem; }
        
        /* Oculta o cupom na tela do navegador */
        #area-impressao { display: none; } 

        /* --- ESTILOS DE IMPRESSÃO (CSS SEGURO) --- */
        @media print {
            /* 1. Esconde a interface do usuário (Navbar, form, alertas) */
            .no-print, nav, form, .alert, .sticky-bottom-bar, .container > .row { 
                display: none !important; 
            }
            
            /* 2. Configura a página */
            body, html { 
                background: #fff !important; 
                margin: 0 !important; 
                padding: 0 !important; 
            }

            /* 3. Exibe o cupom */
            #area-impressao { 
                display: block !important; 
                position: absolute; 
                left: 0; 
                top: 0; 
                width: 72mm; /* Largura padrão */
                font-family: 'Arial', sans-serif;
                font-size: 12px;
                color: #000;
            }

            .cupom-wrapper { width: 100%; padding: 0 2px; }

            /* Cabeçalho */
            .logo-container { text-align: center; border-bottom: 3px solid #000; padding-bottom: 5px; margin-bottom: 10px; }
            .logo-img { max-width: 100px; height: auto; display: block; margin: 0 auto; }
            
            .header { text-align: center; border-bottom: 2px solid #000; padding-bottom: 5px; margin-bottom: 10px; }
            .cli-info { font-weight: bold; border-bottom: 1px dashed #000; padding-bottom: 5px; margin-bottom: 5px; font-size: 13px; line-height: 1.2; }

            /* Tabela Fixa */
            .check-table { width: 100%; border-collapse: collapse; table-layout: fixed; }
            .check-table th { border-bottom: 1px solid #000; text-align: left; font-size: 10px; padding: 2px 0; }
            .check-table td { border-bottom: 1px dotted #999; padding: 4px 0; vertical-align: top; }
            
            /* Colunas Alinhadas */
            .col-qtd { width: 15%; text-align: center; font-weight: 800; }
            .col-item { width: 55%; text-align: left; }
            .col-price { width: 30%; text-align: right !important; white-space: nowrap; }
            
            /* Alinha o cabeçalho '$$' também a direita */
            .check-table th:last-child { text-align: right !important; }

            /* Rodapé */
            .total-area { border-top: 2px solid #000; font-size: 18px; font-weight: 800; text-align: right; margin-top: 10px; padding-top: 5px; }
            .obs-box { border: 2px solid #000; background: #eee !important; padding: 5px; text-align: center; font-weight: bold; margin-top: 10px; -webkit-print-color-adjust: exact; }
            
            @page { margin: 0; size: auto; }
        }
    </style>
</head>
<body>
    
    <?= $cupomFiscalHTML ?>

    <nav class="navbar navbar-dark bg-dark mb-4 shadow-sm py-2 no-print">
        <div class="container-fluid">
            <a class="navbar-brand d-flex align-items-center" href="#">
                <img src="img/logomais.png" alt="Mais Churrasco" height="50" class="me-2">
            </a>
            <a href="index.php" class="btn btn-outline-light btn-sm">Admin</a>
        </div>
    </nav>

    <div class="container-fluid px-4 pb-5 no-print">
        <?= $msg ?>
        
        <?php if(!$sucesso): ?>
        <form method="POST" autocomplete="off">
            <div class="row g-4">
                <div class="col-lg-8 main-area">
                    <div class="row g-3">
                        
                        <?php 
                        $porCategoria = [];
                        foreach($produtos_db as $p) {
                            $cat = $p['categoria'] ?: 'Outros';
                            $porCategoria[$cat][] = $p;
                        }
                        $ordem = ['assados', 'guarnicoes', 'extras', 'bebidas', 'Outros'];
                        $cores = ['assados' => 'warning', 'guarnicoes' => 'danger', 'extras' => 'info', 'bebidas' => 'success', 'Outros' => 'secondary'];
                        ?>

                        <?php foreach($ordem as $catNome): ?>
                            <?php if(isset($porCategoria[$catNome])): ?>
                                <?php $cor = $cores[$catNome] ?? 'secondary'; ?>
                                <div class="col-12 col-md-6">
                                    <div class="card shadow-sm h-100">
                                        <div class="card-body">
                                            <div class="section-header bg-<?= $cor ?> text-dark">
                                                <?= strtoupper($catNome) ?>
                                            </div>
                                            
                                            <?php foreach($porCategoria[$catNome] as $prod): ?>
                                                <div class='d-flex justify-content-between align-items-center p-2 mb-2 border rounded shadow-sm bg-white'>
                                                    <div class='lh-sm col-7'>
                                                        <div class='fw-bold text-dark' style='font-size: 0.95rem;'><?= $prod['nome'] ?></div>
                                                        <div style='font-size: 0.85rem;'>
                                                            <span class='text-primary fw-bold'>R$ <?= number_format($prod['preco'], 2, ',', '.') ?></span>
                                                        </div>
                                                    </div>
                                                    <div class='col-5 d-flex justify-content-end'>
                                                        <div class='input-group input-group-sm' style='width: 110px;'>
                                                            <button class='btn btn-outline-secondary' type='button' onclick="updateQty(<?= $prod['id'] ?>, -1)"><i class='bi bi-dash-lg'></i></button>
                                                            <input type='number' name='qtd_<?= $prod['id'] ?>' id='qtd_<?= $prod['id'] ?>' 
                                                                   class='form-control text-center fw-bold border-secondary' 
                                                                   style='padding: 0; font-size: 1.1rem;' value='0' min='0' 
                                                                   onchange="calcTotal()">
                                                            <button class='btn btn-outline-secondary' type='button' onclick="updateQty(<?= $prod['id'] ?>, 1)"><i class='bi bi-plus-lg'></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>

                    </div>
                </div>
                
                <div class="col-lg-4">
                    <div class="card shadow border-0 sticky-checkout">
                        <div class="card-header bg-danger text-white text-center py-3">
                            <h5 class="m-0 fw-bold">RESUMO DO PEDIDO</h5>
                        </div>
                        <div class="card-body bg-white p-3">
                            <div class="bg-light rounded p-2 mb-3 border">
                                <small class="text-muted fw-bold d-block mb-2">ITENS SELECIONADOS:</small>
                                <div id="resumoCarrinho">
                                    <p class="text-muted small fst-italic mb-0 text-center py-2">Nenhum item selecionado.</p>
                                </div>
                            </div>
                            <div class="mb-2">
                                <input type="text" name="cliente" class="form-control" required placeholder="Nome do Cliente" autofocus>
                            </div>
                            <div class="mb-2">
                                <input type="tel" name="telefone" class="form-control" placeholder="WhatsApp (Opcional)">
                            </div>
                            <div class="mb-3">
                                <textarea name="obs" class="form-control" rows="1" placeholder="Obs..."></textarea>
                            </div>
                            <hr class="my-2">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <span class="fw-bold text-muted">TOTAL:</span>
                                <span class="display-6 fw-bold text-success">R$ <span id="displayTotal">0,00</span></span>
                            </div>
                            
                            <div class="form-check form-switch mb-3 p-2 border rounded bg-light d-flex align-items-center justify-content-between">
                                <label class="form-check-label fw-bold ms-2" for="switchPago" style="cursor:pointer">JÁ ESTÁ PAGO?</label>
                                <input class="form-check-input me-2" type="checkbox" name="status_pago" id="switchPago" style="width: 50px; height: 25px; cursor:pointer">
                            </div>

                            <button type="submit" class="btn btn-danger w-100 fw-bold shadow-sm py-2">CONFIRMAR VENDA</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <?php else: ?>
            <div class="text-center mt-4 no-print">
                <a href="pdv.php" class="btn btn-outline-secondary">Novo Pedido</a>
            </div>
        <?php endif; ?>
    </div>
    
    <script>
        const produtos = <?= json_encode($produtos_db) ?>;

        function updateQty(id, change) {
            let el = document.getElementById('qtd_' + id);
            if (el) {
                let currentVal = parseInt(el.value) || 0;
                let newVal = currentVal + change;
                if (newVal < 0) newVal = 0;
                el.value = newVal;
                calcTotal();
            }
        }

        function calcTotal() {
            let total = 0;
            let resumoHTML = '';
            let hasItems = false;

            produtos.forEach(function(p) {
                let el = document.getElementById('qtd_' + p.id);
                if (el) {
                    let qtd = parseInt(el.value) || 0;
                    if (qtd > 0) {
                        hasItems = true;
                        let subtotal = qtd * parseFloat(p.preco);
                        total += subtotal;
                        
                        resumoHTML += `
                            <div class="d-flex justify-content-between align-items-center border-bottom border-light py-1">
                                <div>
                                    <span class="fw-bold text-dark">${qtd}x</span> 
                                    <span class="text-secondary">${p.nome}</span>
                                </div>
                                <span class="fw-bold text-dark">R$ ${subtotal.toFixed(2).replace('.', ',')}</span>
                            </div>
                        `;
                    }
                }
            });

            document.getElementById('displayTotal').innerText = total.toFixed(2).replace('.', ',');
            const divResumo = document.getElementById('resumoCarrinho');
            
            if (hasItems) {
                divResumo.innerHTML = resumoHTML;
            } else {
                divResumo.innerHTML = '<p class="text-muted small fst-italic mb-0 text-center py-2">Nenhum item selecionado.</p>';
            }
        }

        // Função JavaScript específica para chamar a impressão
        function imprimirCupom() {
            window.print();
        }
    </script>
</body>
</html>