<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mais Churrasco - Sistema Profissional</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        /* --- ESTILO VISUAL MODERNO --- */
        body { background-color: #f4f6f8; font-family: 'Segoe UI', 'Roboto', sans-serif; padding-bottom: 100px; color: #333; }
        
        /* Paleta de Cores Harmonizada com a Logo */
        :root {
            --brand-red: #c00d0d;       /* Vermelho da Logo */
            --brand-dark: #2c0b0b;      /* Tom escuro para contrastes */
            --accent-purple: #9b8bf4;   /* Roxo suave para detalhes secundários */
        }

        /* Navbar Limpa e Moderna */
        .navbar { 
            background: #ffffff; 
            box-shadow: 0 4px 20px rgba(0,0,0,0.04); 
            padding: 12px 0; 
            border-bottom: 1px solid #eee;
        }
        
        .logo-img {
            height: 55px; /* Tamanho ajustado da logo */
            width: auto;
            transition: transform 0.2s;
        }
        .logo-img:hover { transform: scale(1.02); }

        /* Cards com efeito de flutuação suave */
        .custom-card { 
            border: none; 
            border-radius: 16px; 
            box-shadow: 0 2px 12px rgba(0,0,0,0.02); 
            background: #fff; 
            margin-bottom: 24px; 
            padding: 30px; 
            border: 1px solid #f0f0f0;
        }

        /* Inputs Modernos */
        .form-control-custom { 
            border: 2px solid #f0f2f5; 
            border-radius: 10px; 
            padding: 12px 15px; 
            background: #fcfcfc; 
            font-size: 0.95rem;
            transition: all 0.3s ease;
        }
        .form-control-custom:focus { 
            border-color: var(--brand-red); 
            background: #fff; 
            box-shadow: 0 0 0 4px rgba(192, 13, 13, 0.1); 
        }

        /* Botões Estilizados */
        .btn { border-radius: 10px; font-weight: 600; padding: 10px 20px; transition: 0.2s; }
        
        .btn-add-item { 
            background: linear-gradient(45deg, var(--brand-red), #e63939); 
            color: white; 
            width: 100%; 
            border: none; 
            padding: 15px; 
            margin-top: 15px; 
            letter-spacing: 0.5px;
            box-shadow: 0 4px 15px rgba(192, 13, 13, 0.2);
        }
        .btn-add-item:hover { background: var(--brand-dark); color: white; transform: translateY(-1px); }

        /* Toggle Unidade */
        .toggle-btn { flex: 1; border: 1px solid #eee; background: white; color: #888; margin: 0 2px; border-radius: 8px; }
        .toggle-btn:hover { background: #fafafa; }
        .toggle-btn.active { 
            background: #fff0f0; 
            color: var(--brand-red); 
            border: 1px solid var(--brand-red); 
            font-weight: bold;
        }

        /* Footer */
        .footer-bar { 
            position: fixed; bottom: 0; left: 0; width: 100%; 
            background: rgba(255, 255, 255, 0.95); 
            backdrop-filter: blur(10px);
            border-top: 1px solid #eee; 
            padding: 15px 30px; 
            display: flex; justify-content: space-between; align-items: center; z-index: 1000; 
            box-shadow: 0 -4px 20px rgba(0,0,0,0.03);
        }
        .total-label { font-size: 0.8rem; text-transform: uppercase; letter-spacing: 1px; color: #888; margin-bottom: 2px; }
        .total-value { font-size: 1.8rem; font-weight: 800; color: var(--brand-red); line-height: 1; }
        
        /* Botões de Ação Footer */
        .btn-action { padding: 12px 25px; border: none; }
        .btn-text { background: #f4f6f8; color: #555; margin-right: 10px; }
        .btn-text:hover { background: #e9ecef; color: #333; }
        .btn-pdf { background: #333; color: white; }
        .btn-pdf:hover { background: #000; }

        .area-importacao { width: 100%; height: 200px; padding: 15px; border: 1px solid #ccc; border-radius: 12px; font-family: monospace; font-size: 13px; background: #f9f9f9; }
    </style>
</head>
<body>

<nav class="navbar mb-4">
    <div class="container d-flex justify-content-between align-items-center">
        <div class="d-flex align-items-center">
            <img src="https://mgatv.com.br/orca/logomais.webp" alt="Mais Churrasco" class="logo-img">
        </div>

        <div class="d-flex gap-2">
            <button type="button" class="btn btn-outline-danger border-2 btn-sm" onclick="novoOrcamento()" title="Novo Orçamento">
                <i class="fas fa-plus"></i> <span class="d-none d-md-inline ms-1">Novo</span>
            </button>
            <button type="button" class="btn btn-light border btn-sm text-secondary" onclick="abrirModalLista()" title="Abrir Salvos">
                <i class="far fa-folder-open"></i> <span class="d-none d-md-inline ms-1">Salvos</span>
            </button>
            <button type="button" class="btn btn-light border btn-sm text-secondary" onclick="abrirModalPDFs()" title="Histórico">
                <i class="fas fa-history"></i> <span class="d-none d-md-inline ms-1">PDFs</span>
            </button>
            <button type="button" class="btn btn-light border btn-sm text-secondary" onclick="abrirModalProdutos()" title="Catálogo">
                <i class="fas fa-box"></i> <span class="d-none d-md-inline ms-1">Produtos</span>
            </button>
        </div>
    </div>
</nav>

<div class="container">
    <form id="form-orcamento" action="gerar_pdf.php" method="POST" target="_blank">
        
        <div class="custom-card">
            <div class="row align-items-end g-3">
                <div class="col-md-9">
                    <label class="form-label text-muted fw-bold small ms-1">CLIENTE / NOME DO EVENTO</label>
                    <div class="input-group">
                        <span class="input-group-text bg-white border-end-0 border-2" style="border-radius: 10px 0 0 10px; border-color: #f0f2f5;"><i class="far fa-user text-muted"></i></span>
                        <input type="text" name="cliente_nome" id="cliente_nome" class="form-control form-control-custom border-start-0 ps-1" style="border-radius: 0 10px 10px 0;" placeholder="Ex: Aniversário do Pedro" required>
                    </div>
                    <input type="hidden" name="data_orcamento" id="data_orcamento">
                </div>
                <div class="col-md-3">
                    <button type="button" class="btn btn-light border w-100 py-2 fw-bold text-secondary" onclick="salvarNoServidor()">
                        <i class="far fa-save me-2"></i> Salvar Rascunho
                    </button>
                </div>
            </div>
        </div>

        <div class="custom-card border-top-danger">
            <h5 class="fw-bold mb-4 d-flex align-items-center text-dark">
                <span class="badge bg-danger rounded-circle p-2 me-2"><i class="fas fa-plus"></i></span> 
                Adicionar Novo Item
            </h5>
            
            <div class="row g-3">
                <div class="col-md-5">
                    <label class="form-label text-muted fw-bold small ms-1">PRODUTO</label>
                    <input type="text" id="novo_nome" class="form-control form-control-custom" list="listaSugestoes" oninput="buscarPrecoAutomatico()" placeholder="Digite para buscar...">
                    <datalist id="listaSugestoes"></datalist>
                </div>
                
                <div class="col-md-3">
                    <label class="form-label text-muted fw-bold small ms-1">MEDIDA</label>
                    <div class="d-flex bg-light p-1 rounded-3 border">
                        <button type="button" class="btn toggle-btn btn-sm active" onclick="setUnidade('un', this)">Un</button>
                        <button type="button" class="btn toggle-btn btn-sm" onclick="setUnidade('kg', this)">Kg</button>
                        <input type="hidden" id="novo_unidade" value="un">
                    </div>
                </div>

                <div class="col-md-2">
                    <label class="form-label text-muted fw-bold small ms-1">QTD</label>
                    <input type="number" id="novo_qtd" class="form-control form-control-custom text-center fw-bold" value="1" step="0.01" oninput="atualizarPreviewTotal()">
                </div>
                
                <div class="col-md-2">
                    <label class="form-label text-muted fw-bold small ms-1">PREÇO (R$)</label>
                    <input type="text" id="novo_valor" class="form-control form-control-custom text-end" placeholder="0,00" onkeyup="formatarMoeda(this); atualizarPreviewTotal()">
                </div>
            </div>

            <div class="row mt-3 align-items-center">
                <div class="col-md-8">
                    <button type="button" class="btn btn-add-item shadow-sm" onclick="adicionarItem()">
                        ADICIONAR ITEM <i class="fas fa-arrow-right ms-2"></i>
                    </button>
                </div>
                <div class="col-md-4 text-end">
                    <small class="text-muted d-block fw-bold">TOTAL DO ITEM</small>
                    <input type="text" id="novo_total_preview" class="form-control-plaintext text-end fs-4 fw-bold text-danger" value="R$ 0,00" readonly>
                </div>
            </div>
        </div>

        <div class="mb-5">
            <div id="lista-vazia" class="text-center py-5">
                <i class="fas fa-shopping-basket fa-3x text-light mb-3" style="color: #e0e0e0 !important;"></i>
                <p class="text-muted fw-bold">Sua lista está vazia</p>
            </div>
            
            <div class="card shadow-sm border-0 overflow-hidden" id="tabela-container" style="display:none; border-radius: 16px;">
                <table class="table table-hover mb-0 align-middle" id="tabela-visual">
                    <thead class="bg-light text-secondary text-uppercase small">
                        <tr>
                            <th class="ps-4 py-3">Produto</th>
                            <th class="text-center">Qtd</th>
                            <th class="text-end">Unit.</th>
                            <th class="text-end pe-4">Total</th>
                            <th width="50"></th>
                        </tr>
                    </thead>
                    <tbody id="corpo-tabela" class="bg-white"></tbody>
                </table>
            </div>

            <div class="custom-card mt-3 bg-white" id="box-totais" style="display:none;">
                <div class="row justify-content-end">
                    <div class="col-md-5">
                        <div class="d-flex justify-content-between mb-2 text-secondary">
                            <span>Subtotal:</span> <strong id="display-subtotal" class="text-dark">R$ 0,00</strong>
                        </div>
                        <div class="d-flex justify-content-between mb-2 align-items-center">
                            <span class="text-secondary"><i class="fas fa-truck me-1"></i> Frete:</span> 
                            <input type="text" id="input_frete" class="form-control form-control-sm w-25 text-end bg-light border-0" onkeyup="formatarMoeda(this)" onblur="calcularGeral()" placeholder="0,00">
                        </div>
                        <div class="d-flex justify-content-between align-items-center">
                            <span class="text-secondary"><i class="fas fa-tag me-1"></i> Desconto:</span> 
                            <div class="input-group input-group-sm w-50">
                                <select id="select_tipo_desconto" class="form-select bg-light border-0 text-secondary" style="max-width:60px" onchange="calcularGeral()"><option value="valor">R$</option><option value="porcento">%</option></select>
                                <input type="text" id="input_desconto" class="form-control text-end bg-light border-0" onkeyup="formatarMoeda(this)" onblur="calcularGeral()" placeholder="0,00">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div id="area-inputs-ocultos"></div>
            <input type="hidden" name="subtotal_post" id="subtotal_post" value="0">
            <input type="hidden" name="frete_post" id="frete_post" value="0">
            <input type="hidden" name="desconto_valor_post" id="desconto_valor_post" value="0">
            <input type="hidden" name="desconto_tipo_post" id="desconto_tipo_post" value="valor">
            <input type="hidden" name="total_final_post" id="total_final_post" value="0">
        </div>

        <div class="footer-bar">
            <div>
                <div class="total-label">TOTAL A PAGAR</div>
                <div class="total-value" id="footer-total">R$ 0,00</div>
            </div>
            <div class="d-flex gap-2">
                <button type="button" class="btn btn-action btn-text" onclick="copiarZap()">
                    <i class="fab fa-whatsapp fs-5"></i>
                </button>
                <button type="submit" class="btn btn-action btn-pdf shadow-sm">
                    <i class="fas fa-file-pdf me-2"></i> BAIXAR PDF
                </button>
            </div>
        </div>
    </form>
</div>

<div class="modal fade" id="modalProdutos" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-light">
                <h5 class="modal-title fw-bold text-secondary">Catálogo de Produtos</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body p-4">
                <div class="alert alert-light border d-flex gap-3 align-items-center">
                    <i class="fas fa-info-circle text-primary fs-4"></i>
                    <small class="text-muted">Cole sua lista abaixo (um por linha) no formato:<br><b>Nome do Produto; Preço</b></small>
                </div>
                <textarea id="textoImportacao" class="area-importacao" placeholder="Picanha Angus; 129.90"></textarea>
                <div class="mt-3 text-end">
                    <button class="btn btn-dark" onclick="salvarCatalogo()"><i class="fas fa-save me-2"></i> Salvar Importação</button>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalLista" tabindex="-1"><div class="modal-dialog"><div class="modal-content border-0 shadow"><div class="modal-header"><h5 class="modal-title fw-bold">Meus Rascunhos</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body p-0"><div class="list-group list-group-flush" id="lista-arquivos"></div></div></div></div></div>

<div class="modal fade" id="modalPDFs" tabindex="-1"><div class="modal-dialog"><div class="modal-content border-0 shadow"><div class="modal-header"><h5 class="modal-title fw-bold">Histórico de PDFs</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body p-0"><div class="list-group list-group-flush" id="lista-pdfs"></div></div></div></div></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    window.onload = function() { document.getElementById('data_orcamento').value = new Date().toLocaleDateString('pt-BR'); carregarProdutos(); };
    let itens = [], catalogoProdutos = [];

    document.addEventListener("keydown", function(e) {
        if (e.key === "Enter") {
            if(e.target.tagName === "INPUT" || e.target.tagName === "SELECT") {
                e.preventDefault();
                let id = e.target.id;
                if(id==="novo_nome") { document.getElementById('novo_qtd').focus(); document.getElementById('novo_qtd').select(); }
                else if(id==="novo_qtd") { document.getElementById('novo_valor').focus(); }
                else if(id==="novo_valor") { adicionarItem(); }
            }
        }
    });

    function formatarMoeda(el) {
        let v = el.value.replace(/\D/g, ""); if (v === "") { el.value = ""; return; }
        v = (v / 100).toFixed(2) + ""; v = v.replace(".", ","); v = v.replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1."); el.value = "R$ " + v;
    }
    function lerDinheiro(s) { if(!s) return 0; let l = s.replace(/[^\d,]/g, '').replace(',', '.'); return parseFloat(l) || 0; }
    
    function atualizarPreviewTotal() {
        let qtd = parseFloat(document.getElementById('novo_qtd').value) || 0;
        let valor = lerDinheiro(document.getElementById('novo_valor').value);
        let total = qtd * valor;
        document.getElementById('novo_total_preview').value = "R$ " + total.toLocaleString('pt-BR', {minimumFractionDigits: 2});
    }

    function carregarProdutos() { fetch('api.php?acao=listar_produtos').then(r=>r.json()).then(d=>{ catalogoProdutos=d; atualizarDatalist(); }); }
    function atualizarDatalist() {
        let dl = document.getElementById('listaSugestoes'); dl.innerHTML = '';
        catalogoProdutos.forEach(p => { let op = document.createElement('option'); op.value = p.nome; dl.appendChild(op); });
    }
    function buscarPrecoAutomatico() {
        let nome = document.getElementById('novo_nome').value;
        let prod = catalogoProdutos.find(p => p.nome.toLowerCase() === nome.toLowerCase());
        if (prod) {
            let visual = (parseFloat(prod.preco)*100).toFixed(0);
            let campo = document.getElementById('novo_valor');
            campo.value = visual; formatarMoeda(campo);
            if(prod.unidade) {
                document.getElementById('novo_unidade').value = prod.unidade;
                // Atualiza botões visuais
                document.querySelectorAll('.toggle-btn').forEach(b => b.classList.remove('active'));
                // Lógica simples para os botões padrão, se for personalizado não ativa nenhum
                if(prod.unidade === 'un') document.querySelectorAll('.toggle-btn')[0].classList.add('active');
                if(prod.unidade === 'kg') document.querySelectorAll('.toggle-btn')[1].classList.add('active');
            }
            atualizarPreviewTotal();
        }
    }
    function abrirModalProdutos() {
        let t = ""; catalogoProdutos.forEach(p => t+=`${p.nome}; ${p.preco}${p.unidade?'; '+p.unidade:''}\n`);
        if(catalogoProdutos.length>0) document.getElementById('textoImportacao').value = t;
        new bootstrap.Modal(document.getElementById('modalProdutos')).show();
    }
    function salvarCatalogo() {
        let linhas = document.getElementById('textoImportacao').value.split('\n');
        let novos = [];
        linhas.forEach(l => {
            if(l.trim()!=="") {
                let p = l.split(';');
                if(p.length>=2) {
                    let pr = parseFloat(p[1].trim().replace(',','.'));
                    if(p[0] && !isNaN(pr)) novos.push({nome:p[0].trim(), preco:pr, unidade:p[2]?p[2].trim():'un'});
                }
            }
        });
        fetch('api.php?acao=salvar_produtos', {method:'POST', body:JSON.stringify(novos)}).then(r=>r.json()).then(d=>{ alert(d.msg); carregarProdutos(); bootstrap.Modal.getInstance(document.getElementById('modalProdutos')).hide(); });
    }

    function novoOrcamento() { if(itens.length>0 && !confirm("Novo?")) return; itens=[]; document.getElementById('cliente_nome').value=''; document.getElementById('input_frete').value=''; document.getElementById('input_desconto').value=''; renderizarLista(); }
    function salvarNoServidor() {
        let cli = document.getElementById('cliente_nome').value; if(!cli || !itens.length) return alert("Preencha dados.");
        let p = { cliente:cli, itens:itens, frete:document.getElementById('input_frete').value, desconto_val:document.getElementById('input_desconto').value, desconto_tipo:document.getElementById('select_tipo_desconto').value, total_final:document.getElementById('total_final_post').value };
        fetch('api.php?acao=salvar', {method:'POST', body:JSON.stringify(p)}).then(r=>r.json()).then(d=>alert(d.msg));
    }
    function abrirModalLista() { fetch('api.php?acao=listar').then(r=>r.json()).then(d=>{ let h=d.length?'':'<p class="text-center text-muted py-3">Nenhum rascunho salvo.</p>'; d.forEach(a=>h+=`<button class="list-group-item list-group-item-action py-3" onclick="carregar('${a.arquivo}')"><div class="d-flex justify-content-between fw-bold"><span>${a.cliente}</span><span class="text-danger">R$ ${parseFloat(a.total).toLocaleString('pt-BR',{minimumFractionDigits:2})}</span></div><small class="text-muted"><i class="far fa-clock me-1"></i> ${a.data}</small></button>`); document.getElementById('lista-arquivos').innerHTML=h; new bootstrap.Modal(document.getElementById('modalLista')).show(); }); }
    function carregar(arq) { fetch(`api.php?acao=carregar&arquivo=${arq}`).then(r=>r.json()).then(d=>{ document.getElementById('cliente_nome').value=d.cliente; document.getElementById('input_frete').value=d.frete; document.getElementById('input_desconto').value=d.desconto_val; document.getElementById('select_tipo_desconto').value=d.desconto_tipo; itens=d.itens||[]; renderizarLista(); bootstrap.Modal.getInstance(document.getElementById('modalLista')).hide(); }); }
    function abrirModalPDFs() { fetch('api.php?acao=listar_pdfs').then(r=>r.json()).then(d=>{ let h=d.length?'':'<p class="text-center text-muted py-3">Histórico vazio.</p>'; d.forEach(p=>h+=`<div class="list-group-item d-flex justify-content-between align-items-center py-3"><div><div class="fw-bold text-dark text-truncate" style="max-width: 250px;">${p.nome_arquivo}</div><small class="text-muted">${p.data}</small></div><a href="orcamentos_pdfs/${p.nome_arquivo}" target="_blank" class="btn btn-sm btn-outline-danger"><i class="fas fa-download"></i></a></div>`); document.getElementById('lista-pdfs').innerHTML=h; new bootstrap.Modal(document.getElementById('modalPDFs')).show(); }); }

    function setUnidade(t,b) { document.getElementById('novo_unidade').value=t; document.querySelectorAll('.toggle-btn').forEach(x=>x.classList.remove('active')); b.classList.add('active'); }
    
    function adicionarItem() {
        let nome = document.getElementById('novo_nome').value; let qtd = parseFloat(document.getElementById('novo_qtd').value); let valInput = document.getElementById('novo_valor').value; let valor = lerDinheiro(valInput); let un = document.getElementById('novo_unidade').value.trim();
        if(!nome || isNaN(qtd) || valor === 0) return alert("Preencha corretamente.");
        itens.push({ nome, qtd, valor, un, total: qtd * valor }); renderizarLista();
        document.getElementById('novo_nome').value=''; document.getElementById('novo_valor').value=''; document.getElementById('novo_qtd').value='1'; document.getElementById('novo_total_preview').value='R$ 0,00'; document.getElementById('novo_nome').focus();
    }
    function renderizarLista() {
        let tb = document.getElementById('corpo-tabela'); let inp = document.getElementById('area-inputs-ocultos'); tb.innerHTML=''; inp.innerHTML='';
        let d = itens.length ? 'block' : 'none'; 
        document.getElementById('tabela-container').style.display=d; 
        document.getElementById('box-totais').style.display=d; 
        document.getElementById('lista-vazia').style.display=itens.length?'none':'block';

        let soma = 0;
        itens.forEach((i, idx) => {
            soma += i.total; let u = i.un ? i.un : '';
            tb.innerHTML += `<tr><td class="ps-4 fw-bold text-dark">${i.nome}</td><td class="text-center"><span class="badge bg-light text-dark border">${i.qtd} ${u}</span></td><td class="text-end text-muted">R$ ${i.valor.toLocaleString('pt-BR',{minimumFractionDigits:2})}</td><td class="text-end fw-bold pe-4 text-dark">R$ ${i.total.toLocaleString('pt-BR',{minimumFractionDigits:2})}</td><td class="text-center"><button type="button" class="btn btn-sm text-danger hover-scale" onclick="remover(${idx})"><i class="fas fa-trash-alt"></i></button></td></tr>`;
            inp.innerHTML += `<input type="hidden" name="item_nome[]" value="${i.nome}"><input type="hidden" name="item_unidade[]" value="${i.un}"><input type="hidden" name="item_qtd[]" value="${i.qtd}"><input type="hidden" name="item_valor[]" value="${i.valor}"><input type="hidden" name="item_total[]" value="${i.total.toFixed(2)}">`;
        });
        document.getElementById('subtotal_post').value = soma; document.getElementById('display-subtotal').innerText = soma.toLocaleString('pt-BR',{style:'currency', currency:'BRL'}); calcularGeral();
    }
    function calcularGeral() {
        let sub = parseFloat(document.getElementById('subtotal_post').value)||0; let frete = lerDinheiro(document.getElementById('input_frete').value); let descInput = document.getElementById('input_desconto').value; let descVal = lerDinheiro(descInput); let descTipo = document.getElementById('select_tipo_desconto').value;
        let descReal = (descTipo === 'porcento') ? sub * (parseFloat(descInput.replace(/\D/g,""))/10000) : descVal; 
        let final = (sub + frete) - descReal; if(final < 0) final = 0;
        document.getElementById('footer-total').innerText = final.toLocaleString('pt-BR',{style:'currency', currency:'BRL'});
        document.getElementById('frete_post').value = frete; document.getElementById('desconto_valor_post').value = descVal; document.getElementById('desconto_tipo_post').value = descTipo; document.getElementById('total_final_post').value = final.toFixed(2);
    }
    function remover(i) { if(confirm("Remover?")) { itens.splice(i,1); renderizarLista(); } }
    function copiarZap() {
        if(!itens.length) return alert("Vazio."); let t = `*ORÇAMENTO - MAIS CHURRASCO*\n\n👤 Cliente: ${document.getElementById('cliente_nome').value}\n📅 Data: ${new Date().toLocaleDateString()}\n-----------------------------------\n`;
        itens.forEach(i => { let u=i.un?i.un:''; t+=`▪ ${i.nome}\n   ${i.qtd}${u} x R$${i.valor.toLocaleString('pt-BR',{minimumFractionDigits:2})} = *R$${i.total.toLocaleString('pt-BR',{minimumFractionDigits:2})}*\n`; });
        let tot = document.getElementById('footer-total').innerText;
        t+=`-----------------------------------\n*TOTAL FINAL: ${tot}*`; navigator.clipboard.writeText(t).then(()=>alert("Copiado para o WhatsApp!"));
    }
</script>
</body>
</html>