<?php
// ARQUIVO: gerar_pdf.php

// Carrega o Dompdf
require_once 'dompdf/autoload.inc.php'; 

use Dompdf\Dompdf;
use Dompdf\Options;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') die("Acesso inválido.");

// --- FUNÇÃO PARA LIMPAR DINHEIRO ---
function limparDinheiroPHP($valor) {
    if (is_numeric($valor)) return floatval($valor);
    $valor = preg_replace('/[^\d,.]/', '', $valor);
    $valor = str_replace(',', '.', $valor);
    // Resolve problemas de múltiplos pontos (ex: 1.200.50)
    if(substr_count($valor, '.') > 1){
       $valor = str_replace('.', '', substr($valor, 0, strrpos($valor, '.'))) . substr($valor, strrpos($valor, '.'));
    }
    return floatval($valor);
}

// --- RECEBENDO DADOS ---
$cliente_nome = $_POST['cliente_nome'] ?? 'Cliente';
$data_orcamento = $_POST['data_orcamento'] ?? date('d/m/Y');

$itens_nome = $_POST['item_nome'] ?? [];
$itens_unidade = $_POST['item_unidade'] ?? [];
$itens_qtd = $_POST['item_qtd'] ?? [];
$itens_valor = $_POST['item_valor'] ?? [];
$itens_total = $_POST['item_total'] ?? [];

// --- TOTAIS ---
$subtotal = limparDinheiroPHP($_POST['subtotal_post'] ?? 0);
$frete = limparDinheiroPHP($_POST['frete_post'] ?? 0);
$total_final = limparDinheiroPHP($_POST['total_final_post'] ?? 0);

// --- DESCONTO ---
$desc_valor = limparDinheiroPHP($_POST['desconto_valor_post'] ?? 0);
$desc_tipo = $_POST['desconto_tipo_post'] ?? 'valor';
$val_desc_real = ($desc_tipo == 'porcento') ? $subtotal * ($desc_valor/100) : $desc_valor;

$texto_desc = "";
if($val_desc_real > 0) {
    $texto_desc = ($desc_tipo == 'porcento') 
        ? "({$desc_valor}%) - R$ " . number_format($val_desc_real, 2, ',', '.') 
        : "- R$ " . number_format($val_desc_real, 2, ',', '.');
}

// --- HTML DO PDF ---
$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: "Helvetica", Arial, sans-serif; font-size: 12px; color: #333; margin: 0; padding: 0; }
        
        /* Cabeçalho com Logo */
        .header { text-align: center; margin-bottom: 30px; border-bottom: 1px solid #eee; padding-bottom: 20px; }
        .logo { height: 75px; width: auto; } /* Tamanho ideal da logo */
        
        /* Informações do Cliente */
        .info-box { 
            background-color: #f9f9f9; 
            padding: 15px; 
            border-left: 4px solid #c00d0d; /* Vermelho da marca */
            margin-bottom: 25px; 
            border-radius: 4px;
        }
        .label { color: #777; font-weight: bold; text-transform: uppercase; font-size: 10px; }
        .dado { font-size: 14px; font-weight: bold; color: #333; }
        
        /* Tabela de Itens */
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        
        th { 
            background-color: #f4f4f4; 
            color: #555; 
            padding: 10px; 
            text-align: left; 
            text-transform: uppercase; 
            font-size: 10px; 
            border-bottom: 2px solid #ddd;
        }
        
        td { padding: 10px; border-bottom: 1px solid #eee; vertical-align: middle; }
        
        /* Alinhamentos */
        .right { text-align: right; } 
        .center { text-align: center; }
        .destaque-valor { font-weight: bold; color: #333; }

        /* Área de Totais */
        .container-totais { width: 100%; margin-top: 10px; }
        .tabela-totais { width: 45%; float: right; }
        .tabela-totais td { text-align: right; padding: 5px 0; font-size: 12px; border: none; }
        
        .total-final { 
            border-top: 1px solid #ccc; 
            padding-top: 10px; 
            margin-top: 5px;
            font-size: 16px; 
            font-weight: bold; 
            color: #c00d0d; /* Vermelho da marca */
        }

        /* Rodapé */
        .footer { 
            position: fixed; 
            bottom: 0; 
            width: 100%; 
            text-align: center; 
            font-size: 9px; 
            color: #aaa; 
            border-top: 1px solid #eee; 
            padding-top: 10px;
        }
    </style>
</head>
<body>

    <div class="header">
        <img src="https://mgatv.com.br/orca/logomais.webp" class="logo">
    </div>

    <div class="info-box">
        <table style="margin:0; width:100%;">
            <tr>
                <td style="border:none; padding:0;">
                    <div class="label">CLIENTE / EVENTO</div>
                    <div class="dado">'.mb_strtoupper($cliente_nome).'</div>
                </td>
                <td style="border:none; padding:0; text-align:right;">
                    <div class="label">DATA DE EMISSÃO</div>
                    <div class="dado">'.$data_orcamento.'</div>
                </td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th width="45%">PRODUTO / SERVIÇO</th>
                <th width="15%" class="center">QTD / MEDIDA</th>
                <th width="20%" class="right">VALOR UNIT.</th>
                <th width="20%" class="right">TOTAL</th>
            </tr>
        </thead>
        <tbody>';
        
        if(count($itens_nome) > 0) {
            for($i=0; $i<count($itens_nome); $i++){
                $v_unit = limparDinheiroPHP($itens_valor[$i]);
                $v_total = limparDinheiroPHP($itens_total[$i]);
                $un = trim($itens_unidade[$i]);
                $qtd_exibicao = $un ? ($itens_qtd[$i] . ' ' . $un) : $itens_qtd[$i];

                $html .= '<tr>
                    <td>'.$itens_nome[$i].'</td>
                    <td class="center"><span style="background:#f0f0f0; padding:2px 6px; border-radius:4px; font-size:10px;">'.$qtd_exibicao.'</span></td>
                    <td class="right">R$ '.number_format($v_unit, 2, ',', '.').'</td>
                    <td class="right destaque-valor">R$ '.number_format($v_total, 2, ',', '.').'</td>
                </tr>';
            }
        } else {
            $html .= '<tr><td colspan="4" class="center" style="padding:20px; color:#999;">Nenhum item adicionado.</td></tr>';
        }

$html .= '
        </tbody>
    </table>

    <div class="container-totais">
        <table class="tabela-totais">
            <tr>
                <td style="color:#777;">SUBTOTAL:</td>
                <td>R$ '.number_format($subtotal, 2, ',', '.').'</td>
            </tr>';
            
            if($frete > 0) {
                $html .= '<tr>
                    <td style="color:#777;">FRETE / ADICIONAL:</td>
                    <td>+ R$ '.number_format($frete, 2, ',', '.').'</td>
                </tr>';
            }
            
            if($val_desc_real > 0) {
                $html .= '<tr>
                    <td style="color:#d32f2f;">DESCONTO:</td>
                    <td style="color:#d32f2f;">'.$texto_desc.'</td>
                </tr>';
            }

$html .= '
            <tr>
                <td colspan="2">
                    <div class="total-final">
                        TOTAL: R$ '.number_format($total_final, 2, ',', '.').'
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <div class="footer">
        Documento gerado eletronicamente pelo sistema Mais Churrasco. Este orçamento não possui valor fiscal.
    </div>

</body>
</html>';

// --- CONFIGURAÇÃO E GERAÇÃO DO PDF ---
$options = new Options();
$options->set('isRemoteEnabled', true); // Permite carregar a imagem da URL
$dompdf = new Dompdf($options);

$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// --- SALVAR NO SERVIDOR ---
// Cria nome seguro para o arquivo
$nome_limpo = preg_replace('/[^a-zA-Z0-9]/', '_', $cliente_nome);
$nome_arquivo = "Orcamento_" . $nome_limpo . "_" . date('Y-m-d_His') . ".pdf";

// Garante a pasta
if(!is_dir('orcamentos_pdfs')) mkdir('orcamentos_pdfs');

// Salva
$caminho_salvar = "orcamentos_pdfs/" . $nome_arquivo;
file_put_contents($caminho_salvar, $dompdf->output());

// --- BAIXAR PARA O USUÁRIO ---
$dompdf->stream($nome_arquivo, ["Attachment" => false]);
?>