<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mais Churrasco - Sistema Profissional</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        body { background-color: #f8f9fb; font-family: 'Segoe UI', sans-serif; padding-bottom: 100px; }
        :root { --primary-purple: #9b8bf4; --primary-red: #d32f2f; }

        .navbar { background: #fff; box-shadow: 0 2px 5px rgba(0,0,0,0.05); padding: 15px 0; }
        .brand-logo { background: var(--primary-red); color: white; padding: 8px 12px; border-radius: 12px; font-weight: bold; }
        .custom-card { border: none; border-radius: 15px; box-shadow: 0 4px 15px rgba(0,0,0,0.03); background: #fff; margin-bottom: 20px; padding: 25px; }
        .form-control-custom { border: 1px solid #e0e0e0; border-radius: 8px; padding: 12px; background: #fcfcfc; }
        .form-control-custom:focus { border-color: var(--primary-purple); box-shadow: 0 0 0 3px rgba(155, 139, 244, 0.1); }
        .btn-add-item { background: var(--primary-purple); color: white; width: 100%; border: none; padding: 12px; border-radius: 8px; font-weight: bold; margin-top: 15px; }
        .footer-bar { position: fixed; bottom: 0; left: 0; width: 100%; background: #fff; border-top: 1px solid #eee; padding: 15px 30px; display: flex; justify-content: space-between; align-items: center; z-index: 100; }
        .total-value { font-size: 1.5rem; font-weight: bold; color: var(--primary-purple); }
        .btn-action { padding: 10px 20px; border-radius: 8px; font-weight: 600; border: none; }
        .btn-text { background: #f3f0ff; color: var(--primary-purple); margin-right: 10px; }
        .btn-pdf { background: #6c757d; color: white; }
        .area-importacao { width: 100%; height: 200px; padding: 10px; border: 1px solid #ccc; border-radius: 8px; font-family: monospace; font-size: 12px; }
    </style>
</head>
<body>

<nav class="navbar mb-4">
    <div class="container">
        <div class="brand-logo"><i class="fas fa-utensils me-2"></i> Mais Churrasco</div>
        <div class="d-flex gap-2">
            <button type="button" class="btn btn-warning text-white fw-bold shadow-sm btn-sm" onclick="novoOrcamento()"><i class="fas fa-plus-circle"></i> Novo</button>
            <button type="button" class="btn btn-outline-primary fw-bold btn-sm" onclick="abrirModalLista()"><i class="far fa-edit"></i> Rascunhos</button>
            <button type="button" class="btn btn-dark fw-bold btn-sm" onclick="abrirModalPDFs()"><i class="fas fa-file-pdf"></i> PDFs</button>
            <button type="button" class="btn btn-success fw-bold btn-sm" onclick="abrirModalProdutos()"><i class="fas fa-box-open"></i> Produtos</button>
        </div>
    </div>
</nav>

<div class="container">
    <form id="form-orcamento" action="gerar_pdf.php" method="POST" target="_blank">
        
        <div class="custom-card">
            <div class="row align-items-end">
                <div class="col-md-9">
                    <label class="form-label text-muted fw-bold small">Cliente / Evento</label>
                    <input type="text" name="cliente_nome" id="cliente_nome" class="form-control form-control-custom" placeholder="Ex: Churrasco do João" required>
                    <input type="hidden" name="data_orcamento" id="data_orcamento">
                </div>
                <div class="col-md-3">
                    <button type="button" class="btn btn-outline-secondary w-100 py-2 mt-3 mt-md-0" onclick="salvarNoServidor()"><i class="fas fa-save me-2"></i> Salvar Rascunho</button>
                </div>
            </div>
        </div>

        <div class="custom-card">
            <h5 class="fw-bold mb-3"><i class="fas fa-cube me-2 text-primary"></i> Adicionar Item</h5>
            <div class="row g-2">
                <div class="col-md-4">
                    <label class="form-label text-muted fw-bold small">Produto</label>
                    <input type="text" id="novo_nome" class="form-control form-control-custom" list="listaSugestoes" oninput="buscarPrecoAutomatico()" placeholder="Digite para buscar...">
                    <datalist id="listaSugestoes"></datalist>
                </div>
                <div class="col-md-2">
                    <label class="form-label text-muted fw-bold small">Medida</label>
                    <div class="input-group">
                        <input type="text" id="novo_unidade" class="form-control form-control-custom" placeholder="un">
                        <span class="input-group-text" style="cursor:pointer" onclick="document.getElementById('novo_unidade').value='un'">Un</span>
                        <span class="input-group-text" style="cursor:pointer" onclick="document.getElementById('novo_unidade').value='kg'">Kg</span>
                    </div>
                </div>
                <div class="col-md-2">
                    <label class="form-label text-muted fw-bold small">Qtd / Peso</label>
                    <input type="number" id="novo_qtd" class="form-control form-control-custom text-center" value="1" step="0.01" oninput="atualizarPreviewTotal()">
                </div>
                <div class="col-md-2">
                    <label class="form-label text-muted fw-bold small">Preço (R$)</label>
                    <input type="text" id="novo_valor" class="form-control form-control-custom" placeholder="0,00" onkeyup="formatarMoeda(this); atualizarPreviewTotal()">
                </div>
                <div class="col-md-2">
                    <label class="form-label text-muted fw-bold small">Total</label>
                    <input type="text" id="novo_total_preview" class="form-control form-control-custom fw-bold text-primary bg-light" value="R$ 0,00" readonly>
                </div>
            </div>
            <button type="button" class="btn-add-item" onclick="adicionarItem()">+ ADICIONAR ITEM (ENTER)</button>
        </div>

        <div class="mb-5">
            <div id="lista-vazia" class="text-center p-5 border border-2 border-dashed rounded text-muted">Nenhum item adicionado.</div>
            <table class="table mt-3" id="tabela-visual" style="display:none;">
                <thead><tr><th>Produto</th><th class="text-center">Qtd</th><th class="text-end">Unit.</th><th class="text-end">Total</th><th></th></tr></thead>
                <tbody id="corpo-tabela"></tbody>
            </table>
            <div class="custom-card mt-3" id="box-totais" style="display:none;">
                <div class="row justify-content-end">
                    <div class="col-md-5">
                        <div class="d-flex justify-content-between mb-2"><span>Subtotal:</span> <strong id="display-subtotal">R$ 0,00</strong></div>
                        <div class="d-flex justify-content-between mb-2 align-items-center"><span>Frete:</span> <input type="text" id="input_frete" class="form-control form-control-sm w-25 text-end" onkeyup="formatarMoeda(this)" onblur="calcularGeral()"></div>
                        <div class="d-flex justify-content-between align-items-center"><span>Desconto:</span><div class="input-group input-group-sm w-50"><select id="select_tipo_desconto" class="form-select" onchange="calcularGeral()"><option value="valor">R$</option><option value="porcento">%</option></select><input type="text" id="input_desconto" class="form-control text-end" onkeyup="formatarMoeda(this)" onblur="calcularGeral()"></div></div>
                    </div>
                </div>
            </div>
            <div id="area-inputs-ocultos"></div>
            <input type="hidden" name="subtotal_post" id="subtotal_post" value="0">
            <input type="hidden" name="frete_post" id="frete_post" value="0">
            <input type="hidden" name="desconto_valor_post" id="desconto_valor_post" value="0">
            <input type="hidden" name="desconto_tipo_post" id="desconto_tipo_post" value="valor">
            <input type="hidden" name="total_final_post" id="total_final_post" value="0">
        </div>

        <div class="footer-bar">
            <div><small class="fw-bold text-muted d-block">TOTAL A PAGAR</small><span class="total-value" id="footer-total">R$ 0,00</span></div>
            <div>
                <button type="button" class="btn-action btn-text" onclick="copiarZap()"><i class="fab fa-whatsapp"></i> Zap</button>
                <button type="submit" class="btn-action btn-pdf"><i class="fas fa-file-pdf"></i> PDF</button>
            </div>
        </div>
    </form>
</div>

<div class="modal fade" id="modalProdutos" tabindex="-1"><div class="modal-dialog modal-lg"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Produtos</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><textarea id="textoImportacao" class="area-importacao" placeholder="Nome; Preço"></textarea><div class="mt-2 text-end"><button class="btn btn-primary" onclick="salvarCatalogo()">Salvar</button></div><hr><div style="max-height:150px;overflow-y:auto;" id="listaProdutosCadastrados"></div></div></div></div></div>
<div class="modal fade" id="modalLista" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">Rascunhos</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><div class="list-group" id="lista-arquivos"></div></div></div></div></div>
<div class="modal fade" id="modalPDFs" tabindex="-1"><div class="modal-dialog"><div class="modal-content"><div class="modal-header"><h5 class="modal-title">PDFs</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div><div class="modal-body"><div class="list-group" id="lista-pdfs"></div></div></div></div></div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    window.onload = function() { 
        document.getElementById('data_orcamento').value = new Date().toLocaleDateString('pt-BR'); 
        carregarProdutos(); 
    };
    let itens = [], catalogoProdutos = [];

    // --- NAVEGAÇÃO COM ENTER ---
    document.addEventListener("keydown", function(e) {
        if (e.key === "Enter") {
            if(e.target.tagName === "INPUT" || e.target.tagName === "SELECT") {
                e.preventDefault();
                let id = e.target.id;
                if(id==="novo_nome") { document.getElementById('novo_qtd').focus(); document.getElementById('novo_qtd').select(); }
                else if(id==="novo_qtd") { document.getElementById('novo_valor').focus(); }
                else if(id==="novo_valor") { adicionarItem(); }
            }
        }
    });

    // --- FUNÇÕES DE CÁLCULO E MÁSCARA ---
    function formatarMoeda(el) {
        let v = el.value.replace(/\D/g, "");
        if (v === "") { el.value = ""; return; }
        v = (v / 100).toFixed(2) + "";
        v = v.replace(".", ",");
        v = v.replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1.");
        el.value = "R$ " + v;
    }
    function lerDinheiro(s) { if(!s) return 0; let l = s.replace(/[^\d,]/g, '').replace(',', '.'); return parseFloat(l) || 0; }
    
    function atualizarPreviewTotal() {
        let qtd = parseFloat(document.getElementById('novo_qtd').value) || 0;
        let valor = lerDinheiro(document.getElementById('novo_valor').value);
        let total = qtd * valor;
        document.getElementById('novo_total_preview').value = "R$ " + total.toLocaleString('pt-BR', {minimumFractionDigits: 2});
    }

    // --- PRODUTOS ---
    function carregarProdutos() { fetch('api.php?acao=listar_produtos').then(r=>r.json()).then(d=>{ catalogoProdutos=d; atualizarDatalist(); }); }
    function atualizarDatalist() {
        let dl = document.getElementById('listaSugestoes'); dl.innerHTML = '';
        let lh = '<ul class="list-group list-group-flush small">';
        catalogoProdutos.forEach(p => {
            let op = document.createElement('option'); op.value = p.nome; dl.appendChild(op);
            lh += `<li class="list-group-item d-flex justify-content-between"><span>${p.nome}</span> <span>R$ ${parseFloat(p.preco).toFixed(2)}</span></li>`;
        });
        document.getElementById('listaProdutosCadastrados').innerHTML = lh+'</ul>';
    }
    function buscarPrecoAutomatico() {
        let nome = document.getElementById('novo_nome').value;
        let prod = catalogoProdutos.find(p => p.nome.toLowerCase() === nome.toLowerCase());
        if (prod) {
            let visual = (parseFloat(prod.preco)*100).toFixed(0);
            let campo = document.getElementById('novo_valor');
            campo.value = visual; formatarMoeda(campo);
            if(prod.unidade) document.getElementById('novo_unidade').value = prod.unidade;
            atualizarPreviewTotal();
        }
    }
    function abrirModalProdutos() {
        let t = ""; catalogoProdutos.forEach(p => t+=`${p.nome}; ${p.preco}${p.unidade?'; '+p.unidade:''}\n`);
        if(catalogoProdutos.length>0) document.getElementById('textoImportacao').value = t;
        new bootstrap.Modal(document.getElementById('modalProdutos')).show();
    }
    function salvarCatalogo() {
        let linhas = document.getElementById('textoImportacao').value.split('\n');
        let novos = [];
        linhas.forEach(l => {
            if(l.trim()!=="") {
                let p = l.split(';');
                if(p.length>=2) {
                    let pr = parseFloat(p[1].trim().replace(',','.'));
                    if(p[0] && !isNaN(pr)) novos.push({nome:p[0].trim(), preco:pr, unidade:p[2]?p[2].trim():'un'});
                }
            }
        });
        fetch('api.php?acao=salvar_produtos', {method:'POST', body:JSON.stringify(novos)}).then(r=>r.json()).then(d=>{ alert(d.msg); carregarProdutos(); bootstrap.Modal.getInstance(document.getElementById('modalProdutos')).hide(); });
    }

    // --- SISTEMA ---
    function novoOrcamento() { if(itens.length>0 && !confirm("Novo?")) return; itens=[]; document.getElementById('cliente_nome').value=''; document.getElementById('input_frete').value=''; document.getElementById('input_desconto').value=''; renderizarLista(); }
    function salvarNoServidor() {
        let cli = document.getElementById('cliente_nome').value; if(!cli || !itens.length) return alert("Preencha dados.");
        let p = { cliente:cli, itens:itens, frete:document.getElementById('input_frete').value, desconto_val:document.getElementById('input_desconto').value, desconto_tipo:document.getElementById('select_tipo_desconto').value, total_final:document.getElementById('total_final_post').value };
        fetch('api.php?acao=salvar', {method:'POST', body:JSON.stringify(p)}).then(r=>r.json()).then(d=>alert(d.msg));
    }
    function abrirModalLista() { fetch('api.php?acao=listar').then(r=>r.json()).then(d=>{ let h=d.length?'':'<p class="text-center text-muted">Vazio.</p>'; d.forEach(a=>h+=`<button class="list-group-item list-group-item-action" onclick="carregar('${a.arquivo}')"><div class="d-flex justify-content-between fw-bold"><span>${a.cliente}</span><span class="text-primary">R$ ${parseFloat(a.total).toLocaleString('pt-BR',{minimumFractionDigits:2})}</span></div><small class="text-muted">${a.data}</small></button>`); document.getElementById('lista-arquivos').innerHTML=h; new bootstrap.Modal(document.getElementById('modalLista')).show(); }); }
    function carregar(arq) { fetch(`api.php?acao=carregar&arquivo=${arq}`).then(r=>r.json()).then(d=>{ document.getElementById('cliente_nome').value=d.cliente; document.getElementById('input_frete').value=d.frete; document.getElementById('input_desconto').value=d.desconto_val; document.getElementById('select_tipo_desconto').value=d.desconto_tipo; itens=d.itens||[]; renderizarLista(); bootstrap.Modal.getInstance(document.getElementById('modalLista')).hide(); }); }
    function abrirModalPDFs() { fetch('api.php?acao=listar_pdfs').then(r=>r.json()).then(d=>{ let h=d.length?'':'<p class="text-center text-muted">Vazio.</p>'; d.forEach(p=>h+=`<div class="list-group-item d-flex justify-content-between align-items-center"><div><div class="fw-bold text-truncate" style="max-width: 200px;">${p.nome_arquivo}</div><small class="text-muted">${p.data}</small></div><a href="orcamentos_pdfs/${p.nome_arquivo}" target="_blank" class="btn btn-sm btn-danger"><i class="fas fa-download"></i></a></div>`); document.getElementById('lista-pdfs').innerHTML=h; new bootstrap.Modal(document.getElementById('modalPDFs')).show(); }); }

    function adicionarItem() {
        let nome = document.getElementById('novo_nome').value; let qtd = parseFloat(document.getElementById('novo_qtd').value); let valor = lerDinheiro(document.getElementById('novo_valor').value); let un = document.getElementById('novo_unidade').value.trim();
        if(!nome || isNaN(qtd) || valor === 0) return alert("Preencha corretamente.");
        itens.push({ nome, qtd, valor, un, total: qtd * valor }); renderizarLista();
        document.getElementById('novo_nome').value=''; document.getElementById('novo_valor').value=''; document.getElementById('novo_qtd').value='1'; document.getElementById('novo_unidade').value=''; document.getElementById('novo_total_preview').value='R$ 0,00'; document.getElementById('novo_nome').focus();
    }
    function renderizarLista() {
        let tb = document.getElementById('corpo-tabela'); let inp = document.getElementById('area-inputs-ocultos'); tb.innerHTML=''; inp.innerHTML='';
        let d = itens.length ? 'table' : 'none'; document.getElementById('tabela-visual').style.display=d; document.getElementById('box-totais').style.display=itens.length?'block':'none'; document.getElementById('lista-vazia').style.display=itens.length?'none':'block';
        let soma = 0;
        itens.forEach((i, idx) => {
            soma += i.total; let u = i.un ? i.un : '';
            tb.innerHTML += `<tr><td>${i.nome}</td><td class="text-center">${i.qtd} ${u}</td><td class="text-end">R$ ${i.valor.toLocaleString('pt-BR',{minimumFractionDigits:2})}</td><td class="text-end fw-bold">R$ ${i.total.toLocaleString('pt-BR',{minimumFractionDigits:2})}</td><td class="text-center"><button type="button" class="btn btn-sm text-danger" onclick="remover(${idx})"><i class="fas fa-trash"></i></button></td></tr>`;
            inp.innerHTML += `<input type="hidden" name="item_nome[]" value="${i.nome}"><input type="hidden" name="item_unidade[]" value="${i.un}"><input type="hidden" name="item_qtd[]" value="${i.qtd}"><input type="hidden" name="item_valor[]" value="${i.valor}"><input type="hidden" name="item_total[]" value="${i.total.toFixed(2)}">`;
        });
        document.getElementById('subtotal_post').value = soma; document.getElementById('display-subtotal').innerText = soma.toLocaleString('pt-BR',{style:'currency', currency:'BRL'}); calcularGeral();
    }
    function calcularGeral() {
        let sub = parseFloat(document.getElementById('subtotal_post').value)||0; let frete = lerDinheiro(document.getElementById('input_frete').value); let descInput = document.getElementById('input_desconto').value; let descVal = lerDinheiro(descInput); let descTipo = document.getElementById('select_tipo_desconto').value;
        let descReal = (descTipo === 'porcento') ? sub * (parseFloat(descInput.replace(/\D/g,""))/10000) : descVal; // Ajuste na % com mascara
        
        let final = (sub + frete) - descReal; if(final < 0) final = 0;
        document.getElementById('footer-total').innerText = final.toLocaleString('pt-BR',{style:'currency', currency:'BRL'});
        document.getElementById('frete_post').value = frete; document.getElementById('desconto_valor_post').value = descVal; document.getElementById('desconto_tipo_post').value = descTipo; document.getElementById('total_final_post').value = final.toFixed(2);
    }
    function remover(i) { if(confirm("Remover?")) { itens.splice(i,1); renderizarLista(); } }
    function copiarZap() {
        if(!itens.length) return alert("Vazio."); let t = `*ORÇAMENTO*\nCliente: ${document.getElementById('cliente_nome').value}\n\n`;
        itens.forEach(i => { let u=i.un?i.un:''; t+=`▪ ${i.nome}: ${i.qtd}${u} x R$${i.valor.toLocaleString('pt-BR',{minimumFractionDigits:2})} = R$${i.total.toLocaleString('pt-BR',{minimumFractionDigits:2})}\n`; });
        t+=`\n*TOTAL: ${document.getElementById('footer-total').innerText}*`; navigator.clipboard.writeText(t).then(()=>alert("Copiado!"));
    }
</script>
</body>
</html>