<?php
// ARQUIVO: gerar_pdf.php
// SE FOR INSTALAÇÃO MANUAL (sem composer), use esta linha:
require_once 'dompdf/autoload.inc.php'; 
// SE FOR VIA COMPOSER: require 'vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') die("Acesso inválido.");

// FUNÇÃO PARA LIMPAR MÁSCARA DE DINHEIRO (1.200,50 -> 1200.50)
function limparDinheiroPHP($valor) {
    if (is_numeric($valor)) return floatval($valor);
    $valor = preg_replace('/[^\d,.]/', '', $valor);
    $valor = str_replace(',', '.', $valor); // Troca vírgula por ponto
    // Se tiver mais de um ponto (ex: 1.200.50), mantém só o último
    if(substr_count($valor, '.') > 1){
       $valor = str_replace('.', '', substr($valor, 0, strrpos($valor, '.'))) . substr($valor, strrpos($valor, '.'));
    }
    return floatval($valor);
}

// RECEBIMENTO DE DADOS
$cliente_nome = $_POST['cliente_nome'] ?? 'Cliente';
$data_orcamento = $_POST['data_orcamento'] ?? date('d/m/Y');

$itens_nome = $_POST['item_nome'] ?? [];
$itens_unidade = $_POST['item_unidade'] ?? [];
$itens_qtd = $_POST['item_qtd'] ?? [];
$itens_valor = $_POST['item_valor'] ?? [];
$itens_total = $_POST['item_total'] ?? [];

// TOTAIS
$subtotal = limparDinheiroPHP($_POST['subtotal_post'] ?? 0);
$frete = limparDinheiroPHP($_POST['frete_post'] ?? 0);
$total_final = limparDinheiroPHP($_POST['total_final_post'] ?? 0);

// DESCONTO
$desc_valor = limparDinheiroPHP($_POST['desconto_valor_post'] ?? 0);
$desc_tipo = $_POST['desconto_tipo_post'] ?? 'valor';
$val_desc_real = ($desc_tipo == 'porcento') ? $subtotal * ($desc_valor/100) : $desc_valor;

$texto_desc = "";
if($val_desc_real > 0) {
    $texto_desc = ($desc_tipo == 'porcento') 
        ? "({$desc_valor}%) - R$ " . number_format($val_desc_real, 2, ',', '.') 
        : "- R$ " . number_format($val_desc_real, 2, ',', '.');
}

// MONTAGEM DO HTML
$html = '
<!DOCTYPE html>
<html>
<head>
    <style>
        body { font-family: Helvetica, Arial, sans-serif; font-size: 12px; color: #333; }
        .header { text-align: center; border-bottom: 3px solid #d32f2f; margin-bottom: 20px; padding-bottom: 10px; }
        .header h1 { margin: 0; color: #d32f2f; text-transform: uppercase; }
        .info-box { background: #f8f9fa; padding: 10px; border: 1px solid #eee; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 10px; }
        th { background: #9b8bf4; color: white; padding: 8px; text-align: left; text-transform: uppercase; font-size: 10px; }
        td { padding: 8px; border-bottom: 1px solid #eee; }
        .right { text-align: right; } .center { text-align: center; }
        .resumo { width: 100%; margin-top: 10px; }
        .tab-tot { width: 45%; float: right; }
        .tab-tot td { text-align: right; padding: 4px; }
        .total-f { border-top: 2px solid #ccc; font-weight: bold; font-size: 14px; color: #d32f2f; }
        .footer { position: fixed; bottom: 0; width: 100%; text-align: center; font-size: 9px; color: #aaa; }
    </style>
</head>
<body>
    <div class="header"><h1>Orçamento - Mais Churrasco</h1></div>
    <div class="info-box"><b>Cliente:</b> '.mb_strtoupper($cliente_nome).'<br><b>Data:</b> '.$data_orcamento.'</div>
    <table>
        <thead><tr><th width="45%">Produto</th><th width="20%" class="center">Qtd</th><th width="15%" class="right">Unit.</th><th width="20%" class="right">Total</th></tr></thead>
        <tbody>';
        
        for($i=0; $i<count($itens_nome); $i++){
            $v_unit = limparDinheiroPHP($itens_valor[$i]);
            $v_total = limparDinheiroPHP($itens_total[$i]);
            $un = trim($itens_unidade[$i]);
            $qtd_exibicao = $un ? ($itens_qtd[$i] . ' ' . $un) : $itens_qtd[$i];

            $html .= '<tr>
                <td>'.$itens_nome[$i].'</td>
                <td class="center">'.$qtd_exibicao.'</td>
                <td class="right">R$ '.number_format($v_unit, 2, ',', '.').'</td>
                <td class="right">R$ '.number_format($v_total, 2, ',', '.').'</td>
            </tr>';
        }

$html .= '</tbody></table>
    <div class="resumo"><table class="tab-tot">
        <tr><td>Subtotal:</td><td>R$ '.number_format($subtotal, 2, ',', '.').'</td></tr>';
        if($frete > 0) $html .= '<tr><td>Frete:</td><td>+ R$ '.number_format($frete, 2, ',', '.').'</td></tr>';
        if($val_desc_real > 0) $html .= '<tr><td style="color:red">Desconto:</td><td style="color:red">'.$texto_desc.'</td></tr>';
$html .= '<tr class="total-f"><td>TOTAL:</td><td>R$ '.number_format($total_final, 2, ',', '.').'</td></tr>
    </table></div>
    <div class="footer">Documento gerado eletronicamente. Não possui valor fiscal.</div>
</body></html>';

// GERAÇÃO PDF
$options = new Options();
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

// SALVAR NO SERVIDOR
$nome_limpo = preg_replace('/[^a-zA-Z0-9]/', '_', $cliente_nome);
$nome_arquivo = "Orcamento_" . $nome_limpo . "_" . date('Y-m-d_His') . ".pdf";
$caminho_salvar = "orcamentos_pdfs/" . $nome_arquivo;

if(!is_dir('orcamentos_pdfs')) mkdir('orcamentos_pdfs');
file_put_contents($caminho_salvar, $dompdf->output());

// DOWNLOAD
$dompdf->stream($nome_arquivo, ["Attachment" => false]);
?>