<?php
// ARQUIVO: gerar_pdf.php
require_once 'dompdf/autoload.inc.php'; 
use Dompdf\Dompdf;
use Dompdf\Options;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') die("Acesso inválido.");

// Função robusta para limpar dinheiro
function limparDinheiroPHP($valor) {
    if (is_numeric($valor)) return floatval($valor);
    $valor = str_replace('R$', '', $valor);
    $valor = trim($valor);
    $valor = preg_replace('/[^\d,.]/', '', $valor); // Remove tudo que não é numero, ponto ou virgula
    $valor = str_replace(',', '.', $valor);
    // Corrige múltiplos pontos (ex: 1.200.50)
    if(substr_count($valor, '.') > 1){
       $valor = str_replace('.', '', substr($valor, 0, strrpos($valor, '.'))) . substr($valor, strrpos($valor, '.'));
    }
    return floatval($valor);
}

// Dados
$cliente_nome = $_POST['cliente_nome'] ?? 'Cliente';
$cliente_zap = $_POST['cliente_zap'] ?? '';
$data_orcamento = $_POST['data_orcamento'] ?? date('d/m/Y');

$itens_nome = $_POST['item_nome'] ?? [];
$itens_unidade = $_POST['item_unidade'] ?? [];
$itens_qtd = $_POST['item_qtd'] ?? [];
$itens_valor = $_POST['item_valor'] ?? [];
$itens_total = $_POST['item_total'] ?? [];

// Totais
$subtotal = limparDinheiroPHP($_POST['subtotal_post'] ?? 0);
$frete = limparDinheiroPHP($_POST['frete_post'] ?? 0);
$total_final = limparDinheiroPHP($_POST['total_final_post'] ?? 0);
$desc_valor = limparDinheiroPHP($_POST['desconto_valor_post'] ?? 0);
$desc_tipo = $_POST['desconto_tipo_post'] ?? 'valor';

$val_desc_real = ($desc_tipo == 'porcento') ? $subtotal * ($desc_valor/100) : $desc_valor;
$texto_desc = "";
if($val_desc_real > 0) {
    $texto_desc = ($desc_tipo == 'porcento') ? "- R$ ".number_format($val_desc_real,2,',','.')." ({$desc_valor}%)" : "- R$ ".number_format($val_desc_real,2,',','.');
}

$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <style>
        @page { margin: 40px; }
        body { font-family: "Helvetica", sans-serif; font-size: 12px; color: #444; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #f0f0f0; padding-bottom: 20px; }
        .logo { height: 80px; width: auto; margin-bottom: 10px; }
        .titulo-doc { font-size: 14px; letter-spacing: 3px; text-transform: uppercase; color: #c00d0d; font-weight: bold; }
        
        .info-container { width: 100%; margin-bottom: 20px; padding: 15px; background: #fcfcfc; border-left: 5px solid #c00d0d; }
        .info-label { font-size: 10px; text-transform: uppercase; color: #999; font-weight: bold; }
        .info-valor { font-size: 14px; font-weight: bold; color: #333; }
        
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th { background: #c00d0d; color: white; text-transform: uppercase; font-size: 10px; padding: 8px; text-align: left; }
        td { padding: 8px; border-bottom: 1px solid #eee; font-size: 11px; }
        tr:nth-child(even) { background: #fafafa; }
        
        .badge-un { background: #eee; padding: 2px 4px; border-radius: 3px; font-size: 9px; color: #666; margin-left: 2px; }
        
        .box-totais { width: 100%; margin-top: 10px; }
        .tabela-totais { width: 45%; float: right; }
        .tabela-totais td { text-align: right; padding: 4px 0; border: none; }
        .total-grande { font-size: 16px; font-weight: bold; color: #c00d0d; padding-top: 5px; border-top: 2px solid #c00d0d; }
        
        .footer { position: fixed; bottom: 0; width: 100%; text-align: center; font-size: 9px; color: #aaa; border-top: 1px solid #eee; padding-top: 10px; }
    </style>
</head>
<body>
    <div class="header">
        <img src="https://mgatv.com.br/quality/quality.png" class="logo">
        <div class="titulo-doc">Orçamento</div>
    </div>

    <table style="width:100%; margin-bottom:20px; background:transparent;"><tr>
        <td style="padding:0; border:none;">
            <div class="info-container">
                <div class="info-label">Cliente / Evento</div>
                <div class="info-valor">'.mb_strtoupper($cliente_nome).'</div>
                '.($cliente_zap ? '<div style="font-size:11px; color:#666; margin-top:2px;">WhatsApp: '.$cliente_zap.'</div>' : '').'
            </div>
        </td>
        <td style="width:20px; border:none;"></td>
        <td style="width:140px; padding:0; border:none;">
            <div class="info-container" style="border-left-color:#444;">
                <div class="info-label">Data</div>
                <div class="info-valor">'.$data_orcamento.'</div>
            </div>
        </td>
    </tr></table>

    <table>
        <thead><tr><th width="50%">Produto</th><th width="15%" style="text-align:center">Qtd</th><th width="15%" style="text-align:right">Unit.</th><th width="20%" style="text-align:right">Total</th></tr></thead>
        <tbody>';
        
        if(count($itens_nome) > 0) {
            for($i=0; $i<count($itens_nome); $i++){
                $v_unit = limparDinheiroPHP($itens_valor[$i]);
                $v_total = limparDinheiroPHP($itens_total[$i]);
                $un = trim($itens_unidade[$i]);
                $un_html = $un ? "<span class='badge-un'>".strtoupper($un)."</span>" : "";
                
                $html .= '<tr>
                    <td>'.$itens_nome[$i].'</td>
                    <td style="text-align:center">'.$itens_qtd[$i] . $un_html .'</td>
                    <td style="text-align:right">R$ '.number_format($v_unit, 2, ',', '.').'</td>
                    <td style="text-align:right; font-weight:bold;">R$ '.number_format($v_total, 2, ',', '.').'</td>
                </tr>';
            }
        } else { $html .= '<tr><td colspan="4" style="text-align:center; padding:20px; color:#ccc;">Vazio</td></tr>'; }
        
$html .= '</tbody></table>

    <div class="box-totais"><table class="tabela-totais">
        <tr><td>Subtotal:</td><td>R$ '.number_format($subtotal, 2, ',', '.').'</td></tr>';
        if($frete > 0) $html .= '<tr><td>Frete:</td><td>+ R$ '.number_format($frete, 2, ',', '.').'</td></tr>';
        if($val_desc_real > 0) $html .= '<tr><td style="color:#c00d0d">Desconto:</td><td style="color:#c00d0d">'.$texto_desc.'</td></tr>';
$html .= '<tr><td style="padding-top:10px;"><b>TOTAL:</b></td><td class="total-grande">R$ '.number_format($total_final, 2, ',', '.').'</td></tr>
    </table></div>
    
    <div class="footer">Gerado eletronicamente pelo sistema Quality Grill.</div>
</body></html>';

$options = new Options(); $options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options); $dompdf->loadHtml($html); $dompdf->setPaper('A4', 'portrait'); $dompdf->render();

$nome_arquivo = "Orcamento_" . preg_replace('/[^a-zA-Z0-9]/', '_', $cliente_nome) . "_" . date('Y-m-d_His') . ".pdf";
file_put_contents("orcamentos_pdfs/" . $nome_arquivo, $dompdf->output());
$dompdf->stream($nome_arquivo, ["Attachment" => false]);
?>