<?php
// Força o PHP a mostrar todos os erros na tela
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>Diagnóstico do Sistema</h1>";

// 1. Teste básico do PHP
echo "<p>✅ O PHP está funcionando. Versão: " . phpversion() . "</p>";

// 2. Teste da pasta Dompdf
if (file_exists(__DIR__ . '/dompdf/autoload.inc.php')) {
    echo "<p style='color:green; font-weight:bold;'>✅ A pasta 'dompdf' foi encontrada corretamente!</p>";
    require_once 'dompdf/autoload.inc.php';
    echo "<p>✅ Biblioteca carregada com sucesso.</p>";
} else {
    echo "<p style='color:red; font-weight:bold;'>❌ ERRO CRÍTICO: A pasta 'dompdf' NÃO foi encontrada.</p>";
    echo "<p>O sistema está procurando aqui: <code>" . __DIR__ . "/dompdf/autoload.inc.php</code></p>";
    echo "<h3>Como corrigir:</h3>";
    echo "<ul>";
    echo "<li>Verifique se você extraiu a pasta com o nome exato <b>dompdf</b> (tudo minúsculo).</li>";
    echo "<li>Verifique se a pasta <b>dompdf</b> está ao lado deste arquivo.</li>";
    echo "</ul>";
}
?>