<?php
require 'conexao.php';

// --- AÇÕES ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // EXCLUIR
    if (isset($_POST['excluir_id'])) {
        $stmt = $pdo->prepare("DELETE FROM produtos WHERE id = ?");
        $stmt->execute([$_POST['excluir_id']]);
    }
    // NOVO PRODUTO (JÁ NASCE COM 160 DE ESTOQUE)
    elseif (isset($_POST['novo_nome'])) {
        $nome = $_POST['novo_nome'];
        $preco = str_replace(',', '.', $_POST['novo_preco']);
        $cat = $_POST['novo_cat'];
        
        // AQUI ESTÁ A MUDANÇA: PADRÃO 160
        $estoque = 160; 
        
        if($nome && $preco) {
            $stmt = $pdo->prepare("INSERT INTO produtos (nome, preco, categoria, estoque) VALUES (?, ?, ?, ?)");
            $stmt->execute([$nome, $preco, $cat, $estoque]);
        }
    }
    // ATUALIZAR EM MASSA (PREÇO E ESTOQUE)
    elseif (isset($_POST['produtos'])) {
        foreach ($_POST['produtos'] as $id => $dados) {
            $nome = $dados['nome'];
            $preco = str_replace(',', '.', $dados['preco']);
            $cat = $dados['categoria'];
            $estoque = floatval($dados['estoque']); // Salva quantidade/peso editado
            
            $stmt = $pdo->prepare("UPDATE produtos SET nome = ?, preco = ?, categoria = ?, estoque = ? WHERE id = ?");
            $stmt->execute([$nome, $preco, $cat, $estoque, $id]);
        }
    }
    header("Location: produtos.php");
    exit;
}

// Busca e Agrupa
$produtos = $pdo->query("SELECT * FROM produtos ORDER BY categoria ASC, nome ASC")->fetchAll(PDO::FETCH_ASSOC);
$grupos = [];
foreach($produtos as $p) { $grupos[$p['categoria']][] = $p; }

$catLabels = [
    'assados' => ['nome' => 'Assados', 'cor' => 'warning'],
    'carnes' => ['nome' => 'Carnes (Kg)', 'cor' => 'dark'],
    'guarnicoes' => ['nome' => 'Guarnições', 'cor' => 'danger'],
    'extras' => ['nome' => 'Extras', 'cor' => 'info'],
    'bebidas' => ['nome' => 'Bebidas', 'cor' => 'success']
];
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Gerenciar Estoque</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</head>
<body class="bg-light">
    <div class="container py-4" style="max-width: 1000px;">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h3 class="fw-bold"><i class="bi bi-boxes"></i> Estoque & Produtos</h3>
            <a href="index.php" class="btn btn-secondary">Voltar ao Admin</a>
        </div>

        <div class="card shadow-sm mb-5 border-primary border-2">
            <div class="card-header bg-primary text-white fw-bold"><i class="bi bi-plus-circle"></i> Novo Produto (Estoque Padrão: 160)</div>
            <div class="card-body bg-white">
                <form method="POST" class="row g-2">
                    <div class="col-md-4">
                        <label class="small text-muted">Nome</label>
                        <input type="text" name="novo_nome" class="form-control" required placeholder="Ex: Alcatra">
                    </div>
                    <div class="col-md-3">
                        <label class="small text-muted">Categoria</label>
                        <select name="novo_cat" class="form-select">
                            <option value="assados">Assados</option>
                            <option value="carnes">Carnes (Kg)</option>
                            <option value="guarnicoes">Guarnições</option>
                            <option value="extras">Extras</option>
                            <option value="bebidas">Bebidas</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="small text-muted">Preço</label>
                        <input type="text" name="novo_preco" class="form-control" placeholder="0.00" required>
                    </div>
                    <div class="col-md-3 d-flex align-items-end"><button type="submit" class="btn btn-primary w-100 fw-bold">CADASTRAR</button></div>
                </form>
            </div>
        </div>

        <form method="POST">
            <?php foreach($grupos as $catKey => $itens): ?>
                <?php $conf = $catLabels[$catKey] ?? ['nome'=>strtoupper($catKey), 'cor'=>'secondary']; ?>
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-<?= $conf['cor'] ?> bg-opacity-25 fw-bold text-dark border-<?= $conf['cor'] ?>">
                        <?= $conf['nome'] ?>
                    </div>
                    <div class="card-body p-0">
                        <table class="table table-hover mb-0 align-middle">
                            <thead class="table-light small">
                                <tr>
                                    <th>Nome</th>
                                    <th>Categoria</th>
                                    <th width="100">Preço</th>
                                    <th width="130" class="text-center bg-warning bg-opacity-10">ESTOQUE</th>
                                    <th width="50"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($itens as $p): ?>
                                <tr>
                                    <td><input type="text" name="produtos[<?= $p['id'] ?>][nome]" class="form-control border-0 bg-transparent fw-bold" value="<?= $p['nome'] ?>"></td>
                                    <td>
                                        <select name="produtos[<?= $p['id'] ?>][categoria]" class="form-select form-select-sm border-0 bg-light">
                                            <option value="assados" <?= $p['categoria']=='assados'?'selected':'' ?>>Assados</option>
                                            <option value="carnes" <?= $p['categoria']=='carnes'?'selected':'' ?>>Carnes (Kg)</option>
                                            <option value="guarnicoes" <?= $p['categoria']=='guarnicoes'?'selected':'' ?>>Guarnições</option>
                                            <option value="extras" <?= $p['categoria']=='extras'?'selected':'' ?>>Extras</option>
                                            <option value="bebidas" <?= $p['categoria']=='bebidas'?'selected':'' ?>>Bebidas</option>
                                        </select>
                                    </td>
                                    <td><input type="text" name="produtos[<?= $p['id'] ?>][preco]" class="form-control text-center" value="<?= number_format($p['preco'], 2, ',', '') ?>"></td>
                                    
                                    <td class="bg-warning bg-opacity-10">
                                        <input type="number" step="0.001" name="produtos[<?= $p['id'] ?>][estoque]" class="form-control text-center fw-bold border-warning" value="<?= floatval($p['estoque']) ?>">
                                    </td>
                                    
                                    <td class="text-center">
                                        <button type="submit" name="excluir_id" value="<?= $p['id'] ?>" class="btn btn-link text-danger p-0" onclick="return confirm('Excluir?')"><i class="bi bi-trash-fill"></i></button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endforeach; ?>
            
            <div class="sticky-bottom bg-white p-3 border-top shadow-lg text-end">
                <button type="submit" class="btn btn-success fw-bold py-3 px-5"><i class="bi bi-check-circle-fill"></i> SALVAR TUDO</button>
            </div>
        </form>
        <br><br>
    </div>
</body>
</html>