<?php
require 'conexao.php';
$msg = ''; $cupomFiscalHTML = ''; $sucesso = false;

// Busca todos os produtos
$produtos_db = $pdo->query("SELECT * FROM produtos ORDER BY categoria DESC, nome ASC")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nomeCli = mb_strtoupper(substr($cli, 0, 25), 'UTF-8');
            $obsBlock = !empty($obs) ? "<div class='obs-box'>OBS: ".mb_strtoupper($obs, 'UTF-8')."</div>" : "";
    $cli = $_POST['cliente']; $tel = $_POST['telefone']; $obs = $_POST['obs']; $pg = isset($_POST['status_pago']) ? 1 : 0;
    $itens = []; $total = 0; $erro = false;

    foreach ($produtos_db as $p) {
        $id = $p['id'];
        
        // --- TRATAMENTO INTELIGENTE DA QUANTIDADE ---
        $qtd_post = $_POST['qtd_'.$id] ?? 0;

        if ($p['categoria'] == 'carnes') {
            // Se vier com vírgula (ex: 1,500), troca por ponto (1.500) para o PHP entender
            $qtd_formatada = str_replace(',', '.', $qtd_post);
            $qtd = floatval($qtd_formatada);
        } else {
            $qtd = intval($qtd_post);
        }
        
        if ($qtd > 0) {
            // VERIFICA ESTOQUE
            if ($qtd > $p['estoque']) {
                $msg = "<div class='alert alert-danger'>⚠️ Sem estoque suficiente para: <b>{$p['nome']}</b>. Disp: ".floatval($p['estoque'])."</div>";
                $erro = true; break;
            }
            $sub = $qtd * $p['preco']; $total += $sub;
            $itens[] = ['id'=>$id, 'nome'=>$p['nome'], 'qtd'=>$qtd, 'preco'=>$p['preco'], 'subtotal'=>$sub, 'cat'=>$p['categoria']];
        }
    }

    if (!$erro && $total > 0) {
        // 1. DEDUZ ESTOQUE
        foreach ($itens as $i) $pdo->query("UPDATE produtos SET estoque = estoque - {$i['qtd']} WHERE id = {$i['id']}");

        // 2. SALVA PEDIDO
        $json = json_encode($itens, JSON_UNESCAPED_UNICODE);
        $sql = "INSERT INTO pedidos (cliente, telefone, observacao, valor_total, itens_json, data_pedido, pago, entregue) VALUES (?, ?, ?, ?, ?, NOW(), ?, 0)";
        $stmt = $pdo->prepare($sql);
        
        if($stmt->execute([$cli, $tel, $obs, $total, $json, $pg])) {
            $id_ped = $pdo->lastInsertId(); $sucesso = true;
            
            // 3. GERA CUPOM
            $data = date('d/m/Y H:i'); $senha = str_pad($id_ped, 3, '0', STR_PAD_LEFT);
            $totalFmt = number_format($total, 2, ',', '.'); $pgTxt = $pg ? "[ PAGO ]" : "[ PENDENTE ]";
            
            $trs = "";
            foreach($itens as $it) {
                $q = ($it['cat']=='carnes') ? number_format($it['qtd'],3,',','.').' Kg' : intval($it['qtd']);
                $v = number_format($it['subtotal'], 2, ',', '.');
                $trs .= "<tr><td class='c-q'>$q</td><td class='c-n'>{$it['nome']}</td><td class='c-p'>$v</td></tr>";
            }
            
            $cupomFiscalHTML = "
            <div id='area-impressao'><div class='cupom-wrapper'>
                <div class='logo-box'><img src='img/logomais.png' class='logo-img'></div>
                <div class='head'><h2>SENHA: $senha</h2><span>$data</span></div>
                <div class='cli'>".strtoupper(substr($cli,0,25))."</div>
                <table class='tb'><thead><tr><th class='c-q'>QTD</th><th class='c-n'>ITEM</th><th class='c-p'>$$</th></tr></thead><tbody>$trs</tbody></table>
                <div class='tot'>TOTAL: R$ $totalFmt</div>
                <div class='pg'>$pgTxt</div>
                <div class='foot'>*** OBRIGADO ***</div>
            </div></div>";

            $msg = "<div class='alert alert-success text-center shadow'><h4>✅ Venda #$id_ped Confirmada!</h4><button onclick='window.print()' class='btn btn-dark w-100 py-3 mb-2'>🖨️ IMPRIMIR</button><a href='pdv.php' class='btn btn-outline-secondary'>Nova Venda</a></div>";
        }
    } else if (!$erro) { $msg = "<div class='alert alert-warning'>⚠️ Selecione itens.</div>"; }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>PDV</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: #e9ecef; }
        #area-impressao { display: none; }
        .esgotado-overlay { position: absolute; top:0;left:0;width:100%;height:100%;background:rgba(255,255,255,0.7);z-index:5;display:flex;align-items:center;justify-content:center;color:red;font-weight:bold;transform:rotate(-5deg); border:1px solid red; }
        #resumoCarrinho { max-height: 300px; overflow-y: auto; font-size: 0.9rem; }
        
        @media print {
            .no-print, nav, .container { display: none !important; }
            body { background: #fff; margin: 0; }
            #area-impressao { display: block !important; position: absolute; top:0; left:0; width: 72mm; font-family: Arial; font-size: 11px; color: #000; }
            .cupom-wrapper { width: 100%; padding: 2px; }
            .logo-box { text-align: center; border-bottom: 3px solid #000; padding-bottom: 5px; margin-bottom: 5px; }
            .logo-img { max-width: 80px; }
            .head { text-align: center; border-bottom: 2px solid #000; padding-bottom: 5px; margin-bottom: 5px; }
            .cli { font-weight: bold; border-bottom: 1px dashed #000; padding-bottom: 5px; margin-bottom: 5px; }
            .tb { width: 100%; border-collapse: collapse; }
            .tb th { border-bottom: 1px solid #000; text-align: left; font-size: 10px; }
            .tb td { border-bottom: 1px dotted #999; vertical-align: top; padding: 2px 0; }
            .c-q { width: 20%; text-align: center; font-weight: 800; }
            .c-n { width: 50%; }
            .c-p { width: 30%; text-align: right; white-space: nowrap; }
            .tot { border-top: 2px solid #000; font-size: 16px; font-weight: 800; text-align: right; margin-top: 5px; padding-top: 5px; }
            .pg { text-align: right; font-weight: bold; font-size: 12px; margin-top: 5px; }
            .foot { text-align: center; font-size: 9px; margin-top: 10px; }
        }
    </style>
</head>
<body>
    <?= $cupomFiscalHTML ?>
    <nav class="navbar navbar-dark bg-dark mb-3 no-print p-2"><div class="container-fluid"><span class="navbar-brand fw-bold">PDV Caixa</span> <a href="index.php" class="btn btn-outline-light btn-sm">Admin</a></div></nav>

    <div class="container-fluid no-print pb-5">
        <?= $msg ?>
        <?php if(!$sucesso): ?>
        <form method="POST">
            <div class="row">
                <div class="col-md-8">
                    <div class="row g-2">
                        <?php 
                        $cats = ['assados'=>'warning', 'carnes'=>'dark', 'guarnicoes'=>'danger', 'extras'=>'info', 'bebidas'=>'success', 'Outros'=>'secondary'];
                        $grupos = []; foreach($produtos_db as $p) { $grupos[$p['categoria']?:'Outros'][] = $p; }
                        ?>
                        <?php foreach($cats as $catName => $cor): if(isset($grupos[$catName])): ?>
                            <div class="col-md-6 mb-2">
                                <div class="bg-<?= $cor ?> text-white px-2 py-1 rounded fw-bold small mb-1"><?= strtoupper($catName) ?></div>
                                <?php foreach($grupos[$catName] as $p): $esgotado = ($p['estoque']<=0); ?>
                                    <div class="d-flex align-items-center bg-white border rounded p-2 mb-1 shadow-sm position-relative overflow-hidden">
                                        <?php if($esgotado): ?><div class="esgotado-overlay">ESGOTADO</div><?php endif; ?>
                                        <div class="flex-grow-1 lh-1">
                                            <div class="fw-bold text-dark"><?= $p['nome'] ?></div>
                                            <small class="text-primary fw-bold">R$ <?= number_format($p['preco'],2,',','.') ?><?= $catName=='carnes'?'/Kg':'' ?></small>
                                            <span class="badge bg-light text-secondary border ms-1" style="font-size: 9px;">Est: <?= floatval($p['estoque']) ?></span>
                                        </div>
                                        <div style="width: 130px;" class="text-end">
                                            <?php if(!$esgotado): ?>
                                                <?php if($catName=='carnes'): ?>
                                                    <div class="input-group input-group-sm">
                                                        <span class="input-group-text">Kg</span>
                                                        <input type="text" inputmode="numeric" name="qtd_<?= $p['id'] ?>" class="form-control text-center fw-bold" 
                                                               placeholder="0,000" onkeyup="mascaraPeso(this); calc()" onchange="calc()">
                                                    </div>
                                                <?php else: ?>
                                                    <div class="input-group input-group-sm">
                                                        <button type="button" class="btn btn-outline-secondary" onclick="add(<?= $p['id'] ?>, -1)">-</button>
                                                        <input type="number" name="qtd_<?= $p['id'] ?>" id="qtd_<?= $p['id'] ?>" class="form-control text-center fw-bold" value="0" readonly>
                                                        <button type="button" class="btn btn-outline-secondary" onclick="add(<?= $p['id'] ?>, 1)">+</button>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; endforeach; ?>
                    </div>
                </div>

                <div class="col-md-4">
                    <div class="card shadow border-0 sticky-top" style="top: 10px; z-index: 100;">
                        <div class="card-header bg-danger text-white fw-bold text-center">RESUMO DO PEDIDO</div>
                        <div class="card-body">
                            <div id="resumoCarrinho" class="mb-3 border-bottom pb-2">
                                <p class="text-center text-muted small fst-italic">Nenhum item selecionado.</p>
                            </div>

                            <h2 class="text-center text-success fw-bold">R$ <span id="tot">0,00</span></h2>
                            <hr>
                            <input type="text" name="cliente" class="form-control mb-2" placeholder="Cliente" required>
                            <input type="tel" name="telefone" class="form-control mb-2" placeholder="Zap">
                            <textarea name="obs" class="form-control mb-2" placeholder="Obs" rows="1"></textarea>
                            <div class="form-check form-switch mb-3 p-2 bg-light rounded">
                                <input class="form-check-input ms-0 me-2" type="checkbox" name="status_pago" value="1"> <label>JÁ ESTÁ PAGO?</label>
                            </div>
                            <button class="btn btn-danger w-100 fw-bold py-3">FINALIZAR VENDA</button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
        <?php endif; ?>
    </div>
    
    <script>
        const produtos = <?= json_encode($produtos_db) ?>;

        // Função que faz a mágica da vírgula (MÁSCARA)
        function mascaraPeso(i) {
            var v = i.value.replace(/\D/g,'');
            v = (v/1000).toFixed(3) + '';
            v = v.replace(".", ",");
            i.value = v;
        }

        function add(id, v) {
            let el = document.getElementById('qtd_'+id);
            let prod = produtos.find(p => p.id == id);
            let max = parseFloat(prod.estoque);

            let n = (parseInt(el.value)||0) + v;
            if(n<0) n=0;
            if(n > max) { alert("Estoque máximo atingido!"); n = max; }
            el.value = n; 
            calc();
        }

        function calc() {
            let total = 0;
            let htmlResumo = "";
            let temItens = false;

            document.querySelectorAll('input[name^="qtd_"]').forEach(el => {
                let id = el.name.split('_')[1];
                let prod = produtos.find(p => p.id == id);
                
                // Pega valor. Se for carne, converte vírgula pra ponto
                let valRaw = el.value.replace(',', '.'); 
                let qtd = parseFloat(valRaw)||0;

                if(prod.categoria === 'carnes') {
                    if(qtd > parseFloat(prod.estoque)) {
                        el.style.borderColor = "red"; 
                    } else {
                        el.style.borderColor = ""; 
                    }
                }

                if(qtd > 0) {
                    temItens = true;
                    let sub = qtd * parseFloat(prod.preco);
                    total += sub;

                    let qtdTxt = (prod.categoria === 'carnes') ? qtd.toFixed(3).replace('.', ',') + ' Kg' : parseInt(qtd) + 'x';
                    
                    htmlResumo += `
                        <div class="d-flex justify-content-between align-items-center mb-1 border-bottom pb-1 small">
                            <span><b>${qtdTxt}</b> ${prod.nome}</span>
                            <span>R$ ${sub.toFixed(2).replace('.',',')}</span>
                        </div>
                    `;
                }
            });

            document.getElementById('tot').innerText = total.toFixed(2).replace('.',',');

            let divResumo = document.getElementById('resumoCarrinho');
            if(temItens) {
                divResumo.innerHTML = htmlResumo;
            } else {
                divResumo.innerHTML = '<p class="text-center text-muted small fst-italic">Nenhum item selecionado.</p>';
            }
        }
    </script>
</body>
</html>