<?php
// 1. FORÇA UTF-8 NO NAVEGADOR
header('Content-Type: text/html; charset=utf-8');
mb_internal_encoding("UTF-8");

require 'conexao.php';
$msg = ''; 
$sucesso = false;

// Busca Produtos
$stmt = $pdo->query("SELECT * FROM produtos ORDER BY categoria DESC, nome ASC");
$produtos_db = $stmt->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cli = $_POST['cliente']; 
    $tel = $_POST['telefone']; 
    $obs = $_POST['obs'];
    
    $itens_vendidos = []; 
    $total = 0; 
    $erro_estoque = false;

    foreach ($produtos_db as $prod) {
        $id = $prod['id'];
        $qtd_post = $_POST['qtd_' . $id] ?? 0;

        // --- TRATAMENTO INTELIGENTE DA VÍRGULA ---
        if ($prod['categoria'] == 'carnes') {
            // Troca vírgula por ponto para o PHP somar certo
            $qtd_formatada = str_replace(',', '.', $qtd_post);
            $qtd = floatval($qtd_formatada);
        } else {
            $qtd = intval($qtd_post);
        }
        
        if ($qtd > 0) {
            // VALIDA ESTOQUE NO SERVIDOR
            if ($qtd > $prod['estoque']) {
                $msg = "<div class='alert alert-danger shadow'>⚠️ Estoque insuficiente: <b>{$prod['nome']}</b> (Restam: ".floatval($prod['estoque']).")</div>";
                $erro_estoque = true; 
                break;
            }
            $subtotal = $qtd * $prod['preco']; 
            $total += $subtotal;
            $itens_vendidos[] = ['id' => $id, 'nome' => $prod['nome'], 'qtd' => $qtd, 'preco' => $prod['preco'], 'subtotal' => $subtotal, 'categoria' => $prod['categoria']];
        }
    }

    if (!$erro_estoque && $total > 0) {
        // BAIXA ESTOQUE
        foreach($itens_vendidos as $item) {
            $pdo->query("UPDATE produtos SET estoque = estoque - {$item['qtd']} WHERE id = {$item['id']}");
        }
        
        $json = json_encode($itens_vendidos, JSON_UNESCAPED_UNICODE);
        $sql = "INSERT INTO pedidos (cliente, telefone, observacao, valor_total, itens_json, data_pedido, pago, entregue) VALUES (?, ?, ?, ?, ?, NOW(), 0, 0)";
        $stmt = $pdo->prepare($sql);
        
        if($stmt->execute([$cli, $tel, $obs, $total, $json])) {
            $id_pedido = $pdo->lastInsertId(); 
            $sucesso = true;
            
            // Resumo Visual (Tela de Sucesso)
            $resumoHTML = '<ul class="list-group my-3 text-start">';
            foreach($itens_vendidos as $i) {
                $qShow = ($i['categoria']=='carnes') ? number_format($i['qtd'],3,',','.').' Kg' : intval($i['qtd']).'x';
                $resumoHTML .= "<li class='list-group-item'>✔️ <b>$qShow</b> {$i['nome']}</li>";
            }
            $resumoHTML .= '</ul>';
            
            $msg = "<div class='alert alert-success text-center p-4'>
                        <h2 class='fw-bold'>✅ PEDIDO #$id_pedido RECEBIDO!</h2>
                        $resumoHTML
                        <h3 class='text-success'>Total: R$ ".number_format($total,2,',','.')."</h3>
                        <a href='cliente.php' class='btn btn-outline-success mt-3'>Fazer Novo Pedido</a>
                    </div>";
        }
    } else if (!$erro_estoque && empty($msg)) {
        $msg = "<div class='alert alert-warning mb-3'>⚠️ Selecione algum item.</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Cardápio Online</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body { background: #f8f9fa; padding-bottom: 120px; }
        .sticky-bottom-bar { position: fixed; bottom: 0; left: 0; right: 0; background: white; padding: 10px; box-shadow: 0 -2px 10px rgba(0,0,0,0.1); z-index: 1000; }
        .esgotado { opacity: 0.6; pointer-events: none; background: #f0f0f0; }
        .badge-estoque { font-size: 0.7rem; background: #e9ecef; color: #555; padding: 2px 6px; border-radius: 4px; }
        .section-title { padding: 8px; border-radius: 5px; color: white; font-weight: bold; margin-bottom: 10px; display: flex; align-items: center; gap: 8px; }
    </style>
</head>
<body>
    <nav class="navbar navbar-dark bg-dark mb-3 shadow">
        <div class="container justify-content-center">
            <span class="navbar-brand fw-bold m-0">
                <img src="img/logomais.png" height="30" class="me-2" style="background:white; border-radius:50%; padding:2px;"> Pedido Online
            </span>
        </div>
    </nav>
    
    <div class="container">
        <?php if($sucesso): ?>
            <?= $msg ?>
        <?php else: ?>
            <?= $msg ?>
            <form method="POST" id="formPedido">
                <div class="card mb-3 p-3 shadow-sm border-0">
                    <h6 class="fw-bold text-muted"><i class="bi bi-person"></i> SEUS DADOS</h6>
                    <input type="text" name="cliente" class="form-control mb-2" required placeholder="Seu Nome">
                    <input type="tel" name="telefone" class="form-control" placeholder="WhatsApp (Opcional)">
                </div>

                <?php 
                $cats = [
                    'assados'    => ['warning', 'bi-fire'], 
                    'carnes'     => ['dark', 'bi-tag'], 
                    'guarnicoes' => ['danger', 'bi-basket'], 
                    'extras'     => ['info', 'bi-plus-circle'], 
                    'bebidas'    => ['success', 'bi-cup-straw'], 
                    'Outros'     => ['secondary', 'bi-grid']
                ];
                $grupos = []; 
                foreach($produtos_db as $p) { $grupos[$p['categoria']?:'Outros'][] = $p; }
                ?>

                <?php foreach($cats as $cat => $vis): ?>
                    <?php if(isset($grupos[$cat])): ?>
                        <div class="section-title bg-<?= $vis[0] ?>">
                            <i class="bi <?= $vis[1] ?>"></i> <?= mb_strtoupper($cat, 'UTF-8') ?>
                        </div>
                        
                        <?php foreach($grupos[$cat] as $prod): ?>
                            <?php $semEstoque = ($prod['estoque'] <= 0); ?>
                            <div class="d-flex justify-content-between align-items-center p-3 mb-2 bg-white rounded shadow-sm border <?= $semEstoque ? 'esgotado' : '' ?>">
                                <div class="col-7">
                                    <div class="fw-bold"><?= $prod['nome'] ?></div>
                                    <div class="small text-primary fw-bold">
                                        R$ <?= number_format($prod['preco'], 2, ',', '.') ?><?= $cat=='carnes'?'/Kg':'' ?>
                                    </div>
                                    <?php if($semEstoque): ?>
                                        <span class="badge bg-danger">ESGOTADO</span>
                                    <?php else: ?>
                                        <span class="badge-estoque">Restam: <?= floatval($prod['estoque']) ?></span>
                                    <?php endif; ?>
                                </div>
                                <div class="col-5 text-end">
                                    <?php if($cat == 'carnes'): ?>
                                        <div class="input-group input-group-sm">
                                            <span class="input-group-text">Kg</span>
                                            <input type="text" inputmode="numeric" 
                                                   name="qtd_<?= $prod['id'] ?>" 
                                                   data-nome="<?= $prod['nome'] ?>" 
                                                   class="form-control text-center fw-bold" 
                                                   placeholder="0,000" 
                                                   onkeyup="mascaraPeso(this); calc()" 
                                                   onchange="calc()">
                                        </div>
                                    <?php else: ?>
                                        <div class="input-group input-group-sm">
                                            <button type="button" class="btn btn-outline-secondary" onclick="add(<?= $prod['id'] ?>, -1)">-</button>
                                            <input type="number" name="qtd_<?= $prod['id'] ?>" id="qtd_<?= $prod['id'] ?>" 
                                                   data-nome="<?= $prod['nome'] ?>" 
                                                   class="form-control text-center fw-bold" value="0" readonly>
                                            <button type="button" class="btn btn-outline-secondary" onclick="add(<?= $prod['id'] ?>, 1)">+</button>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <input type="hidden" id="estoque_<?= $prod['id'] ?>" value="<?= $prod['estoque'] ?>">
                                    <input type="hidden" id="preco_<?= $prod['id'] ?>" value="<?= $prod['preco'] ?>">
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                <?php endforeach; ?>

                <textarea name="obs" class="form-control mb-3" placeholder="Observações (Opcional)..."></textarea>
                
                <div id="areaResumo" class="mb-2"></div>

                <div class="sticky-bottom-bar d-flex justify-content-between align-items-center">
                    <div>Total: <b class="text-success fs-5">R$ <span id="totalDisplay">0,00</span></b></div>
                    <button class="btn btn-danger fw-bold shadow">ENVIAR PEDIDO</button>
                </div>
            </form>
        <?php endif; ?>
    </div>
    
    <script>
        // MÁSCARA INTELIGENTE (Mesma do PDV)
        function mascaraPeso(i) {
            var v = i.value.replace(/\D/g,'');
            v = (v/1000).toFixed(3) + '';
            v = v.replace(".", ",");
            i.value = v;
        }

        function add(id, val) {
            let el = document.getElementById('qtd_'+id);
            let max = parseFloat(document.getElementById('estoque_'+id).value);
            
            let novo = (parseInt(el.value) || 0) + val;
            
            if(novo < 0) novo = 0;
            if(novo > max) { 
                alert("Limite de estoque: " + max); 
                novo = max; 
            }
            
            el.value = novo;
            calc();
        }

        function calc() {
            let total = 0;
            let resumoHTML = '<div class="card shadow-sm border-warning mb-2"><div class="card-header bg-warning bg-opacity-25 fw-bold small text-dark"><i class="bi bi-cart-check"></i> ITENS DO PEDIDO:</div><ul class="list-group list-group-flush small">';
            let temItem = false;

            // Varre todos os inputs (tanto texto/máscara quanto number)
            document.querySelectorAll('input[name^="qtd_"]').forEach(el => {
                let id = el.name.split('_')[1];
                let preco = parseFloat(document.getElementById('preco_'+id).value);
                let nome = el.getAttribute('data-nome');
                let max = parseFloat(document.getElementById('estoque_'+id).value);

                // TRATAMENTO DA QUANTIDADE
                // Se for texto (com vírgula), converte pra float. Se for number, pega direto.
                let valRaw = el.value.replace(',', '.'); 
                let qtd = parseFloat(valRaw) || 0;

                // Validação visual de estoque
                if(qtd > max) {
                    el.style.borderColor = 'red';
                } else {
                    el.style.borderColor = '';
                }

                if(qtd > 0) {
                    temItem = true;
                    let sub = qtd * preco;
                    total += sub;
                    
                    // Se o input original tem vírgula (é texto), formata como Kg
                    // Se for number, formata como unidade
                    let qtdShow = (el.type === 'text') ? qtd.toFixed(3).replace('.', ',') + ' Kg' : parseInt(qtd) + 'x';

                    resumoHTML += `
                        <li class="list-group-item d-flex justify-content-between align-items-center px-2 py-1">
                            <div><b>${qtdShow}</b> ${nome}</div>
                            <div class="fw-bold">R$ ${sub.toFixed(2).replace('.',',')}</div>
                        </li>
                    `;
                }
            });

            resumoHTML += '</ul></div>';
            
            // Exibe resumo e total
            document.getElementById('areaResumo').innerHTML = temItem ? resumoHTML : '';
            document.getElementById('totalDisplay').innerText = total.toFixed(2).replace('.',',');
        }
    </script>
</body>
</html>