<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>App Entregador</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        /* --- DESIGN DARK MODE (NOTURNO) --- */
        body { font-family: 'Segoe UI', sans-serif; background: #121212; color: #e0e0e0; margin: 0; padding: 15px; }
        
        /* TELA DE LOGIN */
        #tela-login { text-align: center; margin-top: 40px; }
        .titulo-login { color: #FF6B00; margin-bottom: 5px; }
        .subtitulo-login { color: #888; margin-bottom: 30px; font-size: 0.9rem; }

        /* Botões de Login Dinâmicos */
        #area-botoes-login { display: flex; flex-direction: column; gap: 15px; }
        .btn-moto { 
            width: 100%; padding: 18px; 
            background: #2d2d2d; color: white; border: 1px solid #333; 
            font-size: 1.1rem; border-radius: 12px; cursor: pointer; 
            transition: all 0.2s; font-weight: 600;
        }
        .btn-moto:active { background: #FF6B00; border-color: #FF6B00; color: #000; transform: scale(0.98); }

        /* CABEÇALHO DO APP */
        #tela-lista { display: none; }
        .header { 
            display: flex; justify-content: space-between; align-items: center; 
            margin-bottom: 20px; border-bottom: 1px solid #333; padding-bottom: 15px; 
            position: sticky; top: 0; background: #121212; z-index: 10;
        }
        .moto-badge { background: #FF6B00; padding: 5px 12px; border-radius: 20px; font-weight: bold; color: #000; font-size: 0.9rem;}
        
        /* CARD DO PEDIDO */
        .card { 
            background: #1e1e1e; border-radius: 12px; padding: 20px; 
            margin-bottom: 25px; border-left: 5px solid #FF6B00; 
            box-shadow: 0 4px 15px rgba(0,0,0,0.4);
        }
        .card-topo { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }
        .card h2 { margin: 0; font-size: 1.4rem; color: #fff; }
        .hora { font-size: 0.8rem; color: #777; }
        
        .endereco { color: #ccc; margin: 10px 0; font-size: 1.05rem; line-height: 1.4; display: flex; align-items: flex-start; gap: 8px;}
        
        /* OBSERVAÇÃO DESTAQUE */
        .obs-box { background: #fff3cd; color: #856404; padding: 10px; border-radius: 5px; margin: 10px 0; font-size: 0.95rem; font-weight: bold; border: 1px solid #ffeeba; }

        /* LISTA DE CONFERÊNCIA (ITENS) */
        .lista-itens {
            background: #252525; padding: 12px; border-radius: 8px; margin: 15px 0;
            list-style: none; border: 1px solid #333;
        }
        .lista-itens li {
            border-bottom: 1px dashed #444; padding: 8px 0;
            display: flex; justify-content: space-between; font-size: 0.95rem;
        }
        .lista-itens li:last-child { border-bottom: none; }
        .obs-item { display: block; color: #ff5252; font-size: 0.85rem; margin-top: 3px; font-style: italic;}

        .total-destaque { 
            color: #FF6B00; font-size: 1.5rem; font-weight: bold; 
            display: block; margin-top: 15px; text-align: right; 
        }
        
        /* BOTÕES DE AÇÃO */
        .btn-acao {
            display: flex; justify-content: center; align-items: center; gap: 10px;
            width: 100%; padding: 14px; border-radius: 8px; margin-top: 12px;
            font-weight: bold; font-size: 1rem; text-decoration: none; 
            border: none; cursor: pointer; box-sizing: border-box; color: white;
            text-transform: uppercase; letter-spacing: 0.5px;
        }

        .btn-gps { background: #27ae60; box-shadow: 0 4px 0 #1e8449; } /* Verde */
        .btn-gps:active { box-shadow: none; transform: translateY(4px); }

        .btn-concluir { background: #c0392b; box-shadow: 0 4px 0 #922b21; } /* Vermelho */
        .btn-concluir:active { box-shadow: none; transform: translateY(4px); }
        
        /* Estado Vazio */
        .empty-state { text-align: center; margin-top: 80px; opacity: 0.6; }
        .empty-icon { font-size: 4rem; color: #333; margin-bottom: 20px; }

    </style>
</head>
<body>

    <audio id="som-alerta" src="https://assets.mixkit.co/active_storage/sfx/2869/2869-preview.mp3" preload="auto"></audio>

    <div id="tela-login">
        <h2 class="titulo-login"><i class="fas fa-motorcycle"></i> App Entregas</h2>
        <p class="subtitulo-login">Selecione seu nome para iniciar:</p>
        
        <div id="area-botoes-login">
            <p>Carregando equipe...</p>
        </div>
    </div>

    <div id="tela-lista">
        <div class="header">
            <div style="display:flex; align-items:center; gap:10px;">
                <span id="nome-moto" class="moto-badge">...</span>
                <span id="status-conn" style="font-size:10px; color:#4caf50;">● Online</span>
            </div>
            <button onclick="sair()" style="background:none; border:none; color:#777; text-decoration:underline; cursor:pointer;">Sair</button>
        </div>
        
        <div id="lista-pedidos">
            </div>
    </div>

    <script>
        let meuId = localStorage.getItem('delivery_moto_id');
        let meuNome = localStorage.getItem('delivery_moto_nome');
        let idsConhecidos = []; 

        document.addEventListener("DOMContentLoaded", () => {
            carregarBotoesLogin(); 
            if (meuId && meuNome) {
                mostrarTelaPedidos(meuId, meuNome);
            }
        });

        function carregarBotoesLogin() {
            fetch('../api/get_entregadores.php')
                .then(res => res.json())
                .then(motos => {
                    const area = document.getElementById('area-botoes-login');
                    area.innerHTML = '';

                    if(motos.length === 0) {
                        area.innerHTML = '<p style="color:red">Nenhum entregador cadastrado no Admin.</p>';
                        return;
                    }

                    motos.forEach(m => {
                        const btn = document.createElement('button');
                        btn.className = 'btn-moto';
                        btn.innerHTML = `${m.nome}`;
                        btn.onclick = () => logar(m.id, m.nome);
                        area.appendChild(btn);
                    });
                })
                .catch(err => {
                    document.getElementById('area-botoes-login').innerHTML = '<p>Erro de conexão.</p>';
                });
        }

        function logar(id, nome) {
            const audio = document.getElementById('som-alerta');
            audio.play().then(() => { audio.pause(); audio.currentTime = 0; }).catch(e => {});

            localStorage.setItem('delivery_moto_id', id);
            localStorage.setItem('delivery_moto_nome', nome);
            mostrarTelaPedidos(id, nome);
        }

        function sair() {
            if(confirm("Deseja sair e desconectar?")) {
                localStorage.removeItem('delivery_moto_id');
                localStorage.removeItem('delivery_moto_nome');
                location.reload();
            }
        }

        function mostrarTelaPedidos(id, nome) {
            meuId = id; 
            document.getElementById('tela-login').style.display = 'none';
            document.getElementById('tela-lista').style.display = 'block';
            document.getElementById('nome-moto').innerText = nome;
            carregarMeusPedidos();
            setInterval(carregarMeusPedidos, 5000); 
        }

        function carregarMeusPedidos() {
            fetch('../api/get_pedidos.php')
                .then(res => res.json())
                .then(todosPedidos => {
                    const meus = todosPedidos.filter(p => p.status === 'saiu_entrega' && p.entregador_id == meuId);
                    verificarNovidades(meus);
                    renderizar(meus);
                })
                .catch(err => console.log("Tentando reconectar..."));
        }

        function verificarNovidades(pedidosAtuais) {
            const novosIds = pedidosAtuais.map(p => p.id);
            const temNovo = novosIds.some(id => !idsConhecidos.includes(id));
            
            if (temNovo && pedidosAtuais.length > 0) {
                const audio = document.getElementById('som-alerta');
                audio.play().catch(e => {});
                if (navigator.vibrate) navigator.vibrate([500, 200, 500, 200, 500]);
            }
            idsConhecidos = novosIds;
        }

        function renderizar(pedidos) {
            const container = document.getElementById('lista-pedidos');
            
            if(pedidos.length === 0) {
                container.innerHTML = `
                    <div class="empty-state">
                        <i class="fas fa-motorcycle empty-icon"></i>
                        <p>Tudo entregue por enquanto.<br>Aguarde novos pedidos.</p>
                    </div>`;
                return;
            }

            container.innerHTML = '';
            pedidos.forEach(p => {
                const linkMap = `https://www.google.com/maps/dir/?api=1&destination=${p.lat},${p.lng}`;

                // --- GERA OBS EM AMARELO SE EXISTIR ---
                let obsHtml = '';
                if (p.observacao) {
                    obsHtml = `<div class="obs-box"><i class="fas fa-exclamation-triangle"></i> OBS: ${p.observacao}</div>`;
                }

                // --- GERA LISTA DE ITENS ---
                let itensHtml = '<ul class="lista-itens">';
                p.itens.forEach(item => {
                    let qtd = item.unidade === 'KG' 
                        ? parseFloat(item.quantidade).toFixed(3) + 'kg' 
                        : parseInt(item.quantidade) + 'un';
                    
                    itensHtml += `
                        <li>
                            <span><strong>${qtd}</strong> ${item.nome_produto}</span>
                            ${item.observacao ? `<br><span class="obs-item">⚠️ ${item.observacao}</span>` : ''}
                        </li>`;
                });
                itensHtml += '</ul>';

                let html = `
                    <div class="card">
                        <div class="card-topo">
                            <h2>#${p.id} ${p.cliente_nome.split(' ')[0]}</h2>
                            <span class="hora"><i class="far fa-clock"></i> ${p.data_pedido.substring(11,16)}</span>
                        </div>
                        
                        <div class="endereco">
                            <i class="fas fa-map-marker-alt" style="color:#FF6B00; margin-top:3px;"></i>
                            <span>${p.endereco_escrito}</span>
                        </div>
                        
                        ${obsHtml} ${itensHtml}

                        <span class="total-destaque">R$ ${parseFloat(p.total).toFixed(2).replace('.', ',')}</span>
                        
                        <a href="${linkMap}" target="_blank" class="btn-acao btn-gps">
                            <i class="fas fa-location-arrow"></i> ABRIR NO GPS
                        </a>

                        <button class="btn-acao btn-concluir" onclick="entregue(${p.id})">
                            <i class="fas fa-check-circle"></i> FINALIZAR ENTREGA
                        </button>
                    </div>
                `;
                container.innerHTML += html;
            });
        }

        function entregue(id) {
            if(!confirm("Confirma que entregou e recebeu o pagamento?")) return;
            document.getElementById('lista-pedidos').innerHTML = '<p style="text-align:center; margin-top:50px;">Atualizando...</p>';

            fetch('../api/atualizar_status.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({ id: id, status: 'concluido' })
            }).then(() => {
                idsConhecidos = idsConhecidos.filter(x => x !== id);
                carregarMeusPedidos();
            });
        }
    </script>
</body>
</html>