<?php
// entrega/app.php - VERSÃO 7.0 (GPS + NOME DE RUA AUTOMÁTICO)

// --- 1. CONFIGURAÇÕES ---
header("Cache-Control: no-cache, no-store, must-revalidate");
header("Expires: 0");

$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X';

// --- 2. SALVAR PEDIDO ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    header("Content-Type: application/json");
    try {
        $json = file_get_contents("php://input");
        $dados = json_decode($json, true);

        if (!$dados) throw new Exception("Dados inválidos.");

        $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $pdo->beginTransaction();

        $sql = "INSERT INTO pedidos (cliente_nome, cliente_telefone, endereco_escrito, lat, lng, total, frete, observacao, data_pedido, status) 
                VALUES (:nome, :tel, :end, :lat, :lng, :total, :frete, :obs, NOW(), 'pendente')";
        
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':nome' => $dados['cliente_nome'],
            ':tel' => $dados['cliente_telefone'],
            ':end' => $dados['endereco_escrito'],
            ':lat' => $dados['lat'], 
            ':lng' => $dados['lng'],
            ':total' => $dados['total'],
            ':frete' => $dados['frete'],
            ':obs' => $dados['observacao']
        ]);
        
        $pedidoId = $pdo->lastInsertId();

        foreach ($dados['itens'] as $item) {
            $stmtItem = $pdo->prepare("INSERT INTO itens_pedido (pedido_id, produto_id, quantidade, preco_momento) VALUES (:pid, :prod, :qtd, :preco)");
            $stmtItem->execute([':pid'=>$pedidoId, ':prod'=>$item['id'], ':qtd'=>$item['quantidade'], ':preco'=>$item['preco']]);
        }

        $pdo->commit();
        echo json_encode(["sucesso" => true, "id" => $pedidoId]);
        exit;

    } catch (Exception $e) {
        if (isset($pdo) && $pdo->inTransaction()) $pdo->rollBack();
        echo json_encode(["sucesso" => false, "erro" => $e->getMessage()]);
        exit;
    }
}

// --- 3. CARREGAR CARDÁPIO ---
$json_produtos = '[]';
$erro_banco = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $categorias = $pdo->query("SELECT * FROM categorias ORDER BY nome ASC")->fetchAll(PDO::FETCH_ASSOC);

    foreach($categorias as &$cat) {
        $cat['titulo'] = $cat['nome'];
        $stmtProd = $pdo->prepare("SELECT id, nome, descricao, preco, categoria_id, unidade FROM produtos WHERE categoria_id = ? ORDER BY nome ASC");
        $stmtProd->execute([$cat['id']]);
        $cat['produtos'] = $stmtProd->fetchAll(PDO::FETCH_ASSOC);
    }
    
    $final = array_filter($categorias, function($c) { return count($c['produtos']) > 0; });
    $json_produtos = json_encode(array_values($final), JSON_UNESCAPED_UNICODE | JSON_NUMERIC_CHECK);
    if(!$json_produtos) $json_produtos = '[]';

} catch (PDOException $e) {
    $erro_banco = "Erro Conexão: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Cardápio Digital</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root { --primary: #FF6B00; --text-dark: #2d3436; --text-gray: #636e72; --bg-light: #f4f6f8; --white: #ffffff; }
        * { box-sizing: border-box; -webkit-tap-highlight-color: transparent; outline: none; }
        body { font-family: 'Inter', sans-serif; margin: 0; padding: 0; background: var(--bg-light); color: var(--text-dark); padding-bottom: 100px; }
        
        .header { background: var(--white); padding: 15px 20px; position: sticky; top: 0; z-index: 30; box-shadow: 0 2px 10px rgba(0,0,0,0.05); display: flex; justify-content: space-between; align-items: center; }
        .header h1 { margin: 0; font-size: 1.1rem; color: var(--text-dark); display: flex; align-items: center; gap: 8px;}
        .status-badge { background: #dff9fb; color: #22a6b3; padding: 4px 10px; border-radius: 20px; font-size: 0.75rem; font-weight: bold; }

        .nav-container { background: rgba(244, 246, 248, 0.95); position: sticky; top: 58px; z-index: 29; padding: 10px 0 10px 15px; backdrop-filter: blur(5px); }
        .nav-categorias { display: flex; overflow-x: auto; gap: 10px; padding-right: 15px; scrollbar-width: none; }
        .nav-categorias::-webkit-scrollbar { display: none; }
        .cat-link { padding: 8px 16px; background: var(--white); color: var(--text-gray); text-decoration: none; border-radius: 25px; font-size: 0.9rem; font-weight: 600; white-space: nowrap; box-shadow: 0 2px 5px rgba(0,0,0,0.03); border: 1px solid #eee; transition: all 0.2s; }
        .cat-link.ativo { background: var(--primary); color: white; border-color: var(--primary); box-shadow: 0 4px 10px rgba(255, 107, 0, 0.3); }

        .categoria-section { margin-bottom: 20px; scroll-margin-top: 120px; }
        .categoria-titulo { padding: 15px 20px 5px 20px; color: var(--text-dark); font-weight: 800; font-size: 1.3rem; }
        .produto-card { background: var(--white); margin: 15px 20px; padding: 15px; border-radius: 12px; box-shadow: 0 4px 15px rgba(0,0,0,0.08); }
        .prod-info h3 { margin: 0; font-size: 1.05rem; font-weight: 700; color: var(--text-dark); }
        .prod-desc { font-size: 0.85rem; color: var(--text-gray); line-height: 1.4; margin-bottom: 12px; }
        .prod-footer { display: flex; justify-content: space-between; align-items: center; margin-top: 15px; border-top: 1px dashed #eee; padding-top: 12px; }
        .prod-preco { color: var(--primary); font-weight: 800; font-size: 1.15rem; }

        .controles-wrapper { display: flex; gap: 8px; align-items: center; }
        .box-qtd { display: flex; align-items: center; background: #f1f2f6; border-radius: 8px; height: 36px; padding: 0 5px; }
        .btn-qtd-mini { width: 30px; height: 100%; border: none; background: transparent; font-size: 1.2rem; color: var(--primary); cursor: pointer; display: flex; align-items: center; justify-content: center; }
        .input-qtd-manual { width: 50px; text-align: center; border: none; background: transparent; font-weight: 700; font-size: 0.95rem; color: var(--text-dark); }
        .btn-add { background: var(--text-dark); color: white; border: none; height: 36px; padding: 0 15px; border-radius: 8px; font-weight: 600; font-size: 0.85rem; cursor: pointer; box-shadow: 0 4px 6px rgba(0,0,0,0.1); transition: all 0.2s; }
        .btn-add.sucesso { background: #20bf6b; transform: scale(1.05); }

        .sacola-float { position: fixed; bottom: 20px; left: 20px; right: 20px; background: var(--text-dark); color: white; padding: 15px 20px; border-radius: 15px; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 10px 25px rgba(0,0,0,0.3); z-index: 990; cursor: pointer; transition: transform 0.2s; }
        .sacola-float:active { transform: scale(0.98); }
        .sacola-total { font-size: 1.2rem; font-weight: 700; }
        .btn-ver-sacola { background: var(--primary); color: white; border: none; padding: 8px 15px; border-radius: 8px; font-weight: bold; font-size: 0.9rem; }

        .modal-overlay { display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.6); z-index: 9999; backdrop-filter: blur(3px); align-items: flex-end; opacity: 0; transition: opacity 0.3s; }
        .modal-overlay.open { display: flex; opacity: 1; }
        .modal-sheet { background: var(--white); width: 100%; max-height: 90vh; border-radius: 20px 20px 0 0; padding: 25px 20px; overflow-y: auto; transform: translateY(100%); transition: transform 0.3s; box-shadow: 0 -5px 30px rgba(0,0,0,0.1); }
        .modal-overlay.open .modal-sheet { transform: translateY(0); }

        .item-resumo { display: flex; justify-content: space-between; align-items: center; padding: 12px 0; border-bottom: 1px solid #f1f2f6; }
        .btn-lixo { color: #ff4757; background: #ffe0e3; border: none; width: 30px; height: 30px; border-radius: 50%; cursor: pointer;}
        
        .input-group { margin-bottom: 15px; }
        .custom-input { width: 100%; padding: 14px; background: #f8f9fa; border: 1px solid #eee; border-radius: 10px; font-size: 1rem; outline: none; transition: 0.2s; }
        .custom-input:focus { border-color: var(--primary); background: white; }
        
        .resumo-box { background: #f8f9fa; padding: 15px; border-radius: 12px; margin: 20px 0; }
        .linha-valor { display: flex; justify-content: space-between; margin-bottom: 8px; color: var(--text-gray); font-size: 0.9rem;}
        .linha-total { display: flex; justify-content: space-between; margin-top: 10px; padding-top: 10px; border-top: 1px dashed #ccc; font-weight: 800; font-size: 1.3rem; color: var(--text-dark); }
        .btn-enviar { width: 100%; padding: 16px; background: var(--primary); color: white; border: none; border-radius: 12px; font-size: 1.1rem; font-weight: 700; cursor: pointer; box-shadow: 0 5px 15px rgba(255, 107, 0, 0.3); display: flex; justify-content: center; gap: 10px; align-items: center; }

        .gps-wrapper { display: flex; gap: 8px; }
        .btn-gps { width: 55px; background: #3498db; color: white; border: none; border-radius: 10px; font-size: 1.2rem; cursor: pointer; display: flex; justify-content: center; align-items: center; }
        .btn-gps:active { background: #2980b9; }
        .loading-spin { animation: spin 1s linear infinite; }
        @keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
    </style>
</head>
<body>

    <div class="header">
        <h1><i class="fas fa-motorcycle" style="color:var(--primary)"></i> DeliveryApp</h1>
        <div class="status-badge">Aberto</div>
    </div>

    <div class="nav-container"><div class="nav-categorias" id="nav-cat"></div></div>

    <?php if($erro_banco): ?>
        <div style="background:#ff4757; color:white; padding:15px; margin:15px; border-radius:10px; text-align:center;">
            Erro: <?php echo $erro_banco; ?>
        </div>
    <?php endif; ?>

    <div id="cardapio-lista" style="padding-bottom: 80px;">
        <p style="text-align:center; padding:40px; color:#aaa;">Carregando...</p>
    </div>

    <div class="sacola-float" id="barra-sacola" style="display:none" onclick="abrirCheckout()">
        <div class="sacola-info">
            <small>Total do Pedido</small>
            <div class="sacola-total" id="total-sacola">R$ 0,00</div>
        </div>
        <button class="btn-ver-sacola" onclick="event.stopPropagation(); abrirCheckout()">Ver Sacola <i class="fas fa-shopping-bag"></i></button>
    </div>

    <div class="modal-overlay" id="modal-checkout" onclick="fecharCheckout(event)">
        <div class="modal-sheet">
            <div style="width:40px; height:5px; background:#ddd; border-radius:5px; margin:0 auto 20px auto;"></div>
            <h2 style="margin:0 0 20px 0; font-size:1.5rem;">Sua Sacola</h2>
            <div id="lista-resumo"></div>

            <h3 style="margin: 25px 0 15px 0; font-size:1.1rem;">Entrega</h3>
            
            <div class="input-group"><input type="text" id="cli-nome" class="custom-input" placeholder="Seu Nome"></div>
            <div class="input-group"><input type="tel" id="cli-tel" class="custom-input" placeholder="Telefone / WhatsApp"></div>
            
            <div class="input-group gps-wrapper">
                <input type="text" id="cli-end" class="custom-input" placeholder="Endereço Completo">
                <button type="button" class="btn-gps" onclick="pegarGPS()" title="Usar localização">
                    <i class="fas fa-search-location" id="icon-gps"></i>
                </button>
            </div>

            <div class="input-group"><textarea id="cli-obs" class="custom-input" style="height:80px; resize:none;" placeholder="Observações (Troco, tirar cebola...)"></textarea></div>

            <div class="resumo-box">
                <div class="linha-valor"><span>Subtotal</span> <span id="res-subtotal">R$ 0,00</span></div>
                <div class="linha-valor" style="color:var(--primary)"><span>Taxa Entrega</span> <span id="res-frete">R$ 0,00</span></div>
                <div class="linha-total"><span>TOTAL</span> <span id="res-total">R$ 0,00</span></div>
            </div>

            <button class="btn-enviar" onclick="enviarPedido()">CONFIRMAR PEDIDO</button>
            <br><br>
        </div>
    </div>

    <script>
        const DADOS_INICIAIS = <?php echo $json_produtos; ?>;
        const TAXA_ENTREGA = 5.00;
        
        let carrinho = []; 
        let produtosMap = {};
        let pedidoLat = 0;
        let pedidoLng = 0;

        document.addEventListener("DOMContentLoaded", () => {
            if(DADOS_INICIAIS.length > 0) {
                DADOS_INICIAIS.forEach(cat => {
                    cat.produtos.forEach(p => {
                        if(!p.unidade) p.unidade = 'UN';
                        p.preco = Number(p.preco);
                        produtosMap[p.id] = p;
                    });
                });
                renderizarMenu();
                renderizarLista();
            } else {
                document.getElementById('cardapio-lista').innerHTML = '<div style="text-align:center; padding:50px;">Cardápio vazio.</div>';
            }
        });

        // --- GPS INTELIGENTE COM NOME DE RUA (NOMINATIM) ---
        function pegarGPS() {
            const btn = document.getElementById('icon-gps');
            const input = document.getElementById('cli-end');

            if (location.protocol !== 'https:' && location.hostname !== 'localhost') {
                alert("⚠️ Erro: Para usar GPS, acesse com HTTPS.");
                return;
            }

            if (!navigator.geolocation) { alert("Navegador sem GPS."); return; }

            btn.className = "fas fa-spinner loading-spin";

            navigator.geolocation.getCurrentPosition(
                async (pos) => {
                    pedidoLat = pos.coords.latitude;
                    pedidoLng = pos.coords.longitude;
                    
                    // BUSCA O ENDEREÇO NO MAPA (REVERSE GEOCODING)
                    try {
                        const url = `https://nominatim.openstreetmap.org/reverse?format=json&lat=${pedidoLat}&lon=${pedidoLng}`;
                        const resp = await fetch(url);
                        const data = await resp.json();
                        
                        let rua = data.address.road || data.address.pedestrian || "";
                        let bairro = data.address.suburb || data.address.neighbourhood || "";
                        
                        if(rua) {
                            input.value = `${rua}, Nº , ${bairro}`;
                            // Tenta colocar o cursor depois do "Nº "
                            setTimeout(() => {
                                input.focus();
                                input.setSelectionRange(rua.length + 4, rua.length + 4);
                            }, 500);
                        } else {
                            input.value = "📍 Localização exata salva! (Digite o nome da rua)";
                        }
                    } catch (e) {
                        input.value = "📍 Localização salva! (Digite o endereço)";
                    }

                    btn.className = "fas fa-check"; 
                },
                (err) => {
                    console.error(err);
                    alert("Ative o GPS do celular.");
                    btn.className = "fas fa-search-location"; 
                },
                { enableHighAccuracy: true, timeout: 10000 }
            );
        }

        // --- FUNÇÕES DO APP ---
        function renderizarMenu() {
            const nav = document.getElementById('nav-cat');
            let html = '';
            DADOS_INICIAIS.forEach((cat, index) => {
                let active = index === 0 ? 'ativo' : '';
                html += `<a href="#cat-${cat.id}" class="cat-link ${active}" onclick="ativarMenu(this)">${cat.titulo}</a>`;
            });
            nav.innerHTML = html;
        }

        function ativarMenu(elemento) {
            document.querySelectorAll('.cat-link').forEach(el => el.classList.remove('ativo'));
            elemento.classList.add('ativo');
        }

        function renderizarLista() {
            const container = document.getElementById('cardapio-lista');
            container.innerHTML = '';
            DADOS_INICIAIS.forEach(cat => {
                let html = `<div id="cat-${cat.id}" class="categoria-section"><div class="categoria-titulo">${cat.titulo}</div>`;
                cat.produtos.forEach(prod => {
                    let valorInicial = prod.unidade === 'KG' ? '1.000' : '1';
                    let step = prod.unidade === 'KG' ? '0.100' : '1';
                    let labelUn = prod.unidade === 'KG' ? 'kg' : '';
                    let readonly = prod.unidade === 'UN' ? 'readonly' : ''; 
                    html += `
                        <div class="produto-card">
                            <div class="prod-header">
                                <div class="prod-info"><h3>${prod.nome}</h3><div class="prod-desc">${prod.descricao || ''}</div></div>
                            </div>
                            <div class="prod-footer">
                                <div class="prod-preco">R$ ${prod.preco.toFixed(2).replace('.', ',')}<span style="font-size:0.8rem; font-weight:normal; color:#999">/${prod.unidade}</span></div>
                                <div class="controles-wrapper">
                                    <div class="box-qtd">
                                        <button class="btn-qtd-mini" onclick="ajustarQtd(${prod.id}, -1)">-</button>
                                        <input type="${prod.unidade==='KG'?'number':'text'}" step="${step}" ${readonly} class="input-qtd-manual" id="input-${prod.id}" value="${valorInicial}">
                                        <div style="font-size:0.8rem; color:#aaa; margin-right:5px;">${labelUn}</div>
                                        <button class="btn-qtd-mini" onclick="ajustarQtd(${prod.id}, 1)">+</button>
                                    </div>
                                    <button class="btn-add" id="btn-add-${prod.id}" onclick="adicionarAoCarrinho(${prod.id})">ADICIONAR</button>
                                </div>
                            </div>
                        </div>
                    `;
                });
                container.innerHTML += html + `</div>`;
            });
        }

        function ajustarQtd(id, dir) {
            const input = document.getElementById(`input-${id}`);
            const prod = produtosMap[id];
            let val = parseFloat(input.value);
            let passo = prod.unidade === 'KG' ? 0.100 : 1;
            if(dir > 0) val += passo; else val -= passo;
            if(val < passo) val = passo;
            input.value = prod.unidade === 'KG' ? val.toFixed(3) : parseInt(val);
        }

        function adicionarAoCarrinho(id) {
            const input = document.getElementById(`input-${id}`);
            const btn = document.getElementById(`btn-add-${id}`);
            const prod = produtosMap[id];
            let qtd = parseFloat(input.value);
            if(isNaN(qtd) || qtd <= 0) return;
            let item = carrinho.find(i => i.id === id);
            if(item) item.quantidade += qtd; else carrinho.push({ id: id, quantidade: qtd });
            let textoAntigo = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-check"></i>'; btn.classList.add('sucesso');
            setTimeout(() => { btn.innerHTML = textoAntigo; btn.classList.remove('sucesso'); if(prod.unidade !== 'KG') input.value = 1; }, 1000);
            atualizarBarra();
        }

        function atualizarBarra() {
            const barra = document.getElementById('barra-sacola');
            const totalEl = document.getElementById('total-sacola');
            if(carrinho.length === 0) { barra.style.display = 'none'; return; }
            let total = carrinho.reduce((acc, i) => acc + (i.quantidade * produtosMap[i.id].preco), 0);
            totalEl.innerText = total.toLocaleString('pt-BR', {style: 'currency', currency: 'BRL'});
            barra.style.display = 'flex';
        }

        function abrirCheckout() {
            const lista = document.getElementById('lista-resumo');
            const modal = document.getElementById('modal-checkout');
            lista.innerHTML = '';
            let subtotal = 0;
            carrinho.forEach(i => {
                let p = produtosMap[i.id];
                if(p) { 
                    let totalItem = i.quantidade * p.preco;
                    subtotal += totalItem;
                    let displayQtd = p.unidade === 'KG' ? i.quantidade.toFixed(3) + 'kg' : i.quantidade + 'x';
                    lista.innerHTML += `<div class="item-resumo"><div style="flex:1"><div style="font-weight:700; color:var(--text-dark)">${p.nome}</div><small style="color:var(--text-gray)">${displayQtd} · R$ ${p.preco.toFixed(2)}</small></div><div style="font-weight:bold; margin-right:15px">R$ ${totalItem.toFixed(2)}</div><button class="btn-lixo" onclick="removerItem(${i.id})"><i class="fas fa-trash-alt"></i></button></div>`;
                }
            });
            document.getElementById('res-subtotal').innerText = subtotal.toLocaleString('pt-BR', {style: 'currency', currency: 'BRL'});
            document.getElementById('res-frete').innerText = TAXA_ENTREGA.toLocaleString('pt-BR', {style: 'currency', currency: 'BRL'});
            document.getElementById('res-total').innerText = (subtotal + TAXA_ENTREGA).toLocaleString('pt-BR', {style: 'currency', currency: 'BRL'});
            modal.classList.add('open');
        }

        function fecharCheckout(e) { if (e.target.classList.contains('modal-overlay')) document.getElementById('modal-checkout').classList.remove('open'); }
        function removerItem(id) { carrinho = carrinho.filter(i => i.id !== id); if(carrinho.length === 0) { document.getElementById('modal-checkout').classList.remove('open'); document.getElementById('barra-sacola').style.display = 'none'; } else { abrirCheckout(); atualizarBarra(); } }

        function enviarPedido() {
            const nome = document.getElementById('cli-nome').value;
            const tel = document.getElementById('cli-tel').value;
            const end = document.getElementById('cli-end').value;
            const obs = document.getElementById('cli-obs').value;

            if(!nome || !tel || !end) { alert("Por favor, preencha Nome, Telefone e Endereço."); return; }

            const btn = document.querySelector('.btn-enviar');
            let txtOriginal = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> ENVIANDO...'; btn.disabled = true;

            let itensEnvio = carrinho.map(i => { return {id: i.id, quantidade: i.quantidade, preco: produtosMap[i.id].preco} });
            let total = carrinho.reduce((acc, i) => acc + (i.quantidade * produtosMap[i.id].preco), 0) + TAXA_ENTREGA;

            fetch(window.location.href, {
                method: 'POST',
                headers: {'Content-Type': 'application/json'},
                body: JSON.stringify({
                    cliente_nome: nome, cliente_telefone: tel, endereco_escrito: end, observacao: obs,
                    frete: TAXA_ENTREGA, total: total, itens: itensEnvio,
                    lat: pedidoLat, lng: pedidoLng
                })
            })
            .then(res => res.json())
            .then(res => {
                if(res.sucesso) { alert("✅ Pedido Confirmado!"); carrinho = []; location.reload(); }
                else { alert("Erro: " + res.erro); btn.innerHTML = txtOriginal; btn.disabled = false; }
            })
            .catch(err => {
                alert("Erro grave de conexão: " + err.message);
                btn.innerHTML = txtOriginal; btn.disabled = false;
            });
        }
    </script>
</body>
</html>