<?php
// api/salvar_produto_admin.php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X'; // <--- CONFIRA SUA SENHA AQUI
$dsn  = "mysql:host=$host;dbname=$db;charset=utf8mb4";

try {
    $pdo = new PDO($dsn, $user, $pass);
    $dados = json_decode(file_get_contents("php://input"), true);

    // Validação básica
    if (empty($dados['nome']) || empty($dados['preco'])) {
        throw new Exception("Nome e Preço são obrigatórios.");
    }

    if (!empty($dados['id'])) {
        // --- ATUALIZAR (UPDATE) ---
        $sql = "UPDATE produtos SET categoria_id=?, nome=?, descricao=?, preco=?, unidade=? WHERE id=?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $dados['categoria_id'], $dados['nome'], $dados['descricao'], 
            $dados['preco'], $dados['unidade'], $dados['id']
        ]);
        $msg = "Produto atualizado!";
    } else {
        // --- CRIAR NOVO (INSERT) ---
        $sql = "INSERT INTO produtos (categoria_id, nome, descricao, preco, unidade, disponivel) VALUES (?, ?, ?, ?, ?, 1)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            $dados['categoria_id'], $dados['nome'], $dados['descricao'], 
            $dados['preco'], $dados['unidade']
        ]);
        $msg = "Produto criado!";
    }

    echo json_encode(["sucesso" => true, "msg" => $msg]);

} catch (Exception $e) {
    echo json_encode(["sucesso" => false, "erro" => $e->getMessage()]);
}
?>