<?php
// api/salvar_pedido.php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *"); // Permite acesso do App/React

// Configuração do Banco (Idealmente fica em um arquivo separado 'conexao.php')
$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X'; // Sua senha
$dsn  = "mysql:host=$host;dbname=$db;charset=utf8mb4";

try {
    $pdo = new PDO($dsn, $user, $pass, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);

    // 1. Recebe o JSON cru enviado pelo App do Cliente
    $json = file_get_contents("php://input");
    $dados = json_decode($json, true);

    if (!$dados) {
        throw new Exception("Dados inválidos.");
    }

    // 2. Inicia a Transação (Tudo ou Nada)
    $pdo->beginTransaction();

    // 3. Insere o Cabeçalho do Pedido
    $sql_pedido = "INSERT INTO pedidos (cliente_nome, cliente_telefone, endereco_escrito, lat, lng, total, status) 
                   VALUES (:nome, :tel, :end, :lat, :lng, :total, 'pendente')";
    
    $stmt = $pdo->prepare($sql_pedido);
    $stmt->execute([
        ':nome'  => $dados['cliente']['nome'],
        ':tel'   => $dados['cliente']['telefone'],
        ':end'   => $dados['endereco']['descricao'], // Ex: "Rua das Flores, 10"
        ':lat'   => $dados['endereco']['lat'],       // -23.5505 (Vem do Mapa)
        ':lng'   => $dados['endereco']['lng'],       // -46.6333
        ':total' => $dados['total_pagar']
    ]);

    $pedido_id = $pdo->lastInsertId(); // Pega o ID gerado agora

    // 4. Insere os Itens (Loop)
    $sql_item = "INSERT INTO itens_pedido (pedido_id, produto_id, quantidade, preco_momento, observacao) 
                 VALUES (:pid, :prod_id, :qtd, :preco, :obs)";
    $stmt_item = $pdo->prepare($sql_item);

    foreach ($dados['itens'] as $item) {
        // A mágica do KG: Se for frango, qtd = 1. Se for Carne, qtd = 0.500 (decimais aceitos)
        $stmt_item->execute([
            ':pid'     => $pedido_id,
            ':prod_id' => $item['id_produto'],
            ':qtd'     => $item['quantidade'], 
            ':preco'   => $item['preco_unitario'],
            ':obs'     => $item['observacao'] ?? ''
        ]);
    }

    // 5. Confirma a gravação
    $pdo->commit();

    echo json_encode(["sucesso" => true, "pedido_id" => $pedido_id, "msg" => "Pedido realizado!"]);

} catch (Exception $e) {
    if ($pdo->inTransaction()) {
        $pdo->rollBack(); // Desfaz tudo se der erro
    }
    http_response_code(500);
    echo json_encode(["sucesso" => false, "erro" => $e->getMessage()]);
}
?>