<?php
// api/salvar_entregador.php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");

// --- CONFIGURAÇÕES DO BANCO DE DADOS ---
// Preencha com os dados exatos da sua hospedagem
$host = 'localhost';
$db   = 'mgatvcom_pedidos'; // <--- Verifique se o nome do banco está correto
$user = 'mgatvcom_pedidos';        // <--- Seu usuário do banco (ex: mgatv_admin)
$pass = 'fkNw*BV6#A;X';            // <--- A SENHA DO BANCO VAI AQUI
$dsn  = "mysql:host=$host;dbname=$db;charset=utf8mb4";

try {
    // Conecta ao banco
    $pdo = new PDO($dsn, $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Recebe os dados enviados pelo Javascript (JSON)
    $input = file_get_contents("php://input");
    $dados = json_decode($input, true);

    // Validação simples
    if (empty($dados['nome'])) {
        throw new Exception("O nome do entregador é obrigatório.");
    }

    // LÓGICA INTELIGENTE:
    // Se veio um ID, é para EDITAR (Update).
    // Se NÃO veio ID, é para CRIAR NOVO (Insert).
    
    if (!empty($dados['id'])) {
        // --- ATUALIZAR ---
        $sql = "UPDATE entregadores SET nome = :nome WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':nome' => $dados['nome'],
            ':id'   => $dados['id']
        ]);
    } else {
        // --- CRIAR NOVO ---
        $sql = "INSERT INTO entregadores (nome, ativo) VALUES (:nome, 1)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':nome' => $dados['nome']
        ]);
    }

    // Retorna sucesso para o painel
    echo json_encode(["sucesso" => true]);

} catch (Exception $e) {
    // Se der erro (senha errada, tabela inexistente, etc), avisa o painel
    echo json_encode([
        "sucesso" => false, 
        "erro" => $e->getMessage()
    ]);
}
?>