<?php
// api/install_cardapio.php
header("Content-Type: text/html; charset=UTF-8");

// --- 1. Configuração do Banco (Mesma dos outros arquivos) ---
$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X'; // Coloque sua senha do MySQL aqui
$dsn  = "mysql:host=$host;dbname=$db;charset=utf8mb4";

try {
    $pdo = new PDO($dsn, $user, $pass, [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]);
    echo "<h1>Instalando Cardápio...</h1>";

    // --- 2. Limpeza (Opcional: descomente se quiser apagar tudo antes de recriar) ---
    // $pdo->exec("SET FOREIGN_KEY_CHECKS = 0");
    // $pdo->exec("TRUNCATE TABLE itens_pedido");
    // $pdo->exec("TRUNCATE TABLE produtos");
    // $pdo->exec("TRUNCATE TABLE categorias");
    // $pdo->exec("SET FOREIGN_KEY_CHECKS = 1");
    // echo "<p>Tabelas limpas.</p>";

    // --- 3. Função Auxiliar para criar Categoria ---
    function criarCategoria($pdo, $nome, $icone) {
        $stmt = $pdo->prepare("INSERT INTO categorias (nome, icone) VALUES (:nome, :icone)");
        $stmt->execute([':nome' => $nome, ':icone' => $icone]);
        return $pdo->lastInsertId();
    }

    // --- 4. Função Auxiliar para criar Produto ---
    function criarProduto($pdo, $cat_id, $nome, $preco, $unidade, $desc = '') {
        $sql = "INSERT INTO produtos (categoria_id, nome, preco, unidade, descricao) 
                VALUES (:cat, :nome, :preco, :un, :desc)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([
            ':cat' => $cat_id,
            ':nome' => $nome,
            ':preco' => $preco,
            ':un' => $unidade, // 'UN' ou 'KG'
            ':desc' => $desc
        ]);
        echo "<li>Produto criado: <strong>$nome</strong> (R$ $preco / $unidade)</li>";
    }

    // ==========================================
    // INÍCIO DO CADASTRO
    // ==========================================

    // CATEGORIA 1: ASSADOS (Venda por Unidade)
    $catAssados = criarCategoria($pdo, "Frango Assado", "icon-chicken.png");
    echo "<h3>Categoria: Frango Assado (ID: $catAssados)</h3><ul>";
    
    criarProduto($pdo, $catAssados, "Frango Completo", 45.00, "UN", "Acompanha farofa e batatas");
    criarProduto($pdo, $catAssados, "Meio Frango", 25.00, "UN", "Ideal para 1 pessoa");
    echo "</ul>";

    // CATEGORIA 2: CARNES AO KILO (Venda por Peso)
    // Atenção: O preço aqui é o valor de 1 KG
    $catCarnes = criarCategoria($pdo, "Carnes ao Kilo", "icon-meat.png");
    echo "<h3>Categoria: Carnes ao Kilo (ID: $catCarnes)</h3><ul>";

    criarProduto($pdo, $catCarnes, "Maminha na Manteiga", 89.90, "KG", "Carne nobre, preço p/ Kg");
    criarProduto($pdo, $catCarnes, "Costela Bovina", 65.50, "KG", "Assada por 12 horas");
    criarProduto($pdo, $catCarnes, "Cupim Casqueirado", 78.00, "KG", "Corte especial");
    echo "</ul>";

    // CATEGORIA 3: GUARNIÇÕES E EXTRAS (Unidade/Porção)
    $catExtras = criarCategoria($pdo, "Guarnições & Extras", "icon-sides.png");
    echo "<h3>Categoria: Guarnições (ID: $catExtras)</h3><ul>";

    criarProduto($pdo, $catExtras, "Arroz Branco", 12.00, "UN", "Porção grande (500g)");
    criarProduto($pdo, $catExtras, "Maionese da Casa", 15.00, "UN", "Pote 250g");
    criarProduto($pdo, $catExtras, "Farofa de Bacon", 10.00, "UN", "Crocante");
    echo "</ul>";

    // CATEGORIA 4: BEBIDAS
    $catBebidas = criarCategoria($pdo, "Bebidas", "icon-drink.png");
    echo "<h3>Categoria: Bebidas (ID: $catBebidas)</h3><ul>";

    criarProduto($pdo, $catBebidas, "Coca-Cola 2L", 14.00, "UN", "Garrafa Pet");
    criarProduto($pdo, $catBebidas, "Guaraná Antártica 2L", 12.00, "UN", "Garrafa Pet");
    criarProduto($pdo, $catBebidas, "Suco de Laranja", 18.00, "UN", "Natural 1L");
    echo "</ul>";

    echo "<hr><h2>✅ Cadastro Finalizado com Sucesso!</h2>";

} catch (PDOException $e) {
    echo "<h2 style='color:red'>Erro ao cadastrar: " . $e->getMessage() . "</h2>";
}
?>