<?php
// api/excluir_produto.php
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Origin: *");

$host = 'localhost'; $db = 'delivery_db'; $user = 'root'; $pass = ''; 
$dsn = "mysql:host=$host;dbname=$db;charset=utf8mb4";

try {
    $pdo = new PDO($dsn, $user, $pass);
    $dados = json_decode(file_get_contents("php://input"), true);

    if (empty($dados['id'])) throw new Exception("ID inválido");

    // Primeiro deletamos itens de pedidos antigos ligados a esse produto para não dar erro
    // (Ou você pode apenas marcar como 'disponivel = 0' se preferir manter histórico)
    // Aqui vamos deletar fisicamente:
    
    // Deleta o produto
    $stmt = $pdo->prepare("DELETE FROM produtos WHERE id = ?");
    $stmt->execute([$dados['id']]);

    echo json_encode(["sucesso" => true]);

} catch (Exception $e) {
    echo json_encode(["sucesso" => false, "erro" => "Erro: O produto pode estar ligado a pedidos antigos."]);
}
?>