<?php
session_start();
// Proteção de Login
if(!isset($_SESSION['admin_logado']) || $_SESSION['admin_logado'] !== true){
    header("Location: login.php");
    exit;
}

// Conexão
$host = 'localhost';
$db   = 'mgatvcom_pedidos';
$user = 'mgatvcom_pedidos';
$pass = 'fkNw*BV6#A;X';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro: " . $e->getMessage());
}

// Filtro de Data (Padrão: Hoje)
$data = isset($_GET['data']) ? $_GET['data'] : date('Y-m-d');

// SQL PODEROSA: Busca pedidos E o nome do entregador
$sql = "SELECT p.*, e.nome AS nome_moto 
        FROM pedidos p 
        LEFT JOIN entregadores e ON p.entregador_id = e.id 
        WHERE DATE(p.data_pedido) = :data 
        ORDER BY p.id DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute([':data' => $data]);
$pedidos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Cálculos
$faturamento = 0;
$entregas = 0;
foreach($pedidos as $p) {
    if($p['status'] == 'concluido') {
        $faturamento += $p['total'];
        $entregas++;
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatórios</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body { font-family: 'Segoe UI', sans-serif; background: #eaeff2; padding: 20px; }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .card { background: white; padding: 20px; border-radius: 8px; margin-bottom: 20px; box-shadow: 0 2px 5px rgba(0,0,0,0.05); }
        
        table { width: 100%; border-collapse: collapse; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #eee; }
        th { background: #f8f9fa; color: #555; }
        
        .status { padding: 5px 10px; border-radius: 15px; font-size: 0.8rem; font-weight: bold; }
        .status-concluido { background: #dff9fb; color: #2ecc71; }
        .status-cancelado { background: #ffe0e3; color: #e74c3c; }
        .status-pendente { background: #fff3cd; color: #f1c40f; }

        .resumo { display: flex; gap: 20px; margin-bottom: 20px; }
        .box { background: white; padding: 20px; flex: 1; border-radius: 8px; text-align: center; }
        .box h3 { margin: 0; color: #777; font-size: 0.9rem; }
        .box strong { font-size: 1.5rem; color: #2c3e50; }

        .btn-voltar { text-decoration: none; color: #555; font-weight: bold; background: #ddd; padding: 10px 20px; border-radius: 5px;}
    </style>
</head>
<body>

    <div class="header">
        <a href="index.php" class="btn-voltar">← Voltar</a>
        <h2>Relatório do Dia</h2>
        <form>
            <input type="date" name="data" value="<?php echo $data; ?>" onchange="this.form.submit()" style="padding:10px; border-radius:5px; border:1px solid #ccc;">
        </form>
    </div>

    <div class="resumo">
        <div class="box"><h3>Pedidos Concluídos</h3><strong><?php echo $entregas; ?></strong></div>
        <div class="box"><h3>Faturamento</h3><strong style="color:#27ae60">R$ <?php echo number_format($faturamento, 2, ',', '.'); ?></strong></div>
    </div>

    <div class="card">
        <table>
            <thead>
                <tr>
                    <th>#</th>
                    <th>Hora</th>
                    <th>Cliente</th>
                    <th>Entregador</th> <th>Status</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($pedidos) == 0): ?>
                    <tr><td colspan="6" style="text-align:center; padding:20px;">Nenhum pedido nesta data.</td></tr>
                <?php else: ?>
                    <?php foreach($pedidos as $p): ?>
                    <tr>
                        <td><?php echo $p['id']; ?></td>
                        <td><?php echo date('H:i', strtotime($p['data_pedido'])); ?></td>
                        <td>
                            <?php echo $p['cliente_nome']; ?><br>
                            <small style="color:#999"><?php echo $p['cliente_telefone']; ?></small>
                        </td>
                        <td>
                            <?php if($p['nome_moto']): ?>
                                <i class="fas fa-motorcycle"></i> <?php echo $p['nome_moto']; ?>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td>
                            <span class="status status-<?php echo $p['status']; ?>">
                                <?php echo ucfirst($p['status']); ?>
                            </span>
                        </td>
                        <td><strong>R$ <?php echo number_format($p['total'], 2, ',', '.'); ?></strong></td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</body>
</html>